/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.common.update;

import com.unboundid.common.util.FileUtils;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class FileUpdatePolicy {
    public static final String PARAM_MESSAGE = "message";
    private Map<File, Directive> directives = new HashMap<File, Directive>();
    private Map<File, Runnable> replaceActions;
    private Map<File, Runnable> deleteActions;
    private Map<File, Runnable> addActions;

    public void setReplaceAction(File file, Runnable action) {
        if (file != null && action != null) {
            if (this.replaceActions == null) {
                this.replaceActions = new HashMap<File, Runnable>();
            }
            this.replaceActions.put(file, action);
        }
    }

    public Runnable getReplaceAction(File file) {
        if (this.replaceActions != null) {
            return this.replaceActions.get(file);
        }
        return null;
    }

    public void setDeleteAction(File file, Runnable action) {
        if (file != null && action != null) {
            if (this.deleteActions == null) {
                this.deleteActions = new HashMap<File, Runnable>();
            }
            this.deleteActions.put(file, action);
        }
    }

    public Runnable getDeleteAction(File file) {
        if (this.deleteActions != null) {
            return this.deleteActions.get(file);
        }
        return null;
    }

    public void setAddAction(File file, Runnable action) {
        if (file != null && action != null) {
            if (this.addActions == null) {
                this.addActions = new HashMap<File, Runnable>();
            }
            this.addActions.put(file, action);
        }
    }

    public Runnable getAddAction(File file) {
        if (this.addActions != null) {
            return this.addActions.get(file);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadBuildTimeDirectives(File directivesFile, File rootToUpdate) throws IOException {
        Properties pathsToDirectives = new Properties();
        FileReader directivesReader = null;
        try {
            directivesReader = new FileReader(directivesFile);
            pathsToDirectives.load(directivesReader);
            for (String path : pathsToDirectives.stringPropertyNames()) {
                File file = new File(rootToUpdate, path);
                String directiveStr = pathsToDirectives.getProperty(path);
                Directive directive = Directive.valueOf(directiveStr);
                this.directives.put(file, directive);
            }
        }
        catch (Throwable throwable) {
            FileUtils.close(directivesReader);
            throw throwable;
        }
        FileUtils.close(directivesReader);
    }

    public Directive getDirective(File file) {
        Directive directive = this.directives.get(file);
        if (directive == null) {
            for (File parent = file.getParentFile(); directive == null && parent != null; parent = parent.getParentFile()) {
                directive = this.directives.get(parent);
            }
        }
        return directive;
    }

    public void setDirective(File file, Directive directive) {
        this.directives.put(file, directive);
    }

    public static enum Directive {
        REPLACE,
        IGNORE,
        IGNORE_IF_MODIFIED,
        DELETE,
        BACKUP,
        SPECIAL;

    }
}

