/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.common.util;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class BerkeleyDbJarLocator {
    private File libDir;

    public static Set<File> find(File libDir) throws IOException {
        return new BerkeleyDbJarLocator(libDir).find();
    }

    private BerkeleyDbJarLocator(File libDir) {
        if (!libDir.exists()) {
            throw new IllegalArgumentException("Directory " + libDir.getPath() + " does not exist");
        }
        if (!libDir.isDirectory()) {
            throw new IllegalArgumentException("File " + libDir.getPath() + " is not a directory");
        }
        this.libDir = libDir;
    }

    private Set<File> find() throws IOException {
        HashSet<File> jeJarFiles = new HashSet<File>();
        File[] files = this.libDir.listFiles();
        if (files != null) {
            for (File file : files) {
                try {
                    if (!this.isBerkleyDbJar(file)) continue;
                    jeJarFiles.add(file);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return jeJarFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isBerkleyDbJar(File file) throws IOException {
        if (file != null && file.getName().endsWith(".jar")) {
            JarFile jarFile = null;
            try {
                jarFile = new JarFile(file);
                Manifest manifest = jarFile.getManifest();
                if (manifest != null) {
                    Attributes attrs = manifest.getMainAttributes();
                    for (Object attr : attrs.values()) {
                        if (!attr.toString().contains("sleepycat")) continue;
                        boolean bl = true;
                        return bl;
                    }
                }
                boolean bl = false;
                return bl;
            }
            finally {
                if (jarFile != null) {
                    try {
                        jarFile.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return false;
    }
}

