/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.common.util;

import com.google.common.base.CaseFormat;
import com.unboundid.common.util.CollectionUtils;
import com.unboundid.common.util.TextUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class CaseConverter {
    private final Map<String, String> conversionMap = new ConcurrentHashMap<String, String>();
    private final Map<String, String> specialCases;
    private final List<String> abbreviations = new ArrayList<String>();

    public CaseConverter(Set<String> abbreviationSet) {
        this(abbreviationSet, null);
    }

    public CaseConverter(Set<String> abbreviationSet, Map<String, String> specialCasesMap) {
        if (abbreviationSet != null) {
            this.abbreviations.addAll(abbreviationSet);
            Collections.sort(this.abbreviations, new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    return Integer.compare(o2.length(), o1.length());
                }
            });
        }
        this.specialCases = new ConcurrentHashMap<String, String>();
        if (specialCasesMap != null) {
            this.specialCases.putAll(specialCasesMap);
        }
    }

    public void addSpecialCase(String token, String caseString) {
        this.specialCases.put(token, caseString);
    }

    public String camelToHyphen(String camelString) {
        if (camelString == null) {
            return null;
        }
        String hyphenString = this.conversionMap.get(camelString.toLowerCase());
        if (hyphenString == null) {
            hyphenString = camelString.trim();
            if (this.abbreviations != null) {
                for (String abbreviation : this.abbreviations) {
                    int i = 0;
                    while ((i = hyphenString.indexOf(abbreviation, i)) >= 0) {
                        hyphenString = hyphenString.substring(0, i) + TextUtils.capitalize(abbreviation.toLowerCase()) + hyphenString.substring(i + abbreviation.length());
                    }
                }
            }
            hyphenString = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_HYPHEN, hyphenString);
        }
        return hyphenString;
    }

    public String hyphenToLowerCamel(String hyphenString) {
        if (hyphenString == null || hyphenString.length() == 0) {
            return hyphenString;
        }
        ArrayList<String> tokens = new ArrayList<String>();
        for (String token : TextUtils.splitHyphens(hyphenString)) {
            if (this.abbreviations != null && this.abbreviations.contains(token.toUpperCase())) {
                if (tokens.isEmpty()) {
                    tokens.add(token.toLowerCase());
                    continue;
                }
                tokens.add(token.toUpperCase());
                continue;
            }
            if (this.specialCases.keySet().contains(token)) {
                tokens.add(this.specialCases.get(token));
                continue;
            }
            if (tokens.isEmpty()) {
                tokens.add(token.toLowerCase());
                continue;
            }
            tokens.add(TextUtils.capitalize(token));
        }
        String camelString = CollectionUtils.listToString(tokens, "");
        this.conversionMap.put(camelString.toLowerCase(), hyphenString);
        return camelString;
    }

    public String hyphenToUpperCamel(String hyphenString) {
        String cc = this.hyphenToLowerCamel(hyphenString);
        if (cc != null) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < cc.length(); ++i) {
                char c = cc.charAt(i);
                if (Character.isUpperCase(c)) {
                    String firstToken = sb.toString();
                    if (this.abbreviations.contains(firstToken.toUpperCase())) {
                        return firstToken.toUpperCase() + cc.substring(i);
                    }
                    return TextUtils.capitalize(firstToken) + cc.substring(i);
                }
                sb.append(c);
            }
            return TextUtils.capitalize(sb.toString());
        }
        return null;
    }
}

