/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.common.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.RandomAccess;

public final class CollectionUtils {
    public static <T> List<T> list(T ... contents) {
        return Collections.unmodifiableList(Arrays.asList(contents));
    }

    public static boolean listsAreEqual(List<?> list1, List<?> list2) {
        if (list1 == null) {
            return list2 == null;
        }
        if (list2 == null) {
            return false;
        }
        int numElements = list1.size();
        if (numElements != list2.size()) {
            return false;
        }
        if (!(list1 instanceof RandomAccess) || !(list2 instanceof RandomAccess)) {
            return list1.equals(list2);
        }
        for (int i = 0; i < numElements; ++i) {
            Object o1 = list1.get(i);
            Object o2 = list2.get(i);
            if (!(o1 == null ? o2 != null : !o1.equals(o2))) continue;
            return false;
        }
        return true;
    }

    public static String[] listToArray(List<String> stringList) {
        if (stringList == null) {
            return null;
        }
        String[] stringArray = new String[stringList.size()];
        stringList.toArray(stringArray);
        return stringArray;
    }

    public static String listToString(List<?> list, String separator) {
        return CollectionUtils.listToString(list, null, null, separator);
    }

    public static String listToString(List<?> list, String prefix, String suffix, String separator) {
        return CollectionUtils.listToString(list, prefix, suffix, separator, null, false, false);
    }

    public static String listToString(List<?> list, String prefix, String suffix, String separator, String conjunction, boolean serialSeparator, boolean padElements) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < list.size(); ++i) {
            if (prefix != null) {
                sb.append(prefix);
            }
            sb.append(list.get(i));
            if (suffix != null) {
                sb.append(suffix);
            }
            if (i >= list.size() - 1) continue;
            if (i == list.size() - 2 && conjunction != null) {
                if (serialSeparator && list.size() > 2) {
                    sb.append(separator);
                }
                if (padElements) {
                    sb.append(" ");
                }
                sb.append(conjunction);
                if (!padElements) continue;
                sb.append(" ");
                continue;
            }
            if (list.size() <= 2) continue;
            sb.append(separator);
            if (!padElements) continue;
            sb.append(" ");
        }
        return sb.toString();
    }

    public static <T> T cast(Object genericCollection) {
        return (T)genericCollection;
    }
}

