/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.common.util;

import com.unboundid.common.util.tools.PBKDF2WithHmacSHA256FileDigest;
import com.unboundid.util.CryptoHelper;
import com.unboundid.util.StaticUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class FileDigest {
    private MessageDigest messageDigest;

    public static FileDigest usingMd5() {
        try {
            return new FileDigest("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
    }

    public static FileDigest usingSHA256() {
        try {
            return new FileDigest("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
    }

    public static FileDigest usingPBKDF2WithHmacSHA256() {
        return new PBKDF2WithHmacSHA256FileDigest();
    }

    public String hexStringForFile(File file) throws IOException {
        byte[] digest = this.digestForFile(file);
        if (digest != null) {
            return FileDigest.getHexString(digest);
        }
        return null;
    }

    public String getDigestAlgorithm() {
        return this.messageDigest.getAlgorithm();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] digestForFile(File file) throws IOException {
        MessageDigest localMessageDigest = null;
        try {
            localMessageDigest = (MessageDigest)this.messageDigest.clone();
        }
        catch (CloneNotSupportedException cnse) {
            return null;
        }
        InputStream is = new FileInputStream(file);
        try {
            is = new DigestInputStream(is, localMessageDigest);
            byte[] buffer = new byte[1024];
            int numRead = 0;
            while ((numRead = is.read(buffer)) != -1) {
            }
            byte[] byArray = localMessageDigest.digest();
            return byArray;
        }
        finally {
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
    }

    protected FileDigest() {
    }

    public FileDigest(String algorithm) throws NoSuchAlgorithmException {
        this.messageDigest = CryptoHelper.getMessageDigest((String)algorithm);
    }

    private static String getHexString(byte[] byteArray) {
        StringBuilder buffer = new StringBuilder(2 * byteArray.length);
        for (byte b : byteArray) {
            buffer.append(StaticUtils.toHex((byte)b));
        }
        return buffer.toString();
    }
}

