/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.common.util;

import com.unboundid.common.messages.UBIDCommonMessages;
import com.unboundid.common.util.tools.ToolConstants;
import com.unboundid.messages.Message;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class FileUtils {
    public static boolean recursiveDelete(File file) {
        File[] childList;
        if (!file.exists()) {
            return true;
        }
        boolean successful = true;
        if (file.isDirectory() && (childList = file.listFiles()) != null) {
            for (File f : childList) {
                successful &= FileUtils.recursiveDelete(f);
            }
        }
        return successful & file.delete();
    }

    public static File copyFile(File fileToCopy, File targetDirectory) throws IOException {
        return FileUtils.copyFile(fileToCopy, targetDirectory, fileToCopy.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File copyFile(File fileToCopy, File targetDirectory, String newName) throws IOException {
        if (!fileToCopy.exists()) {
            Message message = UBIDCommonMessages.ERR_MOVEFILE_NO_SUCH_FILE.get((Object)fileToCopy.getPath());
            throw new IOException(message.toString());
        }
        if (!fileToCopy.isFile()) {
            Message message = UBIDCommonMessages.ERR_MOVEFILE_NOT_FILE.get((Object)fileToCopy.getPath());
            throw new IOException(message.toString());
        }
        if (!targetDirectory.exists()) {
            Message message = UBIDCommonMessages.ERR_MOVEFILE_NO_SUCH_DIRECTORY.get((Object)targetDirectory.getPath());
            throw new IOException(message.toString());
        }
        if (!targetDirectory.isDirectory()) {
            Message message = UBIDCommonMessages.ERR_MOVEFILE_NOT_DIRECTORY.get((Object)targetDirectory.getPath());
            throw new IOException(message.toString());
        }
        File newFile = new File(targetDirectory.getPath() + File.separator + newName);
        FileInputStream inputStream = null;
        FileOutputStream outputStream = null;
        try {
            int bytesRead;
            inputStream = new FileInputStream(fileToCopy);
            outputStream = new FileOutputStream(newFile, false);
            byte[] buffer = new byte[8192];
            while ((bytesRead = inputStream.read(buffer)) >= 0) {
                outputStream.write(buffer, 0, bytesRead);
            }
        }
        catch (Throwable throwable) {
            FileUtils.close(outputStream);
            FileUtils.close(inputStream);
            throw throwable;
        }
        FileUtils.close(outputStream);
        FileUtils.close(inputStream);
        return newFile;
    }

    public static File moveFile(File fileToMove, File targetDirectory) throws IOException {
        File newFile = FileUtils.copyFile(fileToMove, targetDirectory);
        fileToMove.delete();
        return newFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void renameFile(File fileToRename, File target) throws IOException {
        if (fileToRename != null && target != null) {
            File file = target;
            synchronized (file) {
                if (target.exists() && !target.delete()) {
                    Message message = UBIDCommonMessages.ERR_RENAMEFILE_CANNOT_DELETE_TARGET.get((Object)target.getPath());
                    throw new IOException(message.toString());
                }
            }
            if (!fileToRename.renameTo(target)) {
                Message message = UBIDCommonMessages.ERR_RENAMEFILE_CANNOT_RENAME.get((Object)fileToRename.getPath(), (Object)target.getPath());
                throw new IOException(message.toString());
            }
        }
    }

    public static long primeFilesRecursively(File f) {
        return FileUtils.primeFilesRecursively(f, new byte[65536]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long primeFilesRecursively(File f, byte[] buffer) {
        long totalBytesRead;
        block15: {
            block14: {
                totalBytesRead = 0L;
                if (!f.isDirectory()) break block14;
                for (File subFile : FileUtils.listFiles(f)) {
                    totalBytesRead += FileUtils.primeFilesRecursively(subFile, buffer);
                }
                break block15;
            }
            if (f.length() <= 0L) break block15;
            FileInputStream fis = null;
            try {
                int bytesRead;
                fis = new FileInputStream(f);
                while ((bytesRead = fis.read(buffer)) > 0) {
                    totalBytesRead += (long)bytesRead;
                }
            }
            catch (Exception exception) {
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return totalBytesRead;
    }

    public static boolean isDescendant(File descendant, File ancestor) {
        boolean isDescendant = false;
        if (descendant != null && ancestor != null) {
            File ancestorCanonical;
            File descendantCanonical;
            try {
                descendantCanonical = descendant.getCanonicalFile();
            }
            catch (IOException ioe) {
                descendantCanonical = descendant;
            }
            try {
                ancestorCanonical = ancestor.getCanonicalFile();
            }
            catch (IOException ioe) {
                ancestorCanonical = ancestor;
            }
            File parent = descendantCanonical.getParentFile();
            while (parent != null && !isDescendant) {
                isDescendant = parent.equals(ancestorCanonical);
                if (isDescendant) continue;
                parent = parent.getParentFile();
            }
        }
        return isDescendant;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeContents(OutputStream output, File fileToWrite) throws IOException {
        int bufferSize = 8192;
        BufferedInputStream input = new BufferedInputStream(new FileInputStream(fileToWrite), 8192);
        try {
            int bytesRead;
            byte[] buffer = new byte[8192];
            while ((bytesRead = input.read(buffer)) != -1) {
                output.write(buffer, 0, bytesRead);
            }
        }
        finally {
            try {
                input.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static void writeToFile(File toFile, String string) throws IOException {
        if (!toFile.exists() && !toFile.createNewFile()) {
            throw new IOException("Failed to create file " + toFile.getPath());
        }
        try (PrintWriter writer = null;){
            writer = new PrintWriter(new FileOutputStream(toFile));
            writer.write(string);
        }
    }

    public static String getRelativePath(File file, File ancestor) {
        String path = FileUtils.getPath(file);
        if (ancestor != null) {
            path = FileUtils.getRelativePath(path, FileUtils.getPath(ancestor));
        }
        return path;
    }

    public static String getRelativePath(String path, String ancestor) {
        if (ancestor != null && path.startsWith(ancestor) && (path = path.substring(ancestor.length())).startsWith(File.separator)) {
            path = path.substring(File.separator.length());
        }
        return path;
    }

    public static String getCanonicalPath(File file) {
        String path;
        try {
            path = file.getCanonicalPath();
        }
        catch (IOException ioe) {
            path = file.getPath();
        }
        return path;
    }

    public static boolean equals(File file1, File file2) {
        File f2;
        File f1;
        if (file1 == null && file2 == null) {
            return true;
        }
        if (file1 == null || file2 == null) {
            return false;
        }
        try {
            f1 = file1.getCanonicalFile();
        }
        catch (IOException ioe) {
            f1 = file1;
        }
        try {
            f2 = file2.getCanonicalFile();
        }
        catch (IOException ioe) {
            f2 = file2;
        }
        return f1.equals(f2);
    }

    public static boolean deleteFileRecursively(File file) {
        if (file.isDirectory()) {
            String[] children = file.list();
            if (children != null) {
                for (String aChildren : children) {
                    if (FileUtils.deleteFileRecursively(new File(file, aChildren))) continue;
                    return false;
                }
                if (!file.delete()) {
                    return false;
                }
            }
        } else if (!file.delete()) {
            return false;
        }
        return true;
    }

    public static String getPath(File f) {
        String path = null;
        if (f != null) {
            try {
                f = f.getCanonicalFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            path = f.toString();
        }
        return path;
    }

    public static void searchAndReplace(File templateFile, Map<String, String> valueMap) throws IOException {
        File backup = new File(templateFile.getParentFile(), templateFile.getName() + ".orig");
        if (!backup.exists() && !templateFile.renameTo(backup)) {
            throw new IOException(UBIDCommonMessages.ERR_CANNOT_RENAME_FILE.get((Object)templateFile.getPath(), (Object)backup.getPath()).toString());
        }
        if (templateFile.exists() && !templateFile.delete()) {
            throw new IOException(UBIDCommonMessages.ERR_CANNOT_DELETE_FILE.get((Object)templateFile.getPath()).toString());
        }
        FileUtils.searchAndReplace(backup, templateFile, valueMap, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void searchAndReplace(File sourceFile, File targetFile, Map<String, String> valueMap, List<String> prelude) throws IOException {
        FileWriter writer;
        block8: {
            FileReader sourceReader;
            block7: {
                sourceReader = null;
                BufferedReader reader = null;
                writer = null;
                try {
                    String line;
                    sourceReader = new FileReader(sourceFile);
                    reader = new BufferedReader(sourceReader);
                    writer = new FileWriter(targetFile);
                    if (prelude != null) {
                        for (String line2 : prelude) {
                            writer.write(FileUtils.replace(line2, valueMap));
                            writer.write(ToolConstants.EOL);
                        }
                    }
                    while (null != (line = reader.readLine())) {
                        writer.write(FileUtils.replace(line, valueMap));
                        writer.write(ToolConstants.EOL);
                    }
                    if (reader == null) break block7;
                }
                catch (Throwable throwable) {
                    if (reader != null) {
                        FileUtils.close(reader);
                    } else {
                        FileUtils.close(sourceReader);
                    }
                    FileUtils.close(writer);
                    throw throwable;
                }
                FileUtils.close(reader);
                break block8;
            }
            FileUtils.close(sourceReader);
        }
        FileUtils.close(writer);
    }

    private static String replace(String line, Map<String, String> valueMap) {
        if (line.contains("${")) {
            for (String variableName : valueMap.keySet()) {
                String variable = "${" + variableName + "}";
                if (!line.contains(variable)) continue;
                line = line.replace(variable, valueMap.get(variableName));
            }
        }
        return line;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> listZipContents(File zipArchive) throws IOException {
        FileInputStream fis = null;
        ZipInputStream zis = null;
        try {
            ZipEntry zipEntry;
            fis = new FileInputStream(zipArchive);
            zis = new ZipInputStream(fis);
            ArrayList<String> contents = new ArrayList<String>();
            while ((zipEntry = zis.getNextEntry()) != null) {
                contents.add(zipEntry.getName());
            }
            ArrayList<String> arrayList = contents;
            return arrayList;
        }
        finally {
            if (zis != null) {
                try {
                    zis.close();
                }
                catch (Exception exception) {}
            }
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static File[] listFiles(File file) {
        if (file != null && file.isDirectory()) {
            try {
                File[] files = file.listFiles();
                if (files != null) {
                    return files;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new File[0];
    }

    public static void close(Reader reader) {
        if (reader != null) {
            try {
                reader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void close(Writer writer) {
        if (writer != null) {
            try {
                writer.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void close(InputStream inputStream) {
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void close(OutputStream outputStream) {
        if (outputStream != null) {
            try {
                outputStream.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                outputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<File, byte[]> getFileContentsFromZip(File zipFile, FilenameFilter filter) throws IOException {
        LinkedHashMap<File, byte[]> linkedHashMap;
        ZipInputStream zipInputStream = null;
        try {
            zipInputStream = new ZipInputStream(new FileInputStream(zipFile));
            LinkedHashMap<File, byte[]> extractedFiles = new LinkedHashMap<File, byte[]>();
            ByteArrayOutputStream bout = new ByteArrayOutputStream(8192);
            byte[] buffer = new byte[8192];
            ZipEntry entry = zipInputStream.getNextEntry();
            while (entry != null) {
                File file = new File(entry.getName());
                if (!entry.isDirectory() && (filter == null || filter.accept(file.getParentFile(), file.getName()))) {
                    bout.reset();
                    int bytesRead = zipInputStream.read(buffer);
                    while (bytesRead > 0) {
                        bout.write(buffer, 0, bytesRead);
                        bytesRead = zipInputStream.read(buffer);
                    }
                    zipInputStream.closeEntry();
                    extractedFiles.put(file, bout.toByteArray());
                }
                entry = zipInputStream.getNextEntry();
            }
            linkedHashMap = extractedFiles;
        }
        catch (Throwable throwable) {
            FileUtils.close(zipInputStream);
            throw throwable;
        }
        FileUtils.close(zipInputStream);
        return linkedHashMap;
    }
}

