/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.common.util;

import com.unboundid.common.debug.CommonDebugTracer;
import com.unboundid.common.debug.DebugLogger;
import com.unboundid.common.loggers.ErrorLogger;
import com.unboundid.common.types.UnboundIDException;
import com.unboundid.common.util.TestUtils;
import com.unboundid.messages.Category;
import com.unboundid.messages.Message;
import com.unboundid.messages.Severity;
import com.unboundid.util.StaticUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;

public class Validator {
    private static final CommonDebugTracer TRACER = DebugLogger.getTracer();
    public static final boolean ENABLE_CHECKS = true;
    private static final String[] PARAM_DESCRIPTIONS = new String[]{"** A ZERO-BASED INDEX IS INVALID **", "(1st parameter)", "(2nd parameter)", "(3rd parameter)", "(4th parameter)", "(5th parameter)", "(6th parameter)", "(7th parameter)", "(8th parameter)", "(9th parameter)", "(10th parameter)"};
    private static long _errorCount = 0L;

    public static boolean ensureNotNull(Object param) throws RuntimeException {
        if (param == null) {
            Validator.throwNull("");
        }
        return true;
    }

    public static boolean ensureNotNull(Object param1, Object param2) throws RuntimeException {
        if (param1 == null) {
            Validator.throwNull(PARAM_DESCRIPTIONS[1]);
        }
        if (param2 == null) {
            Validator.throwNull(PARAM_DESCRIPTIONS[2]);
        }
        return true;
    }

    public static boolean ensureNotNull(Object param1, Object param2, Object param3) throws RuntimeException {
        if (param1 == null) {
            Validator.throwNull(PARAM_DESCRIPTIONS[1]);
        }
        if (param2 == null) {
            Validator.throwNull(PARAM_DESCRIPTIONS[2]);
        }
        if (param3 == null) {
            Validator.throwNull(PARAM_DESCRIPTIONS[3]);
        }
        return true;
    }

    public static boolean ensureNotNull(Object param1, Object param2, Object param3, Object param4) throws RuntimeException {
        if (param1 == null) {
            Validator.throwNull(PARAM_DESCRIPTIONS[1]);
        }
        if (param2 == null) {
            Validator.throwNull(PARAM_DESCRIPTIONS[2]);
        }
        if (param3 == null) {
            Validator.throwNull(PARAM_DESCRIPTIONS[3]);
        }
        if (param4 == null) {
            Validator.throwNull(PARAM_DESCRIPTIONS[4]);
        }
        return true;
    }

    public static boolean ensureNotNull(Object param1, Object param2, Object param3, Object param4, Object param5) throws RuntimeException {
        if (param1 == null) {
            Validator.throwNull(PARAM_DESCRIPTIONS[1]);
        }
        if (param2 == null) {
            Validator.throwNull(PARAM_DESCRIPTIONS[2]);
        }
        if (param3 == null) {
            Validator.throwNull(PARAM_DESCRIPTIONS[3]);
        }
        if (param4 == null) {
            Validator.throwNull(PARAM_DESCRIPTIONS[4]);
        }
        if (param5 == null) {
            Validator.throwNull(PARAM_DESCRIPTIONS[5]);
        }
        return true;
    }

    public static boolean ensureTrue(boolean condition) throws RuntimeException {
        if (!condition) {
            Validator.ensureTrue(condition, "");
        }
        return true;
    }

    public static boolean ensureTrue(boolean condition, String message) throws RuntimeException {
        if (!condition) {
            StringBuilder mb = new StringBuilder();
            mb.append("The specified condition must be true. ");
            mb.append(message);
            String fullString = Validator.generateLineSpecificErrorString(mb.toString());
            Validator.logError(fullString);
            throw new RuntimeException(fullString);
        }
        return true;
    }

    public static void violation(String message) throws RuntimeException {
        Validator.throwViolation(message);
    }

    public static void rethrowUnexpectedException(Throwable ex) throws RuntimeException {
        Validator.logUnexpectedError(ex);
        String fullString = Validator.generateLineSpecificErrorString("Caught an exception that was unexpected. " + ex.toString());
        Validator.throwViolation(fullString);
    }

    public static RuntimeException newRuntimeException(String message) {
        StringBuilder mb = new StringBuilder();
        mb.append("The following constraint was violated. ");
        mb.append(message);
        String fullString = Validator.generateLineSpecificErrorString(mb.toString());
        Validator.logError(fullString);
        return new RuntimeException(fullString);
    }

    public static void logUnexpectedError(String message) {
        Validator.logError("The server experienced an unexpected error.  Please report this problem and include this log file.  " + message);
    }

    public static void logUnexpectedErrorIfUnitTests(String message) {
        TRACER.debugWarning(message);
        if (TestUtils.isWithinUnitTest()) {
            Validator.logUnexpectedError(message);
        }
    }

    public static void logUnexpectedError(Throwable t) {
        Validator.logError("The server experienced an unexpected error.  Please report this problem and include this log file.  " + UnboundIDException.stackTraceToSingleLineString(t));
    }

    public static void logUnexpectedErrorIfUnitTests(Throwable t) {
        if (TestUtils.isWithinUnitTest()) {
            Validator.logUnexpectedError(t);
        }
    }

    public static synchronized long getErrorCount() {
        return _errorCount;
    }

    public static synchronized void resetErrorCount() {
        _errorCount = 0L;
    }

    private static synchronized void incrementErrorCount() {
        ++_errorCount;
    }

    private static String generateLineSpecificErrorString(String message) {
        StringBuilder mb = new StringBuilder();
        mb.append(message);
        mb.append("  The error occurred at ");
        mb.append(Validator.getOriginalCallerLineInfo());
        return mb.toString();
    }

    private static void throwNull(String message) throws RuntimeException {
        StringBuilder mb = new StringBuilder();
        mb.append("The specified parameter must not be null. ");
        mb.append(message);
        String fullString = Validator.generateLineSpecificErrorString(mb.toString());
        Validator.logError(fullString);
        throw new RuntimeException(fullString);
    }

    private static void throwViolation(String message) throws RuntimeException {
        StringBuilder mb = new StringBuilder();
        mb.append("The following constraint was violated. ");
        mb.append(message);
        String fullString = Validator.generateLineSpecificErrorString(mb.toString());
        Validator.logError(fullString);
        throw new RuntimeException(fullString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private static void logError(String message) {
        if (TestUtils.isWithinUnitTest()) {
            message = "Validator Error: " + message + " via call stack " + Validator.getBacktrace();
        }
        if (TestUtils.isWithinUnitTestExternalInstance() && Validator.getServerRoot() != null) {
            File marker = new File(Validator.getServerRoot(), "logs/validator-errors");
            Class<Validator> clazz = Validator.class;
            // MONITORENTER : com.unboundid.common.util.Validator.class
            try (PrintWriter writer = null;){
                SimpleDateFormat format = new SimpleDateFormat("dd/MMM/yyyy:HH:mm:ss.SSS Z");
                writer = new PrintWriter(new FileOutputStream(marker, true));
                writer.print("[" + format.format(new Date()) + "] ");
                writer.println(message);
                writer.println();
            }
            // MONITOREXIT : clazz
        }
        Validator.incrementErrorCount();
        StringBuilder mb = new StringBuilder();
        mb.append(message);
        mb.append(StaticUtils.EOL);
        mb.append(Validator.getCallingStack());
        String messageWithStack = mb.toString();
        if (TRACER.isErrorEnabled()) {
            TRACER.debugError(messageWithStack);
        }
        ErrorLogger.log(Message.raw((Category)Category.UTIL, (Severity)Severity.SEVERE_ERROR, (CharSequence)messageWithStack, (Object[])new Object[0]));
    }

    private static String getOriginalCallerLineInfo() {
        StackTraceElement[] stackElements = Thread.currentThread().getStackTrace();
        int callerIndex = Validator.getOriginalCallerStackIndex(stackElements);
        return stackElements[callerIndex].toString();
    }

    private static String getCallingStack() {
        StackTraceElement[] stackElements = Thread.currentThread().getStackTrace();
        int callerIndex = Validator.getOriginalCallerStackIndex(stackElements);
        StringBuilder buffer = new StringBuilder();
        for (int i = callerIndex; i < stackElements.length; ++i) {
            StackTraceElement stackElement = stackElements[i];
            buffer.append(stackElement).append(StaticUtils.EOL);
        }
        buffer.append(StaticUtils.EOL);
        return buffer.toString();
    }

    private static int getOriginalCallerStackIndex(StackTraceElement[] stack) {
        int i;
        StackTraceElement element = null;
        for (i = 0; i < stack.length && ((element = stack[i]).getClassName().equals(Validator.class.getName()) || element.getClassName().equals(Thread.class.getName())); ++i) {
        }
        return i;
    }

    public static String getBacktrace() {
        StringBuilder buffer = new StringBuilder();
        StackTraceElement[] elements = Thread.currentThread().getStackTrace();
        if (elements.length > 1) {
            Validator.appendElement(buffer, elements[2]);
            for (int i = 3; i < elements.length; ++i) {
                buffer.append(" ");
                Validator.appendElement(buffer, elements[i]);
            }
        }
        return buffer.toString();
    }

    private static void appendElement(StringBuilder buffer, StackTraceElement e) {
        if (TestUtils.isWithinUnitTest()) {
            buffer.append(Validator.getPackagelessName(e.getClassName()));
            buffer.append(".");
            buffer.append(e.getMethodName());
            buffer.append("()");
        } else {
            buffer.append(e.getFileName());
        }
        buffer.append(":");
        buffer.append(e.getLineNumber());
    }

    private static String getPackagelessName(String className) {
        return className.replaceAll(".*\\.", "");
    }

    private static String getServerRoot() {
        String serverRootPath = System.getProperty("com.unboundid.directory.server.ServerRoot");
        if (serverRootPath == null) {
            serverRootPath = System.getenv("INSTANCE_ROOT");
        }
        return serverRootPath;
    }
}

