/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.common.util.cli;

import com.unboundid.common.messages.UBIDCommonMessages;
import com.unboundid.common.util.cli.CLIException;
import com.unboundid.common.util.cli.ConsoleInteraction;
import com.unboundid.messages.Message;
import com.unboundid.messages.MessageBuilder;
import java.util.ArrayList;
import java.util.List;

public class CLIUtils {
    public static boolean printMessages(List<Message> messages, ConsoleInteraction console, boolean isInteractive, boolean isIgnoreWarnings, boolean isQuiet) throws CLIException {
        ArrayList<Message> errors = new ArrayList<Message>();
        ArrayList<Message> warnings = new ArrayList<Message>();
        ArrayList<Message> info = new ArrayList<Message>();
        if (messages != null && !messages.isEmpty()) {
            for (Message m : messages) {
                if (m.isError()) {
                    errors.add(m);
                    continue;
                }
                if (m.isWarning()) {
                    warnings.add(m);
                    continue;
                }
                info.add(m);
            }
        }
        if (!errors.isEmpty()) {
            for (Message error : errors) {
                console.println();
                console.println(error);
            }
            return false;
        }
        if (!warnings.isEmpty()) {
            if (isInteractive) {
                for (Message warning : warnings) {
                    console.println();
                    if (console.confirmAction(new MessageBuilder(warning).append((CharSequence)"  ").append((CharSequence)UBIDCommonMessages.INFO_CONTINUE_PROMPT.get()).toMessage(), false)) continue;
                    return false;
                }
            } else if (isIgnoreWarnings) {
                for (Message warning : warnings) {
                    console.println();
                    console.println(warning);
                }
            } else {
                for (Message warning : warnings) {
                    console.println();
                    console.println(warning);
                }
                return false;
            }
        }
        if (!info.isEmpty() && !isQuiet) {
            for (Message i : info) {
                console.println();
                console.println(i);
            }
        }
        return true;
    }
}

