/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.common.util.cli;

import com.unboundid.common.messages.UBIDCommonMessages;
import com.unboundid.common.util.SystemUtils;
import com.unboundid.common.util.cli.CLIException;
import com.unboundid.common.util.cli.ConsoleInteraction;
import com.unboundid.common.util.cli.ValidationCallback;
import com.unboundid.messages.Message;
import com.unboundid.messages.MessageUtils;
import com.unboundid.util.ObjectPair;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;

public class HostPortValidationCallback
implements ValidationCallback<String> {
    private boolean testAvailable;

    public HostPortValidationCallback(boolean testAvailable) {
        this.testAvailable = testAvailable;
    }

    public boolean isTestAvailable() {
        return this.testAvailable;
    }

    public void setTestAvailable(boolean testAvailable) {
        this.testAvailable = testAvailable;
    }

    @Override
    public String validate(ConsoleInteraction app, String input) throws CLIException {
        String ninput = input.trim();
        try {
            HostPortValidationCallback.parse(ninput);
            if (this.testAvailable) {
                List<Message> messages = this.testHostPort(ninput);
                if (MessageUtils.containsError(messages)) {
                    ninput = null;
                }
                if (messages != null && !messages.isEmpty()) {
                    for (Message m : messages) {
                        app.println();
                        app.println(m);
                    }
                }
            }
            return ninput;
        }
        catch (NumberFormatException e) {
            app.println();
            app.println(UBIDCommonMessages.ERR_BAD_PORT_NUMBER.get((Object)ninput));
            return null;
        }
        catch (IllegalArgumentException iae) {
            app.println();
            app.println(UBIDCommonMessages.ERR_BAD_HOST_PORT.get((Object)ninput));
            return null;
        }
    }

    protected List<Message> testHostPort(String hostPort) {
        ObjectPair<String, Integer> hostAndPort = HostPortValidationCallback.parse(hostPort);
        String host = (String)hostAndPort.getFirst();
        Integer port = (Integer)hostAndPort.getSecond();
        ArrayList<Message> messages = new ArrayList<Message>();
        InetSocketAddress address = new InetSocketAddress(host, (int)port);
        if (address.isUnresolved()) {
            messages.add(UBIDCommonMessages.ERR_UNRESOLVABLE_HOST.get((Object)host));
        } else if (!SystemUtils.isPortInUse(host, port)) {
            messages.add(UBIDCommonMessages.ERR_UNAVAILABLE_HOST_PORT.get((Object)hostPort));
        }
        return messages;
    }

    protected static ObjectPair<String, Integer> parse(String hostPort) throws IllegalArgumentException {
        int i = hostPort.indexOf(":");
        if (i > 0) {
            String host = hostPort.substring(0, i);
            Integer port = Integer.parseInt(hostPort.substring(i + 1));
            HostPortValidationCallback.validateHost(host);
            HostPortValidationCallback.validatePort(port);
            return new ObjectPair((Object)host, (Object)port);
        }
        throw new IllegalArgumentException();
    }

    private static void validateHost(String host) {
    }

    private static void validatePort(int port) {
        if (port < 1 || port >= 65535) {
            throw new NumberFormatException();
        }
    }
}

