/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.common.util.cli.wizard;

import com.unboundid.common.util.cli.CLIException;
import com.unboundid.common.util.cli.wizard.WizardAction;
import com.unboundid.common.util.cli.wizard.WizardState;
import com.unboundid.common.util.cli.wizard.WizardStep;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WizardController<S extends WizardState, U extends WizardStep> {
    private static final Logger LOG = Logger.getLogger(WizardController.class.getName());
    private List<? extends WizardStep<S>> steps = new ArrayList<WizardStep<S>>();
    private WizardStep<S> currentStep;
    private S state;
    private WizardAction lastAction = WizardAction.START;
    private boolean endWhenOutOfBounds = true;
    private int stepIndex = 0;
    private boolean runInvoked = false;
    private Logger logger = LOG;
    private WizardController parent;

    public WizardController(List<? extends WizardStep<S>> steps, S state) {
        this.steps = steps;
        this.state = state;
    }

    public S getState() {
        return this.state;
    }

    public int getCurrentStepIndex() {
        if (this.currentStep == null) {
            return -1;
        }
        return this.steps.indexOf(this.currentStep);
    }

    public boolean isEndWhenOutOfBounds() {
        return this.endWhenOutOfBounds;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        if (logger != null) {
            this.logger = logger;
        }
    }

    public void setEndWhenOutOfBounds(boolean endWhenOutOfBounds) {
        this.endWhenOutOfBounds = endWhenOutOfBounds;
    }

    public void reverse() {
        if (this.steps != null && !this.steps.isEmpty()) {
            this.stepIndex = this.steps.size() - 1;
        }
    }

    public WizardController getParent() {
        return this.parent;
    }

    public void setStepIndex(int i) {
        if (this.runInvoked) {
            throw new IllegalStateException("Run already invoked");
        }
        this.stepIndex = i;
    }

    public WizardAction getLastAction() {
        return this.lastAction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WizardAction run() throws CLIException {
        this.runInvoked = true;
        this.parent = ((WizardState)this.state).getController();
        if (this.parent != null) {
            this.setLogger(this.parent.getLogger());
        }
        ((WizardState)this.state).aquire(this);
        try {
            boolean done;
            boolean bl = done = this.steps == null || this.steps.isEmpty();
            while (!done) {
                this.currentStep = this.steps.get(this.stepIndex);
                WizardStep.DisplayDirective show = WizardStep.DisplayDirective.SKIP;
                try {
                    show = this.currentStep.initialize(this.state);
                }
                catch (Throwable t) {
                    LOG.log(Level.SEVERE, "Step " + this.currentStep + " threw unexpected exception during call to 'initialize()'.  Skipping step.", t);
                }
                switch (show) {
                    case CHILDREN: {
                        this.showChildSteps();
                        break;
                    }
                    case SELF: {
                        this.showStep();
                        break;
                    }
                    case SELF_THEN_CHILDREN: {
                        this.showStep();
                        this.showChildSteps();
                        break;
                    }
                    case SKIP: {
                        this.lastAction = ((WizardState)this.state).getPreviousAction();
                        if (this.lastAction != WizardAction.REPEAT) break;
                        this.lastAction = ((WizardState)this.state).getPreviousPreviousAction();
                    }
                }
                if (this.lastAction == null) {
                    throw new IllegalStateException("Step '" + this.steps.get(this.stepIndex).getTitle(this.state) + "' returned null action");
                }
                ((WizardState)this.state).setPreviousAction(this.lastAction);
                switch (this.lastAction) {
                    case START: {
                        if (this.stepIndex + 1 == this.steps.size()) {
                            if (this.endWhenOutOfBounds) {
                                done = true;
                                break;
                            }
                            this.lastAction = WizardAction.REPEAT;
                            break;
                        }
                        ++this.stepIndex;
                        break;
                    }
                    case NEXT: {
                        if (this.stepIndex + 1 == this.steps.size()) {
                            if (this.endWhenOutOfBounds) {
                                done = true;
                                break;
                            }
                            this.lastAction = WizardAction.REPEAT;
                            break;
                        }
                        ++this.stepIndex;
                        break;
                    }
                    case BACK: {
                        if (this.stepIndex == 0) {
                            if (this.endWhenOutOfBounds) {
                                done = true;
                                break;
                            }
                            this.lastAction = WizardAction.REPEAT;
                            break;
                        }
                        --this.stepIndex;
                        break;
                    }
                    case END: {
                        done = true;
                        break;
                    }
                    case CANCEL: {
                        done = true;
                    }
                }
            }
        }
        finally {
            ((WizardState)this.state).release();
        }
        return this.lastAction;
    }

    private void showChildSteps() throws CLIException {
        if (!this.currentStep.getChildren().isEmpty()) {
            this.currentStep.beforeChildren(this.state);
            int startIndex = this.currentStep.reverse(this.state) ? this.currentStep.getChildren().size() - 1 : 0;
            WizardController<S, U> subController = new WizardController<S, U>(this.currentStep.getChildren(), this.state);
            subController.setStepIndex(startIndex);
            subController.setEndWhenOutOfBounds(true);
            subController.run();
            this.lastAction = this.currentStep.afterChildren(this.state);
        }
    }

    private void showStep() throws CLIException {
        try {
            this.lastAction = this.currentStep.show(this.state);
        }
        catch (Throwable t) {
            if (t instanceof CLIException) {
                throw (CLIException)t;
            }
            throw new CLIException(t);
        }
    }
}

