/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.common.util.cli.wizard;

import com.unboundid.common.messages.UBIDCommonMessages;
import com.unboundid.common.util.cli.wizard.WizardAction;
import com.unboundid.common.util.cli.wizard.WizardController;
import com.unboundid.messages.Message;
import java.util.ArrayDeque;

public abstract class WizardState {
    protected Message quitWarning = UBIDCommonMessages.WARN_CFG_QUIT_WARNING.get();
    private WizardAction previousAction = WizardAction.START;
    private WizardAction previousPreviousAction = null;
    private ArrayDeque<WizardController> controllers = new ArrayDeque();

    public WizardAction getPreviousAction() {
        return this.previousAction;
    }

    public WizardAction getPreviousPreviousAction() {
        return this.previousPreviousAction;
    }

    public WizardController getController() {
        return this.controllers.peekFirst();
    }

    public boolean canGoBack() {
        WizardController controller = this.getController();
        return controller.getCurrentStepIndex() != 0;
    }

    void setPreviousAction(WizardAction previousAction) {
        this.previousPreviousAction = this.previousAction;
        this.previousAction = previousAction;
    }

    void aquire(WizardController controller) {
        this.controllers.push(controller);
    }

    void release() {
        this.controllers.pop();
    }

    void setQuitWarning(Message warning) {
        this.quitWarning = warning;
    }

    Message getQuitWarning() {
        return this.quitWarning;
    }
}

