/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.common.util.tools;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.common.util.FileDigest;
import com.unboundid.util.Base64;
import com.unboundid.util.ByteString;
import com.unboundid.util.ByteStringBuffer;
import com.unboundid.util.CryptoHelper;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.util.Arrays;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;

public class PBKDF2WithHmacSHA256FileDigest
extends FileDigest {
    SecureRandom random = CryptoHelper.getSecureRandom();

    @Override
    public String getDigestAlgorithm() {
        return "PBKDF2WithHmacSHA256";
    }

    @Override
    public byte[] digestForFile(File file) throws IOException {
        byte[] contents = Files.readAllBytes(file.toPath());
        ASN1OctetString str = new ASN1OctetString(contents);
        try {
            return this.encodeValuePBKDF2((ByteString)str).getValue();
        }
        catch (GeneralSecurityException e) {
            throw new IOException("Failed to create digest for file " + file.getAbsolutePath(), e);
        }
    }

    private ByteString encodeValuePBKDF2(ByteString plaintext) throws GeneralSecurityException {
        boolean encodingVersion = true;
        int saltLengthBytes = 8;
        int iterationCount = 4096;
        int derivedKeyLengthBytes = 32;
        byte[] salt = new byte[8];
        this.random.nextBytes(salt);
        char[] passwordChars = plaintext.stringValue().toCharArray();
        byte[] keyBytes = PBKDF2WithHmacSHA256FileDigest.encode(passwordChars, salt, 4096, 32);
        Arrays.fill(passwordChars, '\u0000');
        ByteStringBuffer rawBuffer = new ByteStringBuffer();
        rawBuffer.append((byte)1);
        rawBuffer.append((byte)(salt.length & 0x7F));
        rawBuffer.append(salt);
        rawBuffer.append((byte)16);
        rawBuffer.append((byte)0);
        rawBuffer.append(keyBytes);
        ByteStringBuffer stringBuffer = new ByteStringBuffer();
        Base64.encode((byte[])rawBuffer.getBackingArray(), (int)0, (int)rawBuffer.length(), (ByteStringBuffer)stringBuffer);
        return stringBuffer.toByteString();
    }

    private static byte[] encode(char[] valueChars, byte[] salt, int iterationCount, int derivedKeyLengthBytes) throws GeneralSecurityException {
        try {
            SecretKeyFactory keyFactory = CryptoHelper.getSecretKeyFactory((String)"PBKDF2WithHmacSHA256");
            PBEKeySpec keySpec = new PBEKeySpec(valueChars, salt, iterationCount, derivedKeyLengthBytes * 8);
            SecretKey secretKey = keyFactory.generateSecret(keySpec);
            return secretKey.getEncoded();
        }
        catch (AssertionError e) {
            throw new GeneralSecurityException(((Throwable)((Object)e)).getMessage(), (Throwable)((Object)e));
        }
    }
}

