/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.authnselection.ui;

import java.io.Serializable;
import org.sourceid.saml20.adapter.gui.FilterableSelectionFieldDescriptor;
import org.sourceid.saml20.domain.AuthnSelectorInstance;
import org.sourceid.saml20.domain.IdpAuthnAdapterInstance;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.service.AdapterAuthnSourceKey;
import org.sourceid.saml20.service.AuthnSourceKey;
import org.sourceid.saml20.service.IdpConnAuthnSourceKey;

public class AsActionOption
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String id;
    private final Type type;

    public AsActionOption(AuthnSourceKey authnSourceKey) {
        this.id = authnSourceKey.getId();
        if (authnSourceKey.getType() == AuthnSourceKey.AuthnSourceType.ADAPTER) {
            this.type = Type.ADAPTER;
        } else if (authnSourceKey.getType() == AuthnSourceKey.AuthnSourceType.IDP_CONN) {
            this.type = Type.CONNECTION;
        } else {
            throw new IllegalStateException("unrecognized authn source type");
        }
    }

    public AsActionOption(String id, Type type) {
        this.id = id;
        this.type = type;
    }

    public String getId() {
        return this.id;
    }

    public Type getType() {
        return this.type;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        if (obj instanceof AsActionOption) {
            AsActionOption other = (AsActionOption)obj;
            if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
                return false;
            }
            if (this.type == null ? other.type != null : this.type != other.type) {
                return false;
            }
        }
        return true;
    }

    public String toString() {
        return this.id;
    }

    public AuthnSourceKey toAuthnSourceKey() {
        if (this.type == Type.ADAPTER) {
            return new AdapterAuthnSourceKey(this.id);
        }
        if (this.type == Type.CONNECTION) {
            return new IdpConnAuthnSourceKey(this.id);
        }
        return null;
    }

    public static Type getType(FilterableSelectionFieldDescriptor.SearchableType searchableType) {
        if (searchableType.equals(FilterableSelectionFieldDescriptor.SearchableType.IDP_CONNECTION)) {
            return Type.CONNECTION;
        }
        if (searchableType.equals(FilterableSelectionFieldDescriptor.SearchableType.SP_CONNECTION)) {
            return Type.CONNECTION;
        }
        if (searchableType.equals(FilterableSelectionFieldDescriptor.SearchableType.IDP_ADAPTER)) {
            return Type.ADAPTER;
        }
        if (searchableType.equals(FilterableSelectionFieldDescriptor.SearchableType.AUTHN_POLICY_CONTRACT)) {
            return Type.AUTHN_POLICY_CONTRACT;
        }
        if (searchableType.equals(FilterableSelectionFieldDescriptor.SearchableType.SELECTOR)) {
            return Type.SELECTOR;
        }
        if (searchableType.equals(FilterableSelectionFieldDescriptor.SearchableType.LOCAL_IDENTITY_PROFILE)) {
            return Type.LOCAL_IDENTITY_PROFILE;
        }
        if (searchableType.equals(FilterableSelectionFieldDescriptor.SearchableType.POLICY_FRAGMENT)) {
            return Type.FRAGMENT;
        }
        return null;
    }

    public static FilterableSelectionFieldDescriptor.SearchableType getType(Type asActionOptionType) {
        switch (asActionOptionType) {
            case CONNECTION: {
                return FilterableSelectionFieldDescriptor.SearchableType.IDP_CONNECTION;
            }
            case ADAPTER: {
                return FilterableSelectionFieldDescriptor.SearchableType.IDP_ADAPTER;
            }
            case AUTHN_POLICY_CONTRACT: {
                return FilterableSelectionFieldDescriptor.SearchableType.AUTHN_POLICY_CONTRACT;
            }
            case SELECTOR: {
                return FilterableSelectionFieldDescriptor.SearchableType.SELECTOR;
            }
            case LOCAL_IDENTITY_PROFILE: {
                return FilterableSelectionFieldDescriptor.SearchableType.LOCAL_IDENTITY_PROFILE;
            }
            case FRAGMENT: {
                return FilterableSelectionFieldDescriptor.SearchableType.POLICY_FRAGMENT;
            }
        }
        return null;
    }

    public static String getName(AsActionOption asActionOption) {
        if (asActionOption == null) {
            return "";
        }
        Type type = asActionOption.getType();
        String id = asActionOption.getId();
        switch (type) {
            case CONNECTION: {
                IdpConnection idpConnection = MgmtFactory.getConnectionManager().getIdpConnectionBySystemId(id);
                if (!idpConnection.isActive()) {
                    return MgmtFactory.getConnectionManager().getIdpConnectionBySystemId(id).getName() + " - (IdP Connection -- Inactive)";
                }
                return MgmtFactory.getConnectionManager().getIdpConnectionBySystemId(id).getName() + " - (IdP Connection)";
            }
            case ADAPTER: {
                return ((IdpAuthnAdapterInstance)MgmtFactory.getIdpAdapterManager().getInstance(id)).getName() + " - (Adapter)";
            }
            case SELECTOR: {
                return ((AuthnSelectorInstance)MgmtFactory.getAuthnSelectorManager().getInstance(id)).getName() + " - (Selector)";
            }
            case AUTHN_POLICY_CONTRACT: {
                return MgmtFactory.getC2cContractManager().getContract(id).getName() + " - (Policy Contract)";
            }
            case LOCAL_IDENTITY_PROFILE: {
                return MgmtFactory.getLocalIdentityProfileManager().getProfile(id).getName() + " - (Local Identity Profile)";
            }
            case FRAGMENT: {
                return MgmtFactory.getPolicyFragmentManager().getFragment(id).getName() + " - (Fragment)";
            }
        }
        return "";
    }

    public static enum Type {
        ADAPTER,
        CONNECTION,
        SELECTOR,
        CONTINUE,
        DONE,
        RESTART,
        AUTHN_POLICY_CONTRACT,
        LOCAL_IDENTITY_PROFILE,
        FRAGMENT;

    }
}

