/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.authnselection.ui;

import com.pingidentity.authnselection.ui.AsActionOption;
import com.pingidentity.component.common.SelectedOption;
import com.pingidentity.component.common.SelectionFilterList;
import java.io.Serializable;
import org.apache.commons.lang.StringUtils;
import org.sourceid.saml20.domain.mgmt.ConnectionManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.service.AuthnSourceKey;

public class AsUiDefaultAction
implements Serializable {
    private static final long serialVersionUID = 1L;
    private AsActionOption selectedOption;
    private String displayName;

    public AsUiDefaultAction() {
        this.selectedOption = null;
        this.displayName = "";
    }

    public AsUiDefaultAction(AuthnSourceKey authnSourceKey) {
        this.selectedOption = new AsActionOption(authnSourceKey);
        this.displayName = AsActionOption.getName(this.selectedOption);
    }

    public AsActionOption getSelectedOption() {
        return this.selectedOption;
    }

    public void setSelectedOption(AsActionOption selectedOption) {
        this.selectedOption = selectedOption;
        this.displayName = AsActionOption.getName(selectedOption);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getTypeAndId() {
        if (this.selectedOption != null) {
            String type = AsActionOption.getType(this.getSelectedOption().getType()).getTabTitle();
            String id = this.getSelectedOption().getId();
            if (this.getSelectedOption().getType().equals((Object)AsActionOption.Type.CONNECTION)) {
                ConnectionManager connManager = MgmtFactory.getConnectionManager();
                id = connManager.getIdpConnectionBySystemId(id).getEntityId();
            }
            return type + "-" + id;
        }
        return null;
    }

    public void setTypeAndId(String typeAndId) {
        if (StringUtils.isEmpty((String)typeAndId)) {
            this.setSelectedOption(null);
        } else {
            SelectedOption option = SelectionFilterList.parseSelectedOptionString(typeAndId);
            AsActionOption.Type type = AsActionOption.getType(option.getType());
            String id = option.getId();
            if (type.equals((Object)AsActionOption.Type.CONNECTION)) {
                ConnectionManager connManager = MgmtFactory.getConnectionManager();
                id = connManager.getIdpConnection(id).getId();
            }
            this.setSelectedOption(new AsActionOption(id, type));
        }
    }
}

