/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.authnselection.ui;

import com.pingidentity.authnselection.ui.AsActionOption;
import com.pingidentity.authnselection.ui.AsUiAction;
import com.pingidentity.fsm.state.impl.AbstractPolicyState;
import com.pingidentity.pingcommons.util.tree.TraversalVisitor;
import com.pingidentity.pingcommons.util.tree.Tree;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.sourceid.saml20.domain.AuthnSelectorInstance;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class ResyncSelectorResultsVisitor
implements TraversalVisitor<AsUiAction> {
    private final AbstractPolicyState state;

    public ResyncSelectorResultsVisitor(AbstractPolicyState state) {
        this.state = state;
    }

    public boolean continueTraversal() {
        return true;
    }

    public void visit(AsUiAction action, Tree.Node<AsUiAction> node) {
        AsActionOption selectionOption = action.getSelectedOption();
        if (selectionOption != null && selectionOption.getType() == AsActionOption.Type.SELECTOR) {
            String selectorId = selectionOption.getId();
            final AuthnSelectorInstance instance = (AuthnSelectorInstance)MgmtFactory.getAuthnSelectorManager().getInstance(selectorId);
            if (instance != null) {
                HashSet<String> results = new HashSet<String>(instance.getOrderedResults());
                HashSet<String> currentChildResults = new HashSet<String>();
                if (node.hasChildren()) {
                    Iterator childNodeIt = node.getChildren().iterator();
                    while (childNodeIt.hasNext()) {
                        String currentResult = ((AsUiAction)((Tree.Node)childNodeIt.next()).getData()).getResultContext();
                        if (!results.contains(currentResult)) {
                            childNodeIt.remove();
                            continue;
                        }
                        currentChildResults.add(currentResult);
                    }
                }
                this.addNewChildNodes(results, currentChildResults, node);
                if (node.hasChildren()) {
                    Collections.sort(node.getChildren(), new Comparator<Tree.Node<AsUiAction>>(){

                        @Override
                        public int compare(Tree.Node<AsUiAction> node1, Tree.Node<AsUiAction> node2) {
                            return instance.compareResultValues(((AsUiAction)node1.getData()).getResultContext(), ((AsUiAction)node2.getData()).getResultContext());
                        }
                    });
                }
            }
        }
    }

    private void addNewChildNodes(Set<String> results, Set<String> currentChildResults, Tree.Node<AsUiAction> node) {
        for (String result : results) {
            if (currentChildResults.contains(result)) continue;
            AsUiAction newChildAction = new AsUiAction(this.state, result);
            Tree.Node newChildNode = node.addChildData((Object)newChildAction);
            newChildAction.setNode((Tree.Node<AsUiAction>)newChildNode);
        }
    }
}

