/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.authnselection.ui;

import com.pingidentity.authnselection.ui.AsUiAction;
import com.pingidentity.pingcommons.util.tree.TraversalVisitor;
import com.pingidentity.pingcommons.util.tree.Tree;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;

public class UpdateSourceIdsVisitor
implements TraversalVisitor<AsUiAction> {
    private final Map<String, List<String>> availableSourceIdsMap;
    private final Map<String, List<String>> availableUpstreamAuthenticationSourcesMap;
    private final Function<Tree.Node<AsUiAction>, List<String>> getAvailableSourceIdsMethod;
    private final Function<List<String>, List<String>> addInAdditionalUserIdSourceIds;
    private final BiFunction<Tree.Node<AsUiAction>, List<String>, List<String>> addInAdditionalUpstreamAvailableSourceIds;

    public UpdateSourceIdsVisitor(Map<String, List<String>> availableSourceIdsMap, Map<String, List<String>> availableUpstreamAuthenticationSourcesMap, Function<Tree.Node<AsUiAction>, List<String>> getAvailableSourceIdsMethod, Function<List<String>, List<String>> addInAdditionalUserIdSourceIds, BiFunction<Tree.Node<AsUiAction>, List<String>, List<String>> addInAdditionalUpstreamAvailableSourceIds) {
        this.availableSourceIdsMap = availableSourceIdsMap;
        this.availableUpstreamAuthenticationSourcesMap = availableUpstreamAuthenticationSourcesMap;
        this.getAvailableSourceIdsMethod = getAvailableSourceIdsMethod;
        this.addInAdditionalUserIdSourceIds = addInAdditionalUserIdSourceIds;
        this.addInAdditionalUpstreamAvailableSourceIds = addInAdditionalUpstreamAvailableSourceIds;
    }

    public void visit(AsUiAction data, Tree.Node<AsUiAction> node) {
        List<String> newSources = this.getAvailableSourceIdsMethod.apply(node);
        List<String> newUserIdSources = this.addInAdditionalUserIdSourceIds.apply(new LinkedList<String>(newSources));
        List<String> newUpStreamSources = this.addInAdditionalUpstreamAvailableSourceIds.apply(node, new LinkedList<String>(newSources));
        this.availableSourceIdsMap.put(((AsUiAction)node.getData()).getNodeId(), newUserIdSources);
        this.availableUpstreamAuthenticationSourcesMap.put(((AsUiAction)node.getData()).getNodeId(), newUpStreamSources);
    }

    public boolean continueTraversal() {
        return true;
    }
}

