/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.authnselection.ui.fragments;

import com.pingidentity.authnselection.ui.AsActionOption;
import com.pingidentity.authnselection.ui.AsUiAction;
import com.pingidentity.pingcommons.util.tree.TraversalVisitor;
import com.pingidentity.pingcommons.util.tree.Tree;
import java.util.ArrayList;
import java.util.List;

public class InvalidFragmentContractVisitor
implements TraversalVisitor<AsUiAction> {
    private boolean invalidContract = false;
    private List<Tree.Node<AsUiAction>> nodesMissingOptions = new ArrayList<Tree.Node<AsUiAction>>();
    private final String validContractId;

    public InvalidFragmentContractVisitor(String validContractId) {
        this.validContractId = validContractId;
    }

    public boolean continueTraversal() {
        return true;
    }

    public void visit(AsUiAction data, Tree.Node<AsUiAction> node) {
        if (this.isMappableType(data) && !this.validContractId.equals(data.getMappingApcId())) {
            this.nodesMissingOptions.add(node);
            this.invalidContract = true;
        }
    }

    private boolean isMappableType(AsUiAction data) {
        return data.getSelectedOption() != null && (AsActionOption.Type.LOCAL_IDENTITY_PROFILE.equals((Object)data.getSelectedOption().getType()) || AsActionOption.Type.AUTHN_POLICY_CONTRACT.equals((Object)data.getSelectedOption().getType()));
    }

    public boolean isInvalidContract() {
        return this.invalidContract;
    }

    public List<Tree.Node<AsUiAction>> getNodesMissingOptions() {
        return this.nodesMissingOptions;
    }

    public String getValidContractId() {
        return this.validContractId;
    }
}

