/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.component.card;

import com.pingidentity.fsm.state.impl.AccessTokenManagementState;
import com.pingidentity.fsm.state.impl.PluginMgmtState;
import com.pingidentity.fsm.state.impl.TargetUrlMappingState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletCard;
import com.pingidentity.fsm.tasklet.comparator.PluginHierarchyComparator;
import com.pingidentity.fsm.tasklet.data.Mode;
import com.pingidentity.fsm.tasklet.impl.PluginInstanceTasklet;
import com.pingidentity.fsm.tasklet.impl.SingleStateTasklet;
import java.io.Serializable;
import java.util.Comparator;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.valid.ValidationConstraint;
import org.apache.tapestry.valid.ValidationDelegate;

public class AdapterManagement
extends TaskletCard
implements Serializable {
    private static final long serialVersionUID = 1L;
    private State state = new State();
    private static final Comparator<Tasklet> COMPARE_BY_NAME_UP = new Comparator<Tasklet>(){

        @Override
        public int compare(Tasklet o1, Tasklet o2) {
            PluginInstanceTasklet tasklet1 = (PluginInstanceTasklet)o1;
            PluginInstanceTasklet tasklet2 = (PluginInstanceTasklet)o2;
            return tasklet1.getName().compareToIgnoreCase(tasklet2.getName()) * -1;
        }
    };
    private static final Comparator<Tasklet> COMPARE_BY_NAME_DOWN = new Comparator<Tasklet>(){

        @Override
        public int compare(Tasklet o1, Tasklet o2) {
            PluginInstanceTasklet tasklet1 = (PluginInstanceTasklet)o1;
            PluginInstanceTasklet tasklet2 = (PluginInstanceTasklet)o2;
            return tasklet1.getName().compareToIgnoreCase(tasklet2.getName());
        }
    };
    private static final Comparator<Tasklet> COMPARE_BY_ID_UP = new Comparator<Tasklet>(){

        @Override
        public int compare(Tasklet o1, Tasklet o2) {
            PluginInstanceTasklet tasklet1 = (PluginInstanceTasklet)o1;
            PluginInstanceTasklet tasklet2 = (PluginInstanceTasklet)o2;
            return tasklet1.getPluginId().compareToIgnoreCase(tasklet2.getPluginId()) * -1;
        }
    };
    private static final Comparator<Tasklet> COMPARE_BY_ID_DOWN = new Comparator<Tasklet>(){

        @Override
        public int compare(Tasklet o1, Tasklet o2) {
            PluginInstanceTasklet tasklet1 = (PluginInstanceTasklet)o1;
            PluginInstanceTasklet tasklet2 = (PluginInstanceTasklet)o2;
            return tasklet1.getPluginId().compareToIgnoreCase(tasklet2.getPluginId());
        }
    };
    private static final Comparator<Tasklet> COMPARE_BY_TYPE_UP = new Comparator<Tasklet>(){

        @Override
        public int compare(Tasklet o1, Tasklet o2) {
            PluginInstanceTasklet tasklet1 = (PluginInstanceTasklet)o1;
            PluginInstanceTasklet tasklet2 = (PluginInstanceTasklet)o2;
            return tasklet1.getType().compareToIgnoreCase(tasklet2.getType()) * -1;
        }
    };
    private static final Comparator<Tasklet> COMPARE_BY_TYPE_DOWN = new Comparator<Tasklet>(){

        @Override
        public int compare(Tasklet o1, Tasklet o2) {
            PluginInstanceTasklet tasklet1 = (PluginInstanceTasklet)o1;
            PluginInstanceTasklet tasklet2 = (PluginInstanceTasklet)o2;
            return tasklet1.getType().compareToIgnoreCase(tasklet2.getType());
        }
    };
    private final transient Comparator<Tasklet> COMPARE_BY_PARENT_UP = new Comparator<Tasklet>(){

        @Override
        public int compare(Tasklet o1, Tasklet o2) {
            PluginInstanceTasklet tasklet1 = (PluginInstanceTasklet)o1;
            PluginInstanceTasklet tasklet2 = (PluginInstanceTasklet)o2;
            PluginMgmtState pluginState = (PluginMgmtState)AdapterManagement.this.getCurrentState();
            String parent1 = pluginState.getPluginInstanceName(tasklet1.getParentPluginInstanceId());
            String parent2 = pluginState.getPluginInstanceName(tasklet2.getParentPluginInstanceId());
            if (parent1 == null && parent2 == null) {
                return 0;
            }
            if (parent1 != null && parent2 == null) {
                return 1;
            }
            if (parent1 == null & parent2 != null) {
                return -1;
            }
            return parent1.compareToIgnoreCase(parent2) * -1;
        }
    };
    private final transient Comparator<Tasklet> COMPARE_BY_PARENT_DOWN = new Comparator<Tasklet>(){

        @Override
        public int compare(Tasklet o1, Tasklet o2) {
            PluginInstanceTasklet tasklet1 = (PluginInstanceTasklet)o1;
            PluginInstanceTasklet tasklet2 = (PluginInstanceTasklet)o2;
            PluginMgmtState pluginState = (PluginMgmtState)AdapterManagement.this.getCurrentState();
            String parent1 = pluginState.getPluginInstanceName(tasklet1.getParentPluginInstanceId());
            String parent2 = pluginState.getPluginInstanceName(tasklet2.getParentPluginInstanceId());
            if (parent1 == null && parent2 == null) {
                return 0;
            }
            if (parent1 != null && parent2 == null) {
                return -1;
            }
            if (parent1 == null & parent2 != null) {
                return 1;
            }
            return parent1.compareToIgnoreCase(parent2);
        }
    };

    public void createNew(IRequestCycle cycle) {
        ((PluginMgmtState)this.getCurrentState()).createNewTasklet();
    }

    protected void prepareForRender(IRequestCycle cycle) {
        super.prepareForRender(cycle);
        if (cycle.isRewinding()) {
            return;
        }
        PluginMgmtState pluginState = (PluginMgmtState)this.getCurrentState();
        pluginState.refreshTasklets();
        pluginState.sort(this.state.comparator);
    }

    public void delete(IRequestCycle cycle) {
        if (this.isCurrentUserAdmin()) {
            Object[] params = cycle.getServiceParameters();
            Integer adapterToDelete = (Integer)params[0];
            PluginMgmtState state = (PluginMgmtState)this.getCurrentState();
            if (state instanceof AccessTokenManagementState && !((AccessTokenManagementState)state).canDeleteAtm(adapterToDelete)) {
                ValidationDelegate delegate = state.getParent().getDelegate(cycle);
                delegate.setFormComponent(null);
                delegate.record(this.getMessageFromState("Unable_to_delete_with_oauth_ref"), ValidationConstraint.REQUIRED);
                return;
            }
            state.deleteTasklet(adapterToDelete);
        } else {
            this.auditLogUnauthorizedUserDeleteAction("adapter management");
        }
    }

    public void edit(IRequestCycle cycle) {
        Object[] params = cycle.getServiceParameters();
        Integer adapterToEdit = (Integer)params[0];
        PluginMgmtState state = (PluginMgmtState)this.getCurrentState();
        state.edit(adapterToEdit, cycle);
    }

    public void setDefault(IRequestCycle cycle) {
        Object[] params = cycle.getServiceParameters();
        Integer adapterToSetAsDefault = (Integer)params[0];
        PluginMgmtState state = (PluginMgmtState)this.getCurrentState();
        state.setAsDefaultInstance(adapterToSetAsDefault);
    }

    public void mapSpAdaptersToUrl(IRequestCycle cycle) {
        SingleStateTasklet tasklet = this.createTaskletToLoad(SingleStateTasklet.class, "UrlAdapterMappingTasklet", "Map URLs to Adapter Instances");
        tasklet.setFinishAvailable(!this.showFinishButtonIfAuditor());
        tasklet.setCycle(cycle);
        tasklet.setInitialState(new TargetUrlMappingState(tasklet));
        PluginMgmtState state = (PluginMgmtState)this.getCurrentState();
        tasklet.setMode(Mode.edit);
        tasklet.populate(state.getTasklets());
        this.loadTasklet(tasklet);
    }

    public void sortAdapterNameUp(IRequestCycle cycle) {
        PluginMgmtState pluginState = (PluginMgmtState)this.getCurrentState();
        if (pluginState.supportsPluginHierarchies()) {
            this.state.sortAdapterNameUpObject = null;
            this.state.comparator = new PluginHierarchyComparator(pluginState);
        } else {
            this.sortAdapterNameDefault(cycle);
        }
    }

    public void sortAdapterNameDown(IRequestCycle cycle) {
        this.state.sortAdapterNameUpObject = Boolean.TRUE;
        this.getState().comparator = COMPARE_BY_NAME_UP;
    }

    public void sortAdapterName(IRequestCycle cycle) {
        if (this.state.sortBy == SORT_BY.Name) {
            if (this.isAdapterNameDefault()) {
                this.sortAdapterNameDefault(cycle);
            } else if (this.state.sortAdapterNameUpObject.booleanValue()) {
                this.sortAdapterNameUp(cycle);
            } else {
                this.sortAdapterNameDown(cycle);
            }
        } else if (this.state.sortAdapterNameUpObject == null) {
            this.sortAdapterNameUp(cycle);
        }
        this.state.sortBy = SORT_BY.Name;
    }

    public void sortAdapterNameDefault(IRequestCycle cycle) {
        this.state.sortAdapterNameUpObject = Boolean.FALSE;
        this.getState().comparator = COMPARE_BY_NAME_DOWN;
    }

    public void sortAdapterId(IRequestCycle cycle) {
        if (this.state.sortBy == SORT_BY.Id) {
            this.state.sortAdapterIdUp = !this.state.sortAdapterIdUp;
        }
        Comparator<Tasklet> comparator = this.state.sortAdapterIdUp ? COMPARE_BY_ID_UP : COMPARE_BY_ID_DOWN;
        this.state.comparator = comparator;
        this.state.sortBy = SORT_BY.Id;
    }

    public void sortAdapterType(IRequestCycle cycle) {
        if (this.state.sortBy == SORT_BY.Type) {
            this.state.sortAdapterTypeUp = !this.state.sortAdapterTypeUp;
        }
        Comparator<Tasklet> comparator = this.state.sortAdapterTypeUp ? COMPARE_BY_TYPE_UP : COMPARE_BY_TYPE_DOWN;
        this.state.comparator = comparator;
        this.state.sortBy = SORT_BY.Type;
    }

    public void sortAdapterParent(IRequestCycle cycle) {
        if (this.state.sortBy == SORT_BY.ParentName) {
            this.state.sortAdapterParentUp = !this.state.sortAdapterParentUp;
        }
        Comparator<Tasklet> comparator = this.state.sortAdapterParentUp ? this.COMPARE_BY_PARENT_UP : this.COMPARE_BY_PARENT_DOWN;
        this.state.comparator = comparator;
        this.state.sortBy = SORT_BY.ParentName;
    }

    private State getState() {
        PluginMgmtState pluginMgmtState = (PluginMgmtState)this.getCurrentState();
        if (pluginMgmtState.isActivated()) {
            this.state = new State();
            if (!pluginMgmtState.supportsPluginHierarchies()) {
                this.state.sortAdapterNameUpObject = Boolean.FALSE;
            }
            pluginMgmtState.setActivated(false);
        }
        return this.state;
    }

    public boolean isAdapterNameUp() {
        this.getState();
        return Boolean.TRUE.equals(this.state.sortAdapterNameUpObject) && this.state.sortBy == SORT_BY.Name;
    }

    public boolean isAdapterNameDown() {
        this.getState();
        return Boolean.FALSE.equals(this.state.sortAdapterNameUpObject) && this.state.sortBy == SORT_BY.Name;
    }

    public boolean isAdapterNameDefault() {
        this.getState();
        return this.state.sortAdapterNameUpObject == null && this.state.sortBy == SORT_BY.Name;
    }

    public boolean isAdapterIdUp() {
        this.getState();
        return this.state.sortAdapterIdUp && this.state.sortBy == SORT_BY.Id;
    }

    public boolean isAdapterIdDown() {
        this.getState();
        return !this.state.sortAdapterIdUp && this.state.sortBy == SORT_BY.Id;
    }

    public boolean isAdapterTypeUp() {
        this.getState();
        return this.state.sortAdapterTypeUp && this.state.sortBy == SORT_BY.Type;
    }

    public boolean isAdapterTypeDown() {
        this.getState();
        return !this.state.sortAdapterTypeUp && this.state.sortBy == SORT_BY.Type;
    }

    public boolean isAdapterParentUp() {
        this.getState();
        return this.state.sortAdapterParentUp && this.state.sortBy == SORT_BY.ParentName;
    }

    public boolean isAdapterParentDown() {
        this.getState();
        return !this.state.sortAdapterParentUp && this.state.sortBy == SORT_BY.ParentName;
    }

    private class State
    implements Serializable {
        private static final long serialVersionUID = 20050515L;
        Boolean sortAdapterNameUpObject;
        boolean sortAdapterIdUp;
        boolean sortAdapterTypeUp;
        boolean sortAdapterParentUp;
        SORT_BY sortBy = SORT_BY.Name;
        Comparator<Tasklet> comparator;

        private State() {
        }
    }

    private static enum SORT_BY {
        Name,
        Id,
        Type,
        ParentName;

    }
}

