/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.component.card;

import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.common.util.PropertyInfo;
import com.pingidentity.crypto.JCEManager;
import com.pingidentity.fsm.state.impl.CertManagementState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletCard;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.data.CertItem;
import com.pingidentity.fsm.tasklet.data.CertificateTypes;
import com.pingidentity.fsm.tasklet.impl.CertManagementTasklet;
import com.pingidentity.fsm.tasklet.impl.CertifyCertTasklet;
import com.pingidentity.fsm.tasklet.impl.CreateCertTasklet;
import com.pingidentity.fsm.tasklet.impl.DSignRotationTasklet;
import com.pingidentity.fsm.tasklet.impl.ExportCertTasklet;
import com.pingidentity.fsm.tasklet.impl.ImportCertTasklet;
import com.pingidentity.fsm.tasklet.impl.LinkCertTasklet;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.valid.ValidationConstraint;
import org.apache.tapestry.valid.ValidationDelegate;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.PkCertManager;
import org.sourceid.saml20.domain.mgmt.impl.AdministrativeUser;

public class CertManagement
extends TaskletCard
implements CertificateTypes {
    protected void prepareForRender(IRequestCycle cycle) {
        super.prepareForRender(cycle);
        if (cycle.isRewinding()) {
            return;
        }
        CertManagementState state = (CertManagementState)this.getCurrentState();
        state.clearDeleteCerts();
    }

    public void createNew(IRequestCycle cycle) {
        if (this.isAuthorizedForCertAction()) {
            CertManagementState state = this.getCurrentState(CertManagementState.class);
            CertificateTypes.ValidTypes certType = state.getCertType();
            CreateCertTasklet createCertTasklet = this.loadNewTasklet(CreateCertTasklet.class);
            createCertTasklet.markProtocolImgAvailable(state.getParent().isProtocolImgAvailable());
            createCertTasklet.setCertType(certType);
            createCertTasklet.setFinishLabel("Save");
            CertManagementTasklet parentTasklet = this.findParent(CertManagementTasklet.class);
            createCertTasklet.setGlobalEditing(parentTasklet.isGlobalEditing());
            createCertTasklet.setActivatable();
        } else {
            this.recordError(cycle, "Not_authorized_create_new");
        }
    }

    public void importCert(IRequestCycle cycle) {
        if (this.isAuthorizedForCertAction()) {
            CertManagementState state = this.getCurrentState(CertManagementState.class);
            CertificateTypes.ValidTypes certType = state.getCertType();
            ImportCertTasklet importCertTasklet = this.loadNewTasklet(ImportCertTasklet.class);
            importCertTasklet.markProtocolImgAvailable(state.getParent().isProtocolImgAvailable());
            importCertTasklet.setCertType(certType);
            importCertTasklet.setFinishLabel("Save");
            CertManagementTasklet parentTasklet = this.findParent(CertManagementTasklet.class);
            importCertTasklet.setGlobalEditing(parentTasklet.isGlobalEditing());
            importCertTasklet.setActivatable();
        } else {
            this.recordError(cycle, "Not_authorized_import");
        }
    }

    public void linkCert(IRequestCycle cycle) {
        if (this.isAuthorizedForCertAction()) {
            PkCertManager resultPkCertManager;
            CertManagementTasklet parentTasklet = this.findParent(CertManagementTasklet.class);
            CertManagementState currentState = this.getCurrentState(CertManagementState.class);
            switch (currentState.getCertType()) {
                case sslCertAuth: {
                    resultPkCertManager = MgmtFactory.getSslAuthPkCertManager();
                    break;
                }
                case sslServerCerts: {
                    resultPkCertManager = MgmtFactory.getSslServerPkCertManager();
                    break;
                }
                case dsigSigningCert: {
                    resultPkCertManager = MgmtFactory.getDsigPkCertManager();
                    break;
                }
                default: {
                    resultPkCertManager = null;
                }
            }
            LinkCertTasklet linkCertTasklet = this.loadNewTasklet(LinkCertTasklet.class);
            linkCertTasklet.markProtocolImgAvailable(currentState.getParent().isProtocolImgAvailable());
            linkCertTasklet.setCertType(currentState.getCertType());
            linkCertTasklet.setErrorFactory(ValidationErrorFactory.getInstance());
            linkCertTasklet.setCertificateService(MgmtFactory.getCertificateService());
            linkCertTasklet.setPkCertManager(resultPkCertManager);
            linkCertTasklet.setFinishLabel("Save");
            linkCertTasklet.setGlobalEditing(parentTasklet.isGlobalEditing());
            linkCertTasklet.setActivatable();
        } else {
            this.recordError(cycle, "Not_authorized_import");
        }
    }

    public void delete(IRequestCycle cycle) {
        if (this.isAuthorizedForCertAction()) {
            Object[] params;
            Integer certToDelete;
            CertManagementState state = this.getCurrentState(CertManagementState.class);
            if (state.isCertInUse(certToDelete = (Integer)(params = cycle.getServiceParameters())[0])) {
                ValidationDelegate delegate = state.getParent().getDelegate(cycle);
                delegate.setFormComponent(null);
                delegate.record(this.getMessageFromState("Unable_to_delete_with_oauth_ref"), ValidationConstraint.REQUIRED);
                return;
            }
            state.delete(certToDelete);
        } else {
            this.recordError(cycle, "Not_authorized_delete");
        }
    }

    public void activate(IRequestCycle cycle) {
        if (this.isAuthorizedForCertAction()) {
            CertManagementState state = this.getCurrentState(CertManagementState.class);
            Object[] params = cycle.getServiceParameters();
            Integer certToActivate = (Integer)params[0];
            state.activate(certToActivate);
        } else {
            this.recordError(cycle, "Not_authorized_activate");
        }
    }

    public void activateDefaultAdmin(IRequestCycle cycle) {
        if (this.isAuthorizedForCertAction()) {
            CertManagementState state = this.getCurrentState(CertManagementState.class);
            Object[] params = cycle.getServiceParameters();
            Integer certToActivate = (Integer)params[0];
            state.activateDefaultAdmin(certToActivate);
        } else {
            this.recordError(cycle, "Not_authorized_activate");
        }
    }

    public void activateDefaultRuntime(IRequestCycle cycle) {
        if (this.isAuthorizedForCertAction()) {
            CertManagementState state = this.getCurrentState(CertManagementState.class);
            Object[] params = cycle.getServiceParameters();
            Integer certToActivate = (Integer)params[0];
            state.activateDefaultRuntime(certToActivate);
        } else {
            this.recordError(cycle, "Not_authorized_activate");
        }
    }

    public void deactivate(IRequestCycle cycle) {
        if (this.isAuthorizedForCertAction()) {
            CertManagementState state = this.getCurrentState(CertManagementState.class);
            Object[] params = cycle.getServiceParameters();
            Integer certToDeactivate = (Integer)params[0];
            state.deactivate(certToDeactivate);
        } else {
            this.recordError(cycle, "Not_authorized_deactivate");
        }
    }

    public void activateForVerificationCert(IRequestCycle cycle) {
        if (this.isAuthorizedForCertAction()) {
            CertManagementState state = this.getCurrentState(CertManagementState.class);
            Object[] params = cycle.getServiceParameters();
            Integer certToActivate = (Integer)params[0];
            state.activateVerificationCert(certToActivate);
        } else {
            this.recordError(cycle, "Not_authorized_activate");
        }
    }

    public void deactivateForVerificationCert(IRequestCycle cycle) {
        if (this.isAuthorizedForCertAction()) {
            CertManagementState state = this.getCurrentState(CertManagementState.class);
            Object[] params = cycle.getServiceParameters();
            Integer certToActivate = (Integer)params[0];
            state.deactivateVerificationCert(certToActivate);
        } else {
            this.recordError(cycle, "Not_authorized_activate");
        }
    }

    public void activateOscpVerificationCert(IRequestCycle cycle) {
        if (this.isAuthorizedForCertAction()) {
            CertManagementState state = this.getCurrentState(CertManagementState.class);
            Object[] params = cycle.getServiceParameters();
            Integer certToActivate = (Integer)params[0];
            state.activateOcspVerificationCert(certToActivate);
        } else {
            this.recordError(cycle, "Not_authorized_activate");
        }
    }

    public void deactivateOscpVerificationCert(IRequestCycle cycle) {
        if (this.isAuthorizedForCertAction()) {
            CertManagementState state = this.getCurrentState(CertManagementState.class);
            Object[] params = cycle.getServiceParameters();
            Integer certToDeactivate = (Integer)params[0];
            state.deactivateOcspVerificationCert(certToDeactivate);
        } else {
            this.recordError(cycle, "Not_authorized_deactivate");
        }
    }

    public void activateWsTrustDsigVerificationCert(IRequestCycle cycle) {
        if (this.isAuthorizedForCertAction()) {
            CertManagementState state = this.getCurrentState(CertManagementState.class);
            Object[] params = cycle.getServiceParameters();
            Integer certToActivate = (Integer)params[0];
            state.activateWsTrustDsigVerificationCert(certToActivate);
        } else {
            this.recordError(cycle, "Not_authorized_activate");
        }
    }

    public void deactivateWsTrustDsigVerificationCert(IRequestCycle cycle) {
        if (this.isAuthorizedForCertAction()) {
            CertManagementState state = this.getCurrentState(CertManagementState.class);
            Object[] params = cycle.getServiceParameters();
            Integer certToDeactivate = (Integer)params[0];
            state.deactivateWsTrustDsigVerificationCert(certToDeactivate);
        } else {
            this.recordError(cycle, "Not_authorized_deactivate");
        }
    }

    public void activateForAdmin(IRequestCycle cycle) {
        if (this.isAuthorizedForCertAction()) {
            CertManagementState state = this.getCurrentState(CertManagementState.class);
            Object[] params = cycle.getServiceParameters();
            Integer certToActivate = (Integer)params[0];
            state.activateAdminSslCert(certToActivate);
        } else {
            this.recordError(cycle, "Not_authorized_activate");
        }
    }

    public void deactivateForAdmin(IRequestCycle cycle) {
        if (this.isAuthorizedForCertAction()) {
            CertManagementState state = this.getCurrentState(CertManagementState.class);
            Object[] params = cycle.getServiceParameters();
            Integer certToDeactivate = (Integer)params[0];
            state.deactivateAdminSslCert(certToDeactivate);
        } else {
            this.recordError(cycle, "Not_authorized_deactivate");
        }
    }

    public void export(IRequestCycle cycle) {
        if (this.isAuthorizedForCertAction()) {
            boolean allowPrivateKeyExport;
            CertManagementState state = this.getCurrentState(CertManagementState.class);
            ExportCertTasklet exportCertTasklet = this.loadNewTasklet(ExportCertTasklet.class);
            CertificateTypes.ValidTypes certType = state.getCertType();
            Object[] params = cycle.getServiceParameters();
            CertItem certItem = state.getCertByIndex((Integer)params[0]);
            exportCertTasklet.setCertToExport(certItem);
            JCEManager jceMgr = MgmtFactory.getJCEManager();
            boolean bl = allowPrivateKeyExport = PropertyInfo.isHSMHybrid() && certItem.getCert().isStoredOnHSM() != null && certItem.getCert().isStoredOnHSM() == false || jceMgr.allowPrivateKeyExport();
            if (!allowPrivateKeyExport || certType == CertificateTypes.ValidTypes.trustedCAs || certType == CertificateTypes.ValidTypes.dsigVerificationCert || certType == CertificateTypes.ValidTypes.sslCertVerification || certType == CertificateTypes.ValidTypes.xmlEncryptionCert || certType == CertificateTypes.ValidTypes.ocspDsigVerificationCert || certType == CertificateTypes.ValidTypes.wsTrustDsigVerificationCert) {
                exportCertTasklet.setCertificateOnly(true);
            }
            if (!allowPrivateKeyExport) {
                exportCertTasklet.setLunaNote();
            }
            exportCertTasklet.markProtocolImgAvailable(state.getParent().isProtocolImgAvailable());
        } else {
            this.recordError(cycle, "Not_authorized_export");
        }
    }

    public void rotationSettings(IRequestCycle cycle) {
        if (this.isAuthorizedForCertAction()) {
            CertManagementState state = this.getCurrentState(CertManagementState.class);
            DSignRotationTasklet certRotationTasklet = this.loadNewTasklet(DSignRotationTasklet.class);
            Object[] params = cycle.getServiceParameters();
            CertItem certItem = state.getCertByIndex((Integer)params[0]);
            certRotationTasklet.setOriginalCert(certItem.getCert());
            certRotationTasklet.loadStates();
            if (certRotationTasklet.getEnableCertRotationState().isEnableCertRotation()) {
                certRotationTasklet.resetCurrentStateToSourceState();
                certRotationTasklet.populate(certRotationTasklet.getOriginalCert());
                certRotationTasklet.gotoSummaryState(cycle);
            }
        }
    }

    public void certify(IRequestCycle cycle) {
        CertManagementState state = this.getCurrentState(CertManagementState.class);
        if (this.isAuthorizedForCertAction()) {
            Object[] params = cycle.getServiceParameters();
            Integer certToCertify = (Integer)params[0];
            CertItem certItem = state.getCertByIndex(certToCertify);
            CertifyCertTasklet certify = this.loadNewTasklet(CertifyCertTasklet.class);
            certify.setCertToCertify(certItem);
            certify.markProtocolImgAvailable(state.getParent().isProtocolImgAvailable());
            certify.setFinishLabel("Save");
        } else {
            this.recordError(cycle, "Not_authorized_certify");
        }
    }

    public boolean isEnableAdminSslCertSelection() {
        return this.getCurrentState(CertManagementState.class).getCertType() == CertificateTypes.ValidTypes.sslServerCerts;
    }

    public boolean isSignatureVerificationCertSelection() {
        return this.getCurrentState(CertManagementState.class).getCertType() == CertificateTypes.ValidTypes.dsigVerificationCert;
    }

    public boolean isXMLEncryptionCertSelection() {
        return this.getCurrentState(CertManagementState.class).getCertType() == CertificateTypes.ValidTypes.xmlEncryptionCert;
    }

    public boolean isDsigSigningCertSelection() {
        return this.getCurrentState(CertManagementState.class).getCertType() == CertificateTypes.ValidTypes.dsigSigningCert;
    }

    public boolean isXMLDecryptionCertSelection() {
        return this.getCurrentState(CertManagementState.class).getCertType() == CertificateTypes.ValidTypes.xmlDecryptionCert;
    }

    public boolean isOscpDsigVerificationCertSelection() {
        return this.getCurrentState(CertManagementState.class).getCertType() == CertificateTypes.ValidTypes.ocspDsigVerificationCert;
    }

    public boolean isWsTrustDsigVerificationCertSelection() {
        return this.getCurrentState(CertManagementState.class).getCertType() == CertificateTypes.ValidTypes.wsTrustDsigVerificationCert;
    }

    public void activateForSecondary(IRequestCycle cycle) {
        if (this.isAuthorizedForCertAction()) {
            CertManagementState state = this.getCurrentState(CertManagementState.class);
            Object[] params = cycle.getServiceParameters();
            Integer certToActivate = (Integer)params[0];
            state.activateSecondary(certToActivate);
        } else {
            this.recordError(cycle, "Not_authorized_activate");
        }
    }

    public void deactivateForSecondary(IRequestCycle cycle) {
        if (this.isAuthorizedForCertAction()) {
            CertManagementState state = this.getCurrentState(CertManagementState.class);
            Object[] params = cycle.getServiceParameters();
            Integer certToActivate = (Integer)params[0];
            state.deactivateSecondary(certToActivate);
        } else {
            this.recordError(cycle, "Not_authorized_activate");
        }
    }

    private void recordError(IRequestCycle cycle, String errorMsgKey) {
        TaskletState state = this.getCurrentState();
        Tasklet parentTasklet = this.findParent(Tasklet.class);
        ValidationDelegate delegate = parentTasklet.getDelegate(cycle);
        delegate.setFormComponent(null);
        delegate.record(state.getMessage(errorMsgKey), ValidationConstraint.REQUIRED);
    }

    public boolean isAuthorizedForCertAction() {
        AdministrativeUser user = this.getCurrentUser();
        if (user.isAuditor()) {
            return false;
        }
        if (user.isCryptoManager()) {
            return true;
        }
        if (user.isAdmin()) {
            switch (this.getCurrentState(CertManagementState.class).getCertType()) {
                case dsigVerificationCert: 
                case ocspDsigVerificationCert: 
                case wsTrustDsigVerificationCert: 
                case sslCertVerification: 
                case xmlEncryptionCert: {
                    return true;
                }
            }
        }
        return false;
    }
}

