/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.component.card;

import com.pingidentity.fsm.state.impl.CibaPoliciesManagementState;
import com.pingidentity.fsm.state.impl.CibaPolicyManagementTasklet;
import com.pingidentity.fsm.tasklet.TaskletCard;
import com.pingidentity.fsm.tasklet.data.Mode;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.valid.ValidationConstraint;
import org.apache.tapestry.valid.ValidationDelegate;
import org.sourceid.saml20.domain.util.InUseDetectionUtil;

public class CibaPoliciesManagement
extends TaskletCard {
    private int taskletListSize;
    private boolean wasAddClicked;

    public void edit(IRequestCycle cycle) {
        CibaPoliciesManagementState state = this.getState();
        Object[] params = cycle.getServiceParameters();
        String policyToEdit = (String)params[0];
        CibaPolicyManagementTasklet tasklet = (CibaPolicyManagementTasklet)state.getTaskletFromList(policyToEdit);
        tasklet.setMode(Mode.edit);
        tasklet.setFinishLabel("Save");
        tasklet.setOperation(CibaPolicyManagementTasklet.Operation.UPDATE);
        this.loadTasklet(tasklet);
        tasklet.gotoSummaryState(cycle);
    }

    public void delete(IRequestCycle cycle) {
        if (this.isCurrentUserAdmin()) {
            Object[] params = cycle.getServiceParameters();
            String policyToDelete = (String)params[0];
            if (this.canDeleteCIBAPolicy(policyToDelete)) {
                CibaPoliciesManagementState state = this.getState();
                state.delete(policyToDelete);
            } else {
                ValidationDelegate delegate = this.getState().getParent().getDelegate(cycle);
                delegate.setFormComponent(null);
                delegate.record(this.getMessageFromState("Unable_to_delete_with_oauth_ref"), ValidationConstraint.REQUIRED);
            }
        } else {
            this.auditLogUnauthorizedUserDeleteAction("Request Policies");
        }
    }

    private boolean canDeleteCIBAPolicy(String policyToDelete) {
        String defaultPolicyId = null;
        if (this.getState().getPolicyList() != null && this.getState().getPolicyList().size() > 1) {
            defaultPolicyId = this.getState().getDefaultPolicyId();
        }
        return !InUseDetectionUtil.getInstance().isCibaPolicyUsedWithAnyClients(policyToDelete) && !InUseDetectionUtil.getInstance().isCibaPolicyUsedInClientSettings(policyToDelete, defaultPolicyId);
    }

    public void setDefaultPolicy(IRequestCycle cycle) {
        CibaPoliciesManagementState state = this.getState();
        Object[] params = cycle.getServiceParameters();
        String newDefaultPolicy = (String)params[0];
        state.setDefaultPolicy(newDefaultPolicy);
    }

    public void addPolicy(IRequestCycle cycle) {
        if (!this.isAuthorizedForAction()) {
            return;
        }
        CibaPoliciesManagementState state = this.getState();
        if (!state.getDelegate().getHasErrors()) {
            this.taskletListSize = state.getTaskletListSize();
            this.wasAddClicked = true;
            CibaPolicyManagementTasklet tasklet = this.createTaskletToLoad(CibaPolicyManagementTasklet.class);
            tasklet.setOperation(CibaPolicyManagementTasklet.Operation.INSERT);
            tasklet.setMode(Mode.create);
            tasklet.setFinishLabel("Save");
            this.loadTasklet(tasklet);
        }
    }

    public boolean showTaskletCreatedMessage() {
        CibaPoliciesManagementState state = this.getState();
        boolean showTaskletCreateMessage = this.wasAddClicked && this.taskletListSize < state.getTaskletListSize();
        this.taskletListSize = 0;
        this.wasAddClicked = false;
        return showTaskletCreateMessage;
    }

    public String getNewPolicyId() {
        CibaPoliciesManagementState state = this.getState();
        CibaPolicyManagementTasklet t = (CibaPolicyManagementTasklet)state.getTasklet(state.getTaskletListSize() - 1);
        return t.getPolicyId();
    }

    private CibaPoliciesManagementState getState() {
        return (CibaPoliciesManagementState)this.getCurrentState();
    }
}

