/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.component.card;

import com.pingidentity.fsm.state.impl.OAuthSource2TargetMappingTasklet;
import com.pingidentity.fsm.state.impl.OAuthSource2TargetMappingsState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletCard;
import com.pingidentity.fsm.tasklet.TaskletListState;
import com.pingidentity.fsm.tasklet.data.Mode;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.valid.ValidationConstraint;
import org.sourceid.saml20.domain.AttributeMapping;
import org.sourceid.saml20.domain.ConfigurablePluginInstance;

public class OAuthSource2TargetMappings
extends TaskletCard {
    protected void prepareForRender(IRequestCycle cycle) {
        super.prepareForRender(cycle);
        if (cycle.isRewinding()) {
            return;
        }
        TaskletListState state = (TaskletListState)this.getCurrentState();
        state.refreshTasklets();
    }

    public void edit(IRequestCycle cycle) {
        OAuthSource2TargetMappingTasklet tasklet;
        OAuthSource2TargetMappingsState<AttributeMapping> state = this.getState();
        Object[] params = cycle.getServiceParameters();
        String adapterMappingToEdit = (String)params[0];
        if (adapterMappingToEdit != null && (tasklet = (OAuthSource2TargetMappingTasklet)state.getTaskletFromList(adapterMappingToEdit)) != null) {
            tasklet.setMode(Mode.edit);
            tasklet.resetCurrentStateToSourceState();
            this.loadTasklet(tasklet);
            tasklet.gotoSummaryState(cycle);
        }
    }

    public void delete(IRequestCycle cycle) {
        if (this.isCurrentUserAdmin()) {
            OAuthSource2TargetMappingsState<AttributeMapping> state = this.getState();
            Object[] params = cycle.getServiceParameters();
            String mappingToDelete = (String)params[0];
            state.delete(mappingToDelete);
        } else {
            this.auditLogUnauthorizedUserDeleteAction("oauth source to target mappings");
        }
    }

    private boolean beginsWithVowel(String str) {
        return (str = str.toLowerCase()).startsWith("a") || str.startsWith("e") || str.startsWith("i") || str.startsWith("o") || str.startsWith("u");
    }

    public void addMapping(IRequestCycle cycle) {
        OAuthSource2TargetMappingsState<AttributeMapping> state = this.getState();
        String srcId = state.getSelectedSourceId();
        ConfigurablePluginInstance targetInstance = state.getSelectedTarget();
        if (srcId == null) {
            StringBuilder errorMsg = new StringBuilder("Please select");
            if (this.beginsWithVowel(state.getDropDownText())) {
                errorMsg.append(" an ");
            } else {
                errorMsg.append(" a ");
            }
            errorMsg.append(state.getDropDownText());
            this.addError(errorMsg.toString());
        }
        if (state.hasConfigurableTarget() && targetInstance == null) {
            this.addError(state.getMissingTargetErrorMessage());
        }
        if (state.hasConfigurableTarget() && srcId != null && targetInstance != null) {
            for (Tasklet tasklet : this.getState().getTasklets()) {
                OAuthSource2TargetMappingTasklet mappingTasklet = (OAuthSource2TargetMappingTasklet)tasklet;
                if (!srcId.equals(mappingTasklet.getSelectedId()) || !targetInstance.getId().equals(mappingTasklet.getSelectedTargetId())) continue;
                this.addError("A mapping already exists for this " + state.getDropDownText() + " and " + state.getTargetDropDownText());
            }
        }
        if (!state.getDelegate().getHasErrors()) {
            OAuthSource2TargetMappingTasklet<AttributeMapping> tasklet = this.createTaskletToLoad(state.getTaskletClass());
            AttributeMapping attributeMapping = state.newEmptyMapping(srcId);
            tasklet.saveSetSelectedId(srcId, attributeMapping);
            if (targetInstance != null) {
                tasklet.saveSetSelectedTargetId(targetInstance.getId(), attributeMapping);
            }
            tasklet.setFinishLabel("Save");
            tasklet.loadMapping(attributeMapping);
            this.loadTasklet(tasklet);
        }
    }

    void addError(String error) {
        this.getState().getDelegate().setFormComponent(null);
        this.getState().getDelegate().record(error, ValidationConstraint.REQUIRED);
    }

    private OAuthSource2TargetMappingsState<AttributeMapping> getState() {
        return (OAuthSource2TargetMappingsState)this.getCurrentState();
    }
}

