/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.component.card;

import com.pingidentity.fsm.state.impl.PoliciesManagementState;
import com.pingidentity.fsm.state.impl.PolicyManagementTasklet;
import com.pingidentity.fsm.tasklet.TaskletCard;
import com.pingidentity.fsm.tasklet.data.Mode;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.valid.ValidationConstraint;
import org.apache.tapestry.valid.ValidationDelegate;
import org.sourceid.saml20.domain.util.InUseDetectionUtil;

public class PoliciesManagement
extends TaskletCard {
    public void edit(IRequestCycle cycle) {
        PoliciesManagementState state = this.getState();
        Object[] params = cycle.getServiceParameters();
        String policyToEdit = (String)params[0];
        PolicyManagementTasklet tasklet = (PolicyManagementTasklet)state.getTaskletFromList(policyToEdit);
        tasklet.setMode(Mode.edit);
        tasklet.setOperation(PolicyManagementTasklet.Operation.UPDATE);
        this.loadTasklet(tasklet);
        tasklet.gotoSummaryState(cycle);
    }

    public void delete(IRequestCycle cycle) {
        if (this.isCurrentUserAdmin()) {
            Object[] params = cycle.getServiceParameters();
            String policyToDelete = (String)params[0];
            if (this.canDeletePolicy(policyToDelete)) {
                PoliciesManagementState state = this.getState();
                state.delete(policyToDelete);
            } else {
                ValidationDelegate delegate = this.getState().getParent().getDelegate(cycle);
                delegate.setFormComponent(null);
                delegate.record(this.getMessageFromState("Unable_to_delete_with_oauth_ref"), ValidationConstraint.REQUIRED);
            }
        } else {
            this.auditLogUnauthorizedUserDeleteAction("policies management");
        }
    }

    private boolean canDeletePolicy(String policyToDelete) {
        String defaultPolicyId = null;
        if (this.getState().getPolicyList() != null && this.getState().getPolicyList().size() > 1) {
            defaultPolicyId = this.getState().getDefaultPolicyId();
        }
        return !InUseDetectionUtil.getInstance().isPolicyUsedWithAnyClients(policyToDelete) && !InUseDetectionUtil.getInstance().isPolicyUsedInClientSettings(policyToDelete, defaultPolicyId);
    }

    public void undelete(IRequestCycle cycle) {
        if (this.isCurrentUserAdmin()) {
            PoliciesManagementState state = this.getState();
            Object[] params = cycle.getServiceParameters();
            String policyToUndelete = (String)params[0];
            state.undelete(policyToUndelete);
        } else {
            this.auditLogUnauthorizedUserUndeleteAction("policies management");
        }
    }

    public void setDefaultPolicy(IRequestCycle cycle) {
        PoliciesManagementState state = this.getState();
        Object[] params = cycle.getServiceParameters();
        String newDefaultPolicy = (String)params[0];
        state.setDefaultPolicy(newDefaultPolicy);
    }

    public void addPolicy(IRequestCycle cycle) {
        PoliciesManagementState state = this.getState();
        if (!state.getDelegate().getHasErrors()) {
            PolicyManagementTasklet tasklet = this.createTaskletToLoad(PolicyManagementTasklet.class);
            tasklet.setOperation(PolicyManagementTasklet.Operation.INSERT);
            tasklet.setMode(Mode.create);
            tasklet.setFinishLabel("Save");
            this.loadTasklet(tasklet);
        }
    }

    private PoliciesManagementState getState() {
        return (PoliciesManagementState)this.getCurrentState();
    }
}

