/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.component.card;

import com.pingidentity.fsm.state.impl.ConnectionLimitState;
import com.pingidentity.fsm.state.impl.Source2TargetMappingTasklet;
import com.pingidentity.fsm.state.impl.Source2TargetMappingsState;
import com.pingidentity.fsm.tasklet.TaskletCard;
import com.pingidentity.fsm.tasklet.data.Mode;
import com.pingidentity.fsm.tasklet.impl.SingleStateTasklet;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.valid.ValidationConstraint;
import org.sourceid.a2a.domain.Source2TargetMapping;
import org.sourceid.saml20.domain.ConfigurablePluginInstance;
import org.sourceid.util.license.LicenseManager;

public class Source2TargetMappings
extends TaskletCard {
    private static final String MSG_DUPLICATE_ERROR = "duplicate_error";
    private static final String MSG_SELECT_SOURCE = "select_source";
    private static final String MSG_SELECT_TARGET = "select_target";

    public void addMapping(IRequestCycle cycle) {
        Source2TargetMappingsState<Source2TargetMapping> state = this.getState();
        ConfigurablePluginInstance srcInstance = state.getSelectedSource();
        ConfigurablePluginInstance targetInstance = state.getSelectedTarget();
        if (srcInstance == null) {
            this.addError(this.getMessage(MSG_SELECT_SOURCE));
        }
        if (targetInstance == null) {
            this.addError(this.getMessage(MSG_SELECT_TARGET));
        }
        if (!state.getDelegate().getHasErrors()) {
            String targetId;
            String srcId = srcInstance.getId();
            if (state.containsMapping(srcId, targetId = targetInstance.getId())) {
                this.addError(this.getMessage(MSG_DUPLICATE_ERROR, srcInstance.getName(), targetInstance.getName()));
            } else {
                Source2TargetMappingTasklet<Source2TargetMapping> tasklet = this.createTaskletToLoad(state.getMappingTaskletClass());
                Source2TargetMapping mapping = state.makeMapping();
                mapping.setSourceId(srcId);
                mapping.setTargetId(targetId);
                tasklet.setMode(Mode.create);
                tasklet.loadMapping(mapping);
                tasklet.setFinishLabel("Save");
                this.loadTasklet(tasklet);
            }
        }
    }

    public boolean isCreateMappingDisabled() {
        return !LicenseManager.canAddConnection();
    }

    public void onLoadConnectionLimit(IRequestCycle cycle) {
        SingleStateTasklet tasklet = this.createTaskletToLoad(SingleStateTasklet.class, "ConnectionLimitTasklet", "Connection Limit Exceeded");
        tasklet.setFinishAvailable(false);
        tasklet.setCycle(cycle);
        tasklet.setInitialState(new ConnectionLimitState(tasklet));
        this.loadTasklet(tasklet);
    }

    @Override
    public String getMessage(String key) {
        String prefix = this.getState().getMessageKeyPrefix();
        return super.getMessage(prefix + "_" + key);
    }

    @Override
    public String getMessage(String key, Object ... arguments) {
        String prefix = this.getState().getMessageKeyPrefix();
        return super.getMessage(prefix + "_" + key, arguments);
    }

    void addError(String error) {
        this.getState().getDelegate().setFormComponent(null);
        this.getState().getDelegate().record(error, ValidationConstraint.REQUIRED);
    }

    private Source2TargetMappingsState<Source2TargetMapping> getState() {
        return (Source2TargetMappingsState)this.getCurrentState();
    }
}

