/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.component.card;

import com.pingidentity.fsm.state.impl.WsTrustSpProtocolSettingsState;
import com.pingidentity.fsm.tasklet.TaskletCard;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.valid.ValidationConstraint;
import org.sourceid.common.ValidationUtil;

public class WsTrustSpProtocolSettings
extends TaskletCard {
    private String currentAppliesTo;

    public boolean isUpdatingAppliesTo(String appliesTo) {
        WsTrustSpProtocolSettingsState curState = (WsTrustSpProtocolSettingsState)this.getCurrentState();
        return appliesTo.equalsIgnoreCase(curState.getUpdateAppliesToOriginalValue());
    }

    public void onAddAppliesTo(IRequestCycle cycle) {
        WsTrustSpProtocolSettingsState curState = (WsTrustSpProtocolSettingsState)this.getCurrentState();
        String newAppliesTo = curState.getNewAppliesTo();
        if (this.validateAppliesTo(newAppliesTo, null)) {
            curState.getAppliesToUrls().add(newAppliesTo);
            curState.setNewAppliesTo(null);
        }
    }

    public void onCancelAppliesTo(IRequestCycle cycle) {
        this.cancelAppliesToEdit();
    }

    public void onDeleteAppliesTo(IRequestCycle cycle) {
        if (this.isCurrentUserAdmin()) {
            WsTrustSpProtocolSettingsState curState = (WsTrustSpProtocolSettingsState)this.getCurrentState();
            Object[] params = cycle.getServiceParameters();
            String deleteItem = (String)params[0];
            curState.getAppliesToUrls().remove(deleteItem);
        } else {
            this.auditLogUnauthorizedUserDeleteAction("ws trust sp protocol settings");
        }
    }

    public void onEditAppliesTo(IRequestCycle cycle) {
        Object[] params = cycle.getServiceParameters();
        String updateAppliesTo = (String)params[0];
        WsTrustSpProtocolSettingsState curState = (WsTrustSpProtocolSettingsState)this.getCurrentState();
        curState.setEditingAppliesTo(true);
        curState.setUpdateAppliesTo(updateAppliesTo);
        curState.setUpdateAppliesToOriginalValue(updateAppliesTo);
    }

    public void onUpdateAppliesTo(IRequestCycle cycle) {
        boolean hasErrors = false;
        WsTrustSpProtocolSettingsState curState = (WsTrustSpProtocolSettingsState)this.getCurrentState();
        String updateAppliesTo = curState.getUpdateAppliesTo();
        boolean bl = hasErrors = !this.validateAppliesTo(updateAppliesTo, curState.getUpdateAppliesToOriginalValue());
        if (!hasErrors) {
            Set<String> appliesToUrls = curState.getAppliesToUrls();
            appliesToUrls.remove(curState.getUpdateAppliesToOriginalValue());
            appliesToUrls.add(updateAppliesTo);
            this.cancelAppliesToEdit();
        }
    }

    private void cancelAppliesToEdit() {
        WsTrustSpProtocolSettingsState curState = (WsTrustSpProtocolSettingsState)this.getCurrentState();
        curState.setUpdateAppliesTo(null);
        curState.setUpdateAppliesToOriginalValue(null);
        curState.setEditingAppliesTo(false);
    }

    public String getCurrentAppliesToUrl() {
        return this.currentAppliesTo;
    }

    public void setCurrentAppliesToUrl(String currentAppliesToUrl) {
        this.currentAppliesTo = currentAppliesToUrl;
    }

    private boolean validateAppliesTo(String newAppliesTo, String oldAppliesTo) {
        boolean hasErrors = false;
        WsTrustSpProtocolSettingsState curState = (WsTrustSpProtocolSettingsState)this.getCurrentState();
        if (StringUtils.isBlank((String)newAppliesTo)) {
            curState.getDelegate().setFormComponent(null);
            curState.getDelegate().record(this.getMessage("New_applies_to_blank"), ValidationConstraint.REQUIRED);
            hasErrors = true;
        }
        if (newAppliesTo != null) {
            if (!ValidationUtil.isValidUri((String)newAppliesTo)) {
                curState.getDelegate().setFormComponent(null);
                curState.getDelegate().record(this.getMessage("Applies_to_must_be_url", newAppliesTo), ValidationConstraint.REQUIRED);
                hasErrors = true;
            }
            if (curState.getAppliesToUrls().contains(newAppliesTo) && !newAppliesTo.equalsIgnoreCase(oldAppliesTo)) {
                curState.getDelegate().setFormComponent(null);
                curState.getDelegate().record(this.getMessage("Already_contains", newAppliesTo), ValidationConstraint.REQUIRED);
                hasErrors = true;
            }
        }
        return !hasErrors;
    }

    public void showAdvanced(IRequestCycle cycle) {
        ((WsTrustSpProtocolSettingsState)this.getCurrentState()).setShowAdvanced(true);
    }

    public void hideAdvanced(IRequestCycle cycle) {
        ((WsTrustSpProtocolSettingsState)this.getCurrentState()).setShowAdvanced(false);
    }
}

