/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.component.common;

import com.pingidentity.fsm.state.impl.PasswordGenerationState;
import com.pingidentity.fsm.state.impl.UserMgmtState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletCard;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.data.Mode;
import com.pingidentity.fsm.tasklet.impl.SingleStateTasklet;
import com.pingidentity.fsm.tasklet.impl.UserInfoTasklet;
import com.pingidentity.fsm.tasklet.impl.UsersTasklet;
import com.pingidentity.fsm.tasklet.impl.WsTrustUsersTasklet;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.tapestry.IBinding;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.valid.ValidationConstraint;
import org.apache.tapestry.valid.ValidationDelegate;
import org.sourceid.saml20.domain.mgmt.impl.AdministrativeUser;

public abstract class AdminUserList
extends TaskletCard {
    public abstract IBinding getUsersBinding();

    public abstract boolean getCreateUsersButton();

    public abstract boolean getIsWsTrustAdminUserList();

    public abstract IBinding getRequireOneAdminManagerBinding();

    public abstract IBinding getStateBinding();

    private void saveState(State curState) {
        this.getStateBinding().setObject((Object)curState);
    }

    private State getState() {
        State state = (State)this.getStateBinding().getObject("state", Object.class);
        return state != null ? state : new State();
    }

    public void createUser(IRequestCycle cycle) {
        if (this.isAuthorizedForAction()) {
            if (this.getIsWsTrustAdminUserList()) {
                WsTrustUsersTasklet tasklet = this.createTaskletToLoad(WsTrustUsersTasklet.class);
                tasklet.setMode(Mode.create);
                State state = this.getState();
                tasklet.setUsers(state.users);
                this.loadTasklet(tasklet);
            } else {
                UserInfoTasklet tasklet = this.createTaskletToLoad(UserInfoTasklet.class);
                tasklet.setMode(Mode.edit);
                tasklet.populate(null);
                tasklet.setNewUser(true);
                State state = this.getState();
                tasklet.setUsers(state.users);
                this.loadTasklet(tasklet);
            }
        } else {
            this.recordError(cycle, "Not_authorized_create_user");
        }
    }

    public void edit(IRequestCycle cycle) {
        if (this.isAuthorizedForAction()) {
            Object[] params = cycle.getServiceParameters();
            Integer userToEdit = (Integer)params[0];
            State state = this.getState();
            AdministrativeUser user = state.users.get(userToEdit);
            Tasklet tasklet = null;
            if (this.getIsWsTrustAdminUserList()) {
                tasklet = this.createTaskletToLoad(WsTrustUsersTasklet.class);
            } else {
                UserInfoTasklet userInfoTasklet = this.createTaskletToLoad(UserInfoTasklet.class);
                userInfoTasklet.setNewUser(false);
                tasklet = userInfoTasklet;
            }
            tasklet.setMode(Mode.edit);
            tasklet.populate(user);
            this.loadTasklet(tasklet);
        } else {
            this.recordError(cycle, "Not_authorized_view_user");
        }
    }

    public void inactivate(IRequestCycle cycle) {
        if (this.isAuthorizedForAction()) {
            Object[] params = cycle.getServiceParameters();
            Integer userToDelete = (Integer)params[0];
            State state = this.getState();
            AdministrativeUser user = state.users.get(userToDelete);
            if (user.isActive()) {
                user.setActive(false);
            } else {
                user.setActive(true);
            }
            this.saveState(state);
        } else {
            this.recordError(cycle, "Not_authorized_inactivate");
        }
    }

    public void changePassword(IRequestCycle cycle) {
        List<AdministrativeUser> users = this.getUsers();
        if (this.isAuthorizedForChange(cycle, users)) {
            UsersTasklet tasklet = this.createTaskletToLoad(UsersTasklet.class, "UsersTasklet", "Change Password");
            tasklet.setInitialState(new UserMgmtState(tasklet));
            this.loadTasklet(tasklet);
        } else {
            this.recordError(cycle, "Not_authorized_change_password");
        }
    }

    public void resetPassword(IRequestCycle cycle) {
        if (this.isAuthorizedForReset(cycle)) {
            SingleStateTasklet tasklet;
            tasklet.setFinishAvailable(!(tasklet = this.createTaskletToLoad(SingleStateTasklet.class, "UserInfoTasklet", "Reset Password")).showFinishButtonIfAuditor());
            tasklet.setFinishLabel("Done");
            PasswordGenerationState passwordGenerationState = new PasswordGenerationState(tasklet);
            Object[] params = cycle.getServiceParameters();
            Integer userIndex = (Integer)params[0];
            AdministrativeUser user = this.getUsers().get(userIndex);
            passwordGenerationState.setUsername(user.getUserName());
            tasklet.setInitialState(passwordGenerationState);
            this.loadTasklet(tasklet);
        } else {
            this.recordError(cycle, "Not_authorized_reset_password");
        }
    }

    public List<AdministrativeUser> getUsers() {
        State state = this.getState();
        if (state.users == null) {
            state.users = (List)this.getUsersBinding().getObject("users", List.class);
            state.currentUser = this.getCurrentUser();
            this.saveState(state);
        }
        Collections.sort(state.users, AdministrativeUser.COMPARE_BY_NAME_UP);
        ArrayList<AdministrativeUser> tempArray = new ArrayList<AdministrativeUser>();
        if (state.currentUser.isAdminManager() || this.getIsWsTrustAdminUserList()) {
            int count = 0;
            for (AdministrativeUser user : state.users) {
                if (!user.isAdminManager() || !user.isActive()) continue;
                ++count;
            }
            boolean deactivateDisabled = count < 2 && this.isRequireOneAdminManager();
            for (AdministrativeUser user : state.users) {
                user.setDeactivateDisabled(false);
                if (!user.isAdminManager()) continue;
                user.setDeactivateDisabled(deactivateDisabled);
            }
            return state.users;
        }
        for (AdministrativeUser user : state.users) {
            if (!user.getUserName().equals(state.currentUser.getUserName())) continue;
            tempArray.add(user);
            break;
        }
        return tempArray;
    }

    public boolean isAdminManager() {
        return this.getState().currentUser.isAdminManager();
    }

    private boolean isAuthorizedForReset(IRequestCycle cycle) {
        return this.getCurrentUser().isAdminManager();
    }

    private boolean isAuthorizedForChange(IRequestCycle cycle, List<AdministrativeUser> users) {
        AdministrativeUser currentUser = this.getCurrentUser();
        Object[] serviceParams = cycle.getServiceParameters();
        if (Array.getLength(serviceParams) == 1) {
            Integer userIndex = (Integer)serviceParams[0];
            AdministrativeUser user = users.get(userIndex);
            return currentUser.getUserName().equals(user.getUserName());
        }
        return false;
    }

    protected boolean isRequireOneAdminManager() {
        IBinding binding = this.getRequireOneAdminManagerBinding();
        if (binding == null) {
            return true;
        }
        return binding.getBoolean();
    }

    private void recordError(IRequestCycle cycle, String errorMsgKey) {
        TaskletState state = this.getCurrentState();
        Tasklet parentTasklet = this.findParent(Tasklet.class);
        ValidationDelegate delegate = parentTasklet.getDelegate(cycle);
        delegate.setFormComponent(null);
        delegate.record(state.getMessage(errorMsgKey), ValidationConstraint.REQUIRED);
    }

    public class State
    implements Serializable {
        private static final long serialVersionUID = 20050515L;
        AdministrativeUser currentUser;
        List<AdministrativeUser> users;

        public void reset() {
            this.users = null;
            AdminUserList.this.saveState(this);
        }
    }
}

