/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.component.common;

import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletCard;
import com.pingidentity.fsm.tasklet.data.AffiliationItem;
import com.pingidentity.fsm.tasklet.data.Mode;
import com.pingidentity.fsm.tasklet.impl.ManageAffiliationsTasklet;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.tapestry.IBinding;
import org.apache.tapestry.IRequestCycle;
import org.sourceid.saml20.domain.mgmt.ConnectionManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public abstract class AffiliationList
extends TaskletCard {
    public abstract IBinding getAffiliationsBinding();

    public abstract boolean getCacheTasklets();

    public abstract IBinding getStateBinding();

    private void saveState(State curState) {
        this.getStateBinding().setObject((Object)curState);
    }

    private State getState() {
        State state = (State)this.getStateBinding().getObject("state", Object.class);
        if (state == null) {
            state = new State();
        }
        return state;
    }

    public void edit(IRequestCycle cycle) {
        AffiliationItem affiliationItem;
        Object[] params = cycle.getServiceParameters();
        Integer affiliationItemToEdit = (Integer)params[0];
        if (affiliationItemToEdit != null && (affiliationItem = this.getAffiliationFromList(affiliationItemToEdit)) != null) {
            Tasklet tasklet = null;
            if (this.getCacheTasklets()) {
                tasklet = affiliationItem.getTasklet();
            }
            if (tasklet == null) {
                tasklet = this.createAndPopulateAffiliationTasklet(affiliationItem);
            }
            this.loadTasklet(tasklet);
            ((ManageAffiliationsTasklet)tasklet).gotoSummaryState(cycle);
            affiliationItem.setTasklet(tasklet);
        }
    }

    public void delete(IRequestCycle cycle) {
        if (this.isCurrentUserAdmin()) {
            Object[] params = cycle.getServiceParameters();
            String affiliationToDelete = (String)params[0];
            this.deleteAffiliation(affiliationToDelete);
        } else {
            this.auditLogUnauthorizedUserDeleteAction("affiliation list");
        }
    }

    public void deleteAffiliation(String affiliationToDelete) {
        ConnectionManager connectionManager = MgmtFactory.getConnectionManager();
        State state = this.getState();
        for (AffiliationItem affiliationItem : state.affiliations) {
            if (!affiliationItem.getAffiliationId().equals(affiliationToDelete)) continue;
            connectionManager.deleteAffiliation(connectionManager.getAffiliation(affiliationItem.getAffiliationId()));
            break;
        }
        this.saveState(state);
    }

    private Tasklet createAndPopulateAffiliationTasklet(AffiliationItem affiliationItem) {
        ManageAffiliationsTasklet tasklet = this.createTaskletToLoad(ManageAffiliationsTasklet.class, "ManageAffiliationsTasklet", "Edit an Affiliation");
        tasklet.skipImportState();
        tasklet.setMode(Mode.edit);
        tasklet.populate(affiliationItem.getAffiliation());
        return tasklet;
    }

    public void sortAffiliationName(IRequestCycle cycle) {
        State state = this.getState();
        if (state.sortBy == SORT_BY.Affiliation) {
            state.sortAffiliationNameUp = !state.sortAffiliationNameUp;
        }
        state.sortBy = SORT_BY.Affiliation;
        this.saveState(state);
    }

    public void sortStatus(IRequestCycle cycle) {
        State state = this.getState();
        if (state.sortBy == SORT_BY.Status) {
            state.sortStatusUp = !state.sortStatusUp;
        }
        state.sortBy = SORT_BY.Status;
        this.saveState(state);
    }

    public boolean isAffiliationNameUp() {
        State state = this.getState();
        return state.sortAffiliationNameUp && state.sortBy == SORT_BY.Affiliation;
    }

    public boolean isAffiliationNameDown() {
        State state = this.getState();
        return !state.sortAffiliationNameUp && state.sortBy == SORT_BY.Affiliation;
    }

    public boolean isStatusSortUp() {
        State state = this.getState();
        return state.sortStatusUp && state.sortBy == SORT_BY.Status;
    }

    public boolean isStatusSortDown() {
        State state = this.getState();
        return !state.sortStatusUp && state.sortBy == SORT_BY.Status;
    }

    public AffiliationItem getAffiliationFromList(Integer identifier) {
        State state = this.getState();
        return state.affiliations.get(identifier);
    }

    public ArrayList<AffiliationItem> getAffiliations() {
        State state = this.getState();
        if (state.affiliations == null) {
            state.affiliations = (ArrayList)this.getAffiliationsBinding().getObject("affiliations", ArrayList.class);
        }
        switch (state.sortBy) {
            case Affiliation: {
                if (state.sortAffiliationNameUp) {
                    Collections.sort(state.affiliations, AffiliationItem.COMPARE_BY_NAME_UP);
                    break;
                }
                Collections.sort(state.affiliations, AffiliationItem.COMPARE_BY_NAME_DOWN);
                break;
            }
            case Status: {
                if (state.sortStatusUp) {
                    Collections.sort(state.affiliations, AffiliationItem.COMPARE_BY_STATUS_UP);
                    break;
                }
                Collections.sort(state.affiliations, AffiliationItem.COMPARE_BY_STATUS_DOWN);
            }
        }
        this.saveState(state);
        return state.affiliations;
    }

    public void setAffiliations(ArrayList<AffiliationItem> affiliations) {
        State state = this.getState();
        state.affiliations = affiliations;
        this.saveState(state);
    }

    protected void prepareForRender(IRequestCycle cycle) {
        super.prepareForRender(cycle);
        if (cycle.isRewinding()) {
            return;
        }
        this.getCurrentState().refreshState();
    }

    private class State
    implements Serializable {
        private static final long serialVersionUID = 20050515L;
        ArrayList<AffiliationItem> affiliations;
        boolean sortAffiliationNameUp;
        boolean sortStatusUp;
        SORT_BY sortBy = SORT_BY.Affiliation;

        private State() {
        }
    }

    private static enum SORT_BY {
        Affiliation,
        Protocol,
        Status;

    }
}

