/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.component.common;

import com.pingidentity.fsm.tasklet.TaskletCard;
import com.pingidentity.fsm.tasklet.data.MappingNameItem;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.IBinding;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.apache.tapestry.valid.ValidationDelegate;

public abstract class AttributeNameMappingEditor
extends TaskletCard
implements Serializable {
    public abstract IBinding getListBinding();

    public abstract IBinding getStateBinding();

    public abstract IBinding getDelegateBinding();

    public abstract IBinding getAllowEmptyBinding();

    public Boolean getAllowEmpty() {
        IBinding binding = this.getAllowEmptyBinding();
        return binding.getBoolean();
    }

    public List<MappingNameItem> getList() {
        return (List)this.getListBinding().getObject("List", List.class);
    }

    public List<MappingNameItem> getListCopy() {
        List list = (List)this.getListBinding().getObject("List", List.class);
        List<MappingNameItem> listCopy = list.stream().collect(Collectors.toList());
        return listCopy;
    }

    public ValidationDelegate getDelegate() {
        return (ValidationDelegate)this.getDelegateBinding().getObject("delegate", ValidationDelegate.class);
    }

    protected void saveState(NameMappingState curState) {
        this.getStateBinding().setObject((Object)curState);
    }

    protected NameMappingState getState() {
        NameMappingState state = (NameMappingState)this.getStateBinding().getObject("state", Object.class);
        if (state == null) {
            state = new NameMappingState();
            this.saveState(state);
        }
        return state;
    }

    public boolean isEditMode() {
        return this.getState().editItem != null;
    }

    public boolean isCurrentItemEditing() {
        NameMappingState curState = this.getState();
        return curState.currentItem.equals(curState.editItem);
    }

    public void setCurrentItem(MappingNameItem currentItem) {
        NameMappingState s = this.getState();
        s.currentItem = currentItem;
        this.saveState(s);
    }

    public MappingNameItem getCurrentItem() {
        return this.getState().currentItem;
    }

    public MappingNameItem getNewItem() {
        return this.getState().newItem;
    }

    public void setNewItem(MappingNameItem newItem) {
        NameMappingState s = this.getState();
        s.newItem = newItem;
        this.saveState(s);
    }

    public MappingNameItem getEditItem() {
        return this.getState().editItem;
    }

    public void setEditItem(MappingNameItem item) {
        NameMappingState s = this.getState();
        s.editItem = item;
        this.saveState(s);
    }

    public MappingNameItem getUpdateItem() {
        return this.getState().updateItem;
    }

    public void setUpdateItem(MappingNameItem updateItem) {
        NameMappingState s = this.getState();
        s.updateItem = updateItem;
        this.saveState(s);
    }

    public void onAddItem(IRequestCycle cycle) {
        MappingNameItem addItem;
        boolean hasErrors = false;
        if (StringUtils.isBlank((String)this.getState().newItem.getLocalName())) {
            this.getDelegate().setFormComponent(null);
            this.getDelegate().record(this.getMessage("Local_name_required"), ValidationConstraint.REQUIRED);
            hasErrors = true;
        }
        if (StringUtils.isBlank((String)this.getState().newItem.getRemoteName())) {
            this.getDelegate().setFormComponent(null);
            this.getDelegate().record(this.getMessage("Remote_name_required"), ValidationConstraint.REQUIRED);
            hasErrors = true;
        }
        if ((addItem = this.findByLocalName(this.getState().newItem.getLocalName())) != null) {
            this.getDelegate().setFormComponent(null);
            this.getDelegate().record(this.getMessage("Already_contains") + " " + this.getState().newItem.getLocalName(), ValidationConstraint.REQUIRED);
            hasErrors = true;
        }
        if ((addItem = this.findByRemoteName(this.getState().newItem.getRemoteName())) != null) {
            this.getDelegate().setFormComponent(null);
            this.getDelegate().record(this.getMessage("Already_contains") + " " + this.getState().newItem.getRemoteName(), ValidationConstraint.REQUIRED);
            hasErrors = true;
        }
        if (!hasErrors) {
            NameMappingState s = this.getState();
            this.getList().add(s.newItem);
            s.newItem = new MappingNameItem();
            this.saveState(s);
        }
    }

    public void onUpdateItem(IRequestCycle cycle) {
        boolean hasErrors = false;
        if (this.getState().updateItem.equals(this.getState().editItem)) {
            this.getState().editItem = null;
            this.getState().updateItem = null;
        } else {
            if (StringUtils.isBlank((String)this.getState().updateItem.getLocalName())) {
                this.getDelegate().setFormComponent(null);
                this.getDelegate().record(this.getMessage("Local_name_required"), ValidationConstraint.REQUIRED);
                hasErrors = true;
            }
            if (StringUtils.isBlank((String)this.getState().updateItem.getRemoteName())) {
                this.getDelegate().setFormComponent(null);
                this.getDelegate().record(this.getMessage("Remote_name_required"), ValidationConstraint.REQUIRED);
                hasErrors = true;
            }
            MappingNameItem updateItem = null;
            if (!this.getState().updateItem.getLocalName().equals(this.getState().editItem.getLocalName()) && (updateItem = this.findByLocalName(this.getState().updateItem.getLocalName())) != null) {
                this.getDelegate().setFormComponent(null);
                this.getDelegate().record(this.getMessage("Already_contains") + " " + this.getState().updateItem.getLocalName(), ValidationConstraint.REQUIRED);
                hasErrors = true;
            }
            if (!this.getState().updateItem.getRemoteName().equals(this.getState().editItem.getRemoteName()) && (updateItem = this.findByRemoteName(this.getState().updateItem.getRemoteName())) != null) {
                this.getDelegate().setFormComponent(null);
                this.getDelegate().record(this.getMessage("Already_contains") + " " + this.getState().updateItem.getRemoteName(), ValidationConstraint.REQUIRED);
                hasErrors = true;
            }
            if (!hasErrors) {
                NameMappingState s = this.getState();
                MappingNameItem mapping = this.findByLocalName(s.editItem.getLocalName());
                mapping.setLocalName(s.updateItem.getLocalName());
                mapping.setRemoteName(s.updateItem.getRemoteName());
                this.getState().editItem = null;
                s.updateItem = null;
                this.saveState(s);
            }
        }
    }

    public void onEditItem(IRequestCycle cycle) {
        Object[] params = cycle.getServiceParameters();
        NameMappingState curState = this.getState();
        String itemToEdit = (String)params[0];
        MappingNameItem editItem = this.findByLocalName(itemToEdit);
        curState.editItem = new MappingNameItem(editItem);
        curState.updateItem = new MappingNameItem(editItem);
        this.saveState(curState);
    }

    public void onDeleteItem(IRequestCycle cycle) {
        if (this.isCurrentUserAdmin()) {
            Object[] params = cycle.getServiceParameters();
            String deleteItem = (String)params[0];
            this.getList().remove(this.findByLocalName(deleteItem));
        } else {
            this.auditLogUnauthorizedUserDeleteAction("attribute name mapping editor");
        }
    }

    public void cancelEdit(IRequestCycle cycle) {
        NameMappingState curState = this.getState();
        curState.updateItem = null;
        curState.editItem = null;
        this.saveState(curState);
    }

    @Override
    public void appendErrors(IValidationDelegate delegate) {
        if (this.isEditMode()) {
            delegate.setFormComponent(null);
            delegate.record(this.getMessage("Update_required"), ValidationConstraint.REQUIRED);
        }
        if (!this.getAllowEmpty().booleanValue() && this.getList().isEmpty()) {
            delegate.setFormComponent(null);
            delegate.record(this.getMessage("One_attribute_required"), ValidationConstraint.REQUIRED);
        }
    }

    private MappingNameItem findByLocalName(String searchLocalName) {
        MappingNameItem foundItem = null;
        for (MappingNameItem item : this.getList()) {
            if (!item.getLocalName().equals(searchLocalName)) continue;
            foundItem = item;
            break;
        }
        return foundItem;
    }

    private MappingNameItem findByRemoteName(String searchRemoteName) {
        MappingNameItem foundItem = null;
        for (MappingNameItem item : this.getList()) {
            if (!item.getRemoteName().equals(searchRemoteName)) continue;
            foundItem = item;
            break;
        }
        return foundItem;
    }

    private class NameMappingState
    implements Serializable {
        private static final long serialVersionUID = 20050515L;
        MappingNameItem updateItem;
        MappingNameItem editItem;
        MappingNameItem currentItem;
        MappingNameItem newItem = new MappingNameItem();

        private NameMappingState() {
        }
    }
}

