/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.component.common;

import com.pingidentity.admin.api.validator.OpenIdConnectPolicyScopeAttributeValidator;
import com.pingidentity.common.util.EscapeUtils;
import com.pingidentity.component.common.NameValuePair;
import com.pingidentity.component.common.SelectedOption;
import com.pingidentity.component.common.StringPairListEditor;
import com.pingidentity.fsm.helper.ScopeFilterableSelectionHelper;
import com.pingidentity.fsm.state.impl.AttributeScopesState;
import com.pingidentity.fsm.tasklet.data.CheckboxModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.IBinding;
import org.apache.tapestry.IRequestCycle;
import org.sourceid.saml20.adapter.gui.FilterableSelectionFieldDescriptor;

public abstract class AttributeScopesListEditor
extends StringPairListEditor {
    private static final long serialVersionUID = 1L;
    private int count;
    private String currentSubScope;

    public abstract IBinding getScopeAttributeModelBinding();

    public abstract IBinding getScopeModelBinding();

    public abstract IBinding getAttributeModelBinding();

    public Map<String, CheckboxModel> getScopeAttributeModel() {
        return (Map)this.getScopeAttributeModelBinding().getObject("scopeAttributeModel", Map.class);
    }

    public void setScopeGroupModel(Map<String, CheckboxModel> scopeGroupModel) {
        this.getScopeAttributeModelBinding().setObject(scopeGroupModel);
    }

    public List<NameValuePair> getScopeModel() {
        return (List)this.getScopeModelBinding().getObject("scopeModel", List.class);
    }

    public List<NameValuePair> getAttributeModel() {
        return (List)this.getAttributeModelBinding().getObject("attributeModel", List.class);
    }

    public CheckboxModel getNewCheckboxModel(String scopeName) {
        CheckboxModel cbm = new CheckboxModel();
        for (String attributeName : this.getAttributeModelSorted()) {
            boolean isDisabled = AttributeScopesState.isDisabled(scopeName, attributeName);
            cbm.add(attributeName, false, isDisabled, isDisabled);
        }
        cbm.sortAlphabetically();
        return cbm;
    }

    public List<FilterableSelectionFieldDescriptor.SearchableTypeConfig> getSearchableTypes() {
        return List.of(FilterableSelectionFieldDescriptor.SearchableTypeConfig.OAUTH_COMMON_SCOPE, FilterableSelectionFieldDescriptor.SearchableTypeConfig.OAUTH_EXCLUSIVE_SCOPE);
    }

    public String getNewScopeDisplayName() {
        if (this.getState().newItem != null && StringUtils.isNotEmpty((String)this.getState().newItem.getName())) {
            return ScopeFilterableSelectionHelper.getScopeDisplayName(this.getState().newItem.getName(), ScopeFilterableSelectionHelper.getSearchableType(this.getState().newItem.getName()));
        }
        return null;
    }

    public void setNewScopeDisplayName(String scopeDisplayName) {
    }

    public String getNewScopeTypeAndId() {
        if (this.getState().newItem != null && StringUtils.isNotEmpty((String)this.getState().newItem.getName())) {
            SelectedOption option = new SelectedOption(ScopeFilterableSelectionHelper.getSearchableType(this.getState().newItem.getName()), this.getState().newItem.getName());
            return option.toString();
        }
        return null;
    }

    public void setNewScopeTypeAndId(String scopeTypeAndId) {
        if (scopeTypeAndId != null) {
            SelectedOption option = new SelectedOption(scopeTypeAndId);
            this.getState().newItem.setName(option.getId());
            this.getState().newItem.setValue(option.getId());
        }
    }

    public String getUpdateScopeDisplayName() {
        if (this.getState().updateItem != null && StringUtils.isNotEmpty((String)this.getState().updateItem.getName())) {
            return ScopeFilterableSelectionHelper.getScopeDisplayName(this.getState().updateItem.getName(), ScopeFilterableSelectionHelper.getSearchableType(this.getState().updateItem.getName()));
        }
        return null;
    }

    public void setUpdateScopeDisplayName(String scopeDisplayName) {
    }

    public String getUpdateScopeTypeAndId() {
        if (this.getState().updateItem != null && StringUtils.isNotEmpty((String)this.getState().updateItem.getName())) {
            SelectedOption option = new SelectedOption(ScopeFilterableSelectionHelper.getSearchableType(this.getState().updateItem.getName()), this.getState().updateItem.getName());
            return option.toString();
        }
        return null;
    }

    public void setUpdateScopeTypeAndId(String scopeTypeAndId) {
        if (scopeTypeAndId != null) {
            SelectedOption option = new SelectedOption(scopeTypeAndId);
            this.getState().updateItem.setName(option.getId());
            this.getState().updateItem.setValue(option.getId());
        }
    }

    @Override
    protected boolean basicItemValidate(NameValuePair itemToValidate, NameValuePair originalItem) {
        String value;
        String name;
        boolean hasErrors = false;
        if (this.getAllowEmptyNameOrValue().booleanValue()) {
            if (StringUtils.isBlank((String)itemToValidate.getName()) && StringUtils.isBlank((String)itemToValidate.getValue())) {
                this.recErrorMsg("Please provide a value for " + this.getNameColumnTitleBinding().getString() + ".");
                hasErrors = true;
            }
        } else {
            if (StringUtils.isBlank((String)itemToValidate.getName())) {
                this.recErrorMsg("Please provide a value for " + this.getNameColumnTitleBinding().getString() + ".");
                hasErrors = true;
            }
            if (StringUtils.isBlank((String)itemToValidate.getValue())) {
                this.recErrorMsg("Please provide a value for " + this.getValueColumnTitleBinding().getString() + ".");
                hasErrors = true;
            }
        }
        if (!hasErrors && !this.getAllowSameNameValue().booleanValue() && StringUtils.equals((String)(name = itemToValidate.getName()), (String)(value = itemToValidate.getValue()))) {
            this.recErrorMsg("The " + this.getNameColumnTitleBinding().getString() + " and " + this.getValueColumnTitleBinding().getString() + " values must be different.");
            hasErrors = true;
        }
        if (!hasErrors) {
            hasErrors = this.extraItemValidate(itemToValidate, originalItem);
        }
        return hasErrors;
    }

    @Override
    protected boolean extraItemValidate(NameValuePair itemToValidate, NameValuePair originalItem) {
        boolean hasError = false;
        Object o = this.getOwnerStateBinding().getObject();
        if (o instanceof StringPairListEditor.StringPairListEditorListener) {
            StringPairListEditor.StringPairListEditorListener listener;
            String msg;
            String originalItemName = null;
            String originalItemValue = null;
            if (originalItem != null) {
                originalItemName = originalItem.getName();
                originalItemValue = originalItem.getValue();
            }
            if ((msg = (listener = (StringPairListEditor.StringPairListEditorListener)o).validate(itemToValidate.getName(), itemToValidate.getValue(), originalItemName, originalItemValue, this.getList(), this)) != null) {
                this.recErrorMsg(msg);
                hasError = true;
            }
        }
        return hasError;
    }

    public List<NameValuePair> getScopeModelSorted() {
        List scopeModelSorted = (List)this.getScopeModelBinding().getObject("scopeModel", List.class);
        Collections.sort(scopeModelSorted);
        return scopeModelSorted;
    }

    public List<String> getAttributeModelSorted() {
        List attributeModelSorted = (List)this.getAttributeModelBinding().getObject("attributeModel", List.class);
        Collections.sort(attributeModelSorted);
        return attributeModelSorted;
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public String getCurrentSubScope() {
        return this.currentSubScope;
    }

    public void setCurrentSubScope(String currentSubScope) {
        this.currentSubScope = currentSubScope;
    }

    public CheckboxModel getUpdateGroupItems() {
        return this.getGroupState().updateGroupItems;
    }

    public CheckboxModel getNewGroupItems(String scope) {
        GroupState state = this.getGroupState();
        CheckboxModel result = this.newCheckboxModel(scope);
        for (String subScope : state.newGroupItems.getSelectedNames()) {
            result.setChecked(subScope);
        }
        state.newGroupItems = result;
        return result;
    }

    @Override
    protected void doEdit(IRequestCycle cycle) {
        CheckboxModel cbm = this.getScopeAttributeModel().get(this.getRequestCycleItem(cycle).getName());
        cbm.sortAlphabetically();
        this.getGroupState().updateGroupItems = new CheckboxModel(cbm);
        super.doEdit(cycle);
    }

    @Override
    protected void doAdd() {
        GroupState state = this.getGroupState();
        this.getScopeAttributeModel().put(state.newItem.getName(), state.newGroupItems);
        state.newGroupItems = this.newCheckboxModel("");
        super.doAdd();
    }

    @Override
    protected boolean validateAdd(NameValuePair itemToValidate, NameValuePair originalItem) {
        boolean hasErrors = super.validateAdd(itemToValidate, originalItem);
        if (!hasErrors) {
            hasErrors = this.getGroupState().newGroupItems.getSelectedNames().isEmpty();
            if (hasErrors) {
                this.recErrorMsg("At least one attribute must be selected for scope '" + itemToValidate.getName() + "'.");
            }
            if (hasErrors = this.getList().stream().anyMatch(nameValuePair -> nameValuePair.getName().equals(itemToValidate.getName()))) {
                this.recErrorMsg("Cannot add duplicate scope '" + itemToValidate.getName() + "'.");
            }
        }
        return hasErrors;
    }

    @Override
    protected boolean validateUpdate(NameValuePair itemToValidate, NameValuePair originalItem) {
        boolean hasErrors = super.validateUpdate(itemToValidate, originalItem);
        if (!hasErrors && (hasErrors = this.getGroupState().updateGroupItems.getSelectedNames().isEmpty())) {
            this.recErrorMsg("At least one attribute must be selected for scope '" + itemToValidate.getName() + "'.");
            GroupState groupState = this.getGroupState();
            this.getScopeAttributeModel().put(itemToValidate.getName(), groupState.updateGroupItems);
            this.saveState(groupState);
        }
        return hasErrors;
    }

    @Override
    protected void doUpdate() {
        GroupState state = this.getGroupState();
        this.getScopeAttributeModel().put(state.updateItem.getName(), state.updateGroupItems);
        super.doUpdate();
    }

    @Override
    protected void doCancel() {
        GroupState state = this.getGroupState();
        state.updateGroupItems = null;
        super.doCancel();
    }

    @Override
    protected StringPairListEditor.State getState() {
        StringPairListEditor.State state = (StringPairListEditor.State)this.getStateBinding().getObject("state", Object.class);
        if (state == null) {
            state = new GroupState();
            this.saveState(state);
        }
        return state;
    }

    CheckboxModel newCheckboxModel(String scope) {
        CheckboxModel cbm = new CheckboxModel();
        for (String nvPair : this.getAttributeModelSorted()) {
            boolean isDisabled = AttributeScopesState.isDisabled(scope, nvPair);
            cbm.add(nvPair, false, isDisabled, isDisabled);
        }
        return cbm;
    }

    public boolean showAttributes(String scope) {
        return StringUtils.isNotBlank((String)scope);
    }

    public String showWarning() {
        if (this.getScopeAttributeModel().get("profile") != null) {
            return this.areAllAttributesMapped();
        }
        if (!(this.hasScope("profile") && this.hasScope("email") && this.hasScope("phone") && this.hasScope("address"))) {
            return this.areAllAttributesMapped();
        }
        return null;
    }

    private String areAllAttributesMapped() {
        ArrayList<String> allAttributes = new ArrayList<String>(this.getAttributeModelSorted());
        allAttributes.remove("sub");
        if (this.hasScope("email")) {
            allAttributes.removeAll((Collection)OpenIdConnectPolicyScopeAttributeValidator.scopesEnabledMap.get("email"));
        }
        if (this.hasScope("address")) {
            allAttributes.removeAll((Collection)OpenIdConnectPolicyScopeAttributeValidator.scopesEnabledMap.get("address"));
        }
        if (this.hasScope("phone")) {
            allAttributes.removeAll((Collection)OpenIdConnectPolicyScopeAttributeValidator.scopesEnabledMap.get("phone"));
        }
        ArrayList<String> allAddedAttributes = new ArrayList<String>();
        for (CheckboxModel checkboxModels : this.getScopeAttributeModel().values()) {
            allAddedAttributes.addAll(checkboxModels.getSelectedNames());
        }
        StringBuilder stringBuilder = new StringBuilder("The following attributes are not associated with a scope and will not be accessible by OAuth clients: ");
        if (!allAddedAttributes.containsAll(allAttributes)) {
            allAttributes.removeAll(allAddedAttributes);
            return EscapeUtils.escape((String)stringBuilder.append(String.join((CharSequence)", ", allAttributes)).append(".").toString());
        }
        return null;
    }

    private boolean hasScope(String scope) {
        for (NameValuePair nvPair : this.getScopeModel()) {
            if (!nvPair.getName().equals(scope)) continue;
            return true;
        }
        return false;
    }

    private GroupState getGroupState() {
        return (GroupState)this.getState();
    }

    public class GroupState
    extends StringPairListEditor.State {
        private static final long serialVersionUID = 1L;
        CheckboxModel updateGroupItems;
        CheckboxModel newGroupItems;

        public GroupState() {
            this.newGroupItems = AttributeScopesListEditor.this.newCheckboxModel("");
        }
    }
}

