/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.component.common;

import com.pingidentity.component.common.NameValuePair;
import com.pingidentity.component.common.StringPairListEditor;
import org.apache.commons.lang.StringUtils;

public abstract class AuthnCtxListEditor
extends StringPairListEditor {
    private static final long serialVersionUID = 1L;
    private static final String ASTERISK_MSG = "An asterisk '*' for the %s value can only be used as a single character and it cannot be combined with other characters.";
    private static final String DUPLICATE_MSG = "%s value '%s' can only have one mapping where the %s value is not an asterisk '*'.";
    private static final String DUPLICATE_EMPTY_SPACE_MSG = "There can only be one mapping with a blank %s value where the %s value is not an asterisk '*'.";

    @Override
    protected boolean basicItemValidate(NameValuePair itemToValidate, NameValuePair originalItem) {
        boolean hasErrors = super.basicItemValidate(itemToValidate, originalItem);
        if (!hasErrors) {
            hasErrors |= this.validateAsterisk(this.getNameColumnTitleBinding().getString(), itemToValidate.getName());
            hasErrors |= this.validateAsterisk(this.getValueColumnTitleBinding().getString(), itemToValidate.getValue());
        }
        if (!hasErrors) {
            for (NameValuePair existingItem : this.getList()) {
                if (!existingItem.equals((Object)originalItem)) {
                    if (itemToValidate.equals((Object)existingItem)) {
                        this.recErrorMsg("Duplicate mapping is not allowed.");
                        hasErrors = true;
                        break;
                    }
                    hasErrors |= this.validateDuplicates(this.getValueColumnTitleBinding().getString(), this.getNameColumnTitleBinding().getString(), itemToValidate.getName(), itemToValidate.getValue(), existingItem.getName(), existingItem.getValue());
                    hasErrors |= this.validateDuplicates(this.getNameColumnTitleBinding().getString(), this.getValueColumnTitleBinding().getString(), itemToValidate.getValue(), itemToValidate.getName(), existingItem.getValue(), existingItem.getName());
                }
                if (!hasErrors) continue;
                break;
            }
        }
        return hasErrors;
    }

    private boolean validateDuplicates(String sourceColumn, Object targetColumn, String itemToValidateTarget, String itemToValidateSource, String existingItemTarget, String existingItemSource) {
        if (itemToValidateSource.equals(existingItemSource) && !this.hasWildcard(existingItemTarget) && !this.hasWildcard(itemToValidateTarget)) {
            String error = null;
            error = StringUtils.isBlank((String)itemToValidateSource) ? String.format(DUPLICATE_EMPTY_SPACE_MSG, sourceColumn, targetColumn) : String.format(DUPLICATE_MSG, sourceColumn, itemToValidateSource, targetColumn);
            this.recErrorMsg(error);
            return true;
        }
        return false;
    }

    private boolean validateAsterisk(String columnName, String value) {
        if (this.hasWildcard(value) && value.length() != 1) {
            this.recErrorMsg(String.format(ASTERISK_MSG, columnName));
            return true;
        }
        return false;
    }

    private boolean hasWildcard(String value) {
        return value.contains("*");
    }
}

