/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.component.common;

import com.pingidentity.fsm.state.impl.ConfigureCustomSourceFiltersState;
import com.pingidentity.fsm.tasklet.TaskletCard;
import com.pingidentity.fsm.tasklet.data.AttributeLookupTestResult;
import com.pingidentity.fsm.tasklet.data.TestDataItem;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.tapestry.IBinding;
import org.apache.tapestry.IRequestCycle;

public abstract class DatasourceAttributeLookupTest
extends TaskletCard {
    public abstract IBinding getStateBinding();

    public abstract IBinding getTestDataListBinding();

    public State getState() {
        State state = (State)this.getStateBinding().getObject("state", Object.class);
        if (state == null) {
            state = new State();
            this.saveState(state);
        }
        return state;
    }

    protected void saveState(State curState) {
        this.getStateBinding().setObject((Object)curState);
    }

    public void onUpdateItem(IRequestCycle cycle) {
        this.resetPage();
        this.getTestDataListBinding().setObject(this.getState().getTestDataList());
    }

    private void resetPage() {
        this.getState().setTestResults(new AttributeLookupTestResult());
    }

    protected void prepareForRender(IRequestCycle cycle) {
        super.prepareForRender(cycle);
        if (!cycle.isRewinding()) {
            this.getState().setTestDataList(this.copyTestDataList((List)this.getTestDataListBinding().getObject("testDataList", List.class)));
        }
    }

    private List<TestDataItem> copyTestDataList(List<TestDataItem> originalList) {
        ArrayList<TestDataItem> copy = new ArrayList<TestDataItem>();
        for (TestDataItem origTDI : originalList) {
            copy.add(new TestDataItem(origTDI.getFieldName(), origTDI.getTestValue()));
        }
        return copy;
    }

    public void onTestLookup(IRequestCycle cycle) {
        ConfigureCustomSourceFiltersState filterState = this.getCurrentState(ConfigureCustomSourceFiltersState.class);
        List<TestDataItem> testData = this.getState().getTestDataList();
        AttributeLookupTestResult testResult = filterState.doTestLookup(testData);
        this.getState().setTestResults(testResult);
        if (testResult.getError() != null) {
            this.getState().setHasError(true);
            this.getState().setError(testResult.getError());
        } else {
            this.getState().setHasError(false);
        }
    }

    public void onCancelTest(IRequestCycle cycle) {
        ConfigureCustomSourceFiltersState state = this.getCurrentState(ConfigureCustomSourceFiltersState.class);
        state.setTestingLookup(false);
    }

    public List<TestDataItem> getTestDataList() {
        return this.getState().getTestDataList();
    }

    public Object getTestResults() {
        return this.getState().getTestResults();
    }

    public Object getHasError() {
        return this.getState().hasError;
    }

    public Object getError() {
        return this.getState().error;
    }

    private static class State
    implements Serializable {
        private List<TestDataItem> testDataList = new ArrayList<TestDataItem>();
        private AttributeLookupTestResult testResults;
        private String error;
        private boolean hasError;

        private State() {
        }

        public List<TestDataItem> getTestDataList() {
            return this.testDataList;
        }

        public void setTestDataList(List<TestDataItem> testDataList) {
            this.testDataList = testDataList;
        }

        public List<TestDataItem> getTestResults() {
            ArrayList<TestDataItem> testData = new ArrayList<TestDataItem>();
            if (this.testResults != null && this.testResults.getResultAttributes() != null) {
                for (Map.Entry<String, Object> result : this.testResults.getResultAttributes().entrySet()) {
                    testData.add(new TestDataItem(result.getKey(), result.getValue().toString()));
                }
            }
            return testData;
        }

        public void setTestResults(AttributeLookupTestResult testResults) {
            this.testResults = testResults;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }

        public boolean getHasError() {
            return this.hasError;
        }

        public void setHasError(boolean hasError) {
            this.hasError = hasError;
        }
    }
}

