/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.component.common;

import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletCard;
import com.pingidentity.fsm.tasklet.TaskletState;
import java.io.IOException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tapestry.IBinding;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.valid.ValidationConstraint;
import org.apache.tapestry.valid.ValidationDelegate;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.saml20.domain.log.AdminAuditLogger;
import org.sourceid.saml20.domain.log.AuditLoggerScope;

public abstract class Download
extends TaskletCard {
    private static final Log log = LogFactory.getLog(Download.class);

    public abstract String getContentType();

    public abstract boolean getNoCache();

    public abstract String getButtonText();

    public abstract IBinding getRawBytesBinding();

    public byte[] getRawBytes() {
        IBinding binding = this.getRawBytesBinding();
        if (binding == null) {
            return null;
        }
        return (byte[])binding.getObject();
    }

    public abstract IBinding getFilenameBinding();

    public String getFilename() {
        return (String)this.getFilenameBinding().getObject("filename", String.class);
    }

    public abstract IBinding getAuditLoggerComponentBinding();

    public AdminAuditLogger.Component getAuditLoggerComponent() {
        IBinding binding = this.getAuditLoggerComponentBinding();
        if (binding == null) {
            return AdminAuditLogger.Component.SYSTEM;
        }
        return (AdminAuditLogger.Component)binding.getObject();
    }

    public void download(IRequestCycle cycle) {
        if (this.isAuthorizedForAction()) {
            byte[] rawBytes = this.getRawBytes();
            if (rawBytes == null) {
                TaskletState state = this.getCurrentState();
                Tasklet parentTasklet = this.findParent(Tasklet.class);
                ValidationDelegate delegate = parentTasklet.getDelegate(cycle);
                delegate.setFormComponent(null);
                delegate.record(state.getMessage("Generic_download_error"), ValidationConstraint.REQUIRED);
            } else {
                Download.download(cycle, this.getNoCache(), this.getContentType(), rawBytes, this.getFilename(), this.getAuditLoggerComponent());
            }
        } else {
            TaskletState state = this.getCurrentState();
            Tasklet parentTasklet = this.findParent(Tasklet.class);
            ValidationDelegate delegate = parentTasklet.getDelegate(cycle);
            delegate.setFormComponent(null);
            delegate.record(state.getMessage("Not_authorized_to_download"), ValidationConstraint.REQUIRED);
        }
    }

    static void download(IRequestCycle cycle, boolean noCache, String contentType, byte[] content, String fileName, AdminAuditLogger.Component component) {
        HttpServletResponse response = cycle.getRequestContext().getResponse();
        ConfigStore cfg = ConfigStoreFarm.getConfig((String)"admin-downloads");
        boolean cacheDownloadResponse = cfg.getBooleanValue("cache-ie-download-response", true);
        String userAgent = cycle.getRequestContext().getRequest().getHeader("User-Agent");
        log.debug((Object)("User-Agent: " + userAgent));
        log.debug((Object)("Cache IE Response: " + cacheDownloadResponse));
        if (userAgent != null && userAgent.contains("MSIE") && cacheDownloadResponse) {
            log.debug((Object)"Removing Cache-Control & Pragma response headers");
            response.setHeader("Cache-Control", null);
            response.setHeader("Pragma", null);
        }
        if (noCache) {
            response.setDateHeader("Expires", 0L);
        }
        response.setHeader("Content-transfer-encoding", "binary");
        response.setContentType(contentType);
        response.setHeader("Content-disposition", "attachment; filename=" + fileName);
        response.setContentLength(content.length);
        Cookie downloadStartedCookie = new Cookie("pf-download-started", Boolean.TRUE.toString());
        downloadStartedCookie.setMaxAge(300);
        downloadStartedCookie.setPath("/");
        downloadStartedCookie.setSecure(true);
        response.addCookie(downloadStartedCookie);
        try (AuditLoggerScope auditLoggerScope = new AuditLoggerScope();){
            ServletOutputStream bytesOut = response.getOutputStream();
            bytesOut.write(content);
            response.flushBuffer();
            auditLoggerScope.log(component, AdminAuditLogger.Event.EXPORT, fileName);
        }
        catch (IOException io) {
            log.debug((Object)"Download file caused an IOException! ", (Throwable)io);
        }
    }
}

