/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.component.common;

import com.pingidentity.common.mgr.ExpressionManager;
import com.pingidentity.common.util.OgnlHelper;
import com.pingidentity.component.common.DataMap;
import com.pingidentity.fsm.tasklet.TaskletCard;
import com.pingidentity.fsm.tasklet.data.TestDataItem;
import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import ognl.Ognl;
import ognl.OgnlException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tapestry.IBinding;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.sourceid.common.ExceptionUtil;
import org.sourceid.saml20.adapter.attribute.AttributeValue;
import org.sourceid.saml20.domain.log.AdminAuditLogger;

public abstract class ExpressionTest
extends TaskletCard {
    private static final Log log = LogFactory.getLog(ExpressionTest.class);
    public static final String ERROR_DURING_EXPRESSION_EVAL = "Error during expression evaluation: ";
    private static final String TEST_SKIPPED = "Expression evaluation skipped: ";
    private static final String VALUE_REQUIRED = "Empty String";
    private static final String USER_NOT_AUTHORIZED = "User not authorized to test this expression.";

    public abstract IBinding getStateBinding();

    public abstract IBinding getDelegateBinding();

    public abstract IBinding getSourcesBinding();

    public abstract IBinding getTestingExpressionBinding();

    public abstract IBinding getExpressionBinding();

    public abstract IBinding getTestDataListBinding();

    public State getState() {
        State state = (State)this.getStateBinding().getObject("state", Object.class);
        if (state == null) {
            state = new State();
            this.saveState(state);
        }
        return state;
    }

    public void onUpdateItem(IRequestCycle cycle) {
        this.resetPage();
        this.setExpression(this.getState().getExpressionToTest());
        this.getTestDataListBinding().setObject(this.getState().getTestDataList());
    }

    public void onCancelEdit(IRequestCycle cycle) {
        this.resetPage();
    }

    private void resetPage() {
        this.setTestingExpression(false);
        this.getState().setTestResults("");
        this.getState().setPageLoaded(false);
    }

    public void onTestData(IRequestCycle cycle) {
        if (!this.getCurrentState().getCurrentUser().isAuditor()) {
            this.wasTestSuccessful();
        }
    }

    @Override
    public void appendErrors(IValidationDelegate delegate) {
        if (this.isTestingExpression()) {
            ExpressionTest.recordValidationError(delegate, this.getMessage("Update_required"));
        }
    }

    protected void saveState(State curState) {
        this.getStateBinding().setObject((Object)curState);
    }

    protected void prepareForRender(IRequestCycle cycle) {
        super.prepareForRender(cycle);
        if (!cycle.isRewinding() && !this.getState().isPageLoaded()) {
            this.getState().setExpressionToTest(this.getExpression());
            this.getState().setTestDataList(this.copyTestDataList((List)this.getTestDataListBinding().getObject("testDataList", List.class)));
            Collections.sort(this.getState().getTestDataList(), TestDataItem.COMPARE_BY_FIELDNAME);
            this.getState().setPageLoaded(true);
        }
    }

    private List<TestDataItem> copyTestDataList(List<TestDataItem> originalList) {
        ArrayList<TestDataItem> copy = new ArrayList<TestDataItem>();
        for (TestDataItem origTDI : originalList) {
            copy.add(new TestDataItem(origTDI.getFieldName(), origTDI.getTestValue()));
        }
        return copy;
    }

    public Object getTestResults() {
        return this.getState().getTestResults();
    }

    public List<TestDataItem> getTestDataList() {
        return this.getState().getTestDataList();
    }

    public void setTestDataList(List<TestDataItem> testDataList) {
        this.getState().setTestDataList(testDataList);
    }

    public String getExpressionToTest() {
        return this.getState().getExpressionToTest();
    }

    public void setExpressionToTest(String expressionToTest) {
        this.getState().setExpressionToTest(expressionToTest);
    }

    private String getExpression() {
        return this.getExpressionBinding().getString();
    }

    private void setExpression(String updatedExpression) {
        this.getExpressionBinding().setString(updatedExpression);
    }

    private IValidationDelegate getDelegate() {
        return (IValidationDelegate)this.getDelegateBinding().getObject("delegate", IValidationDelegate.class);
    }

    private DataMap.Sources getSources() {
        return (DataMap.Sources)this.getSourcesBinding().getObject("sources", DataMap.Sources.class);
    }

    private boolean isTestingExpression() {
        return this.getTestingExpressionBinding().getBoolean();
    }

    private void setTestingExpression(boolean testingExpression) {
        this.getTestingExpressionBinding().setBoolean(testingExpression);
    }

    private boolean isExpressionTestable(String expression, IValidationDelegate delegate) {
        ExpressionManager expressionManager = ExpressionManager.getInstance();
        if (!expressionManager.isEvaluateExpressionsOn()) {
            ExpressionTest.recordValidationError(delegate, "Error during expression evaluation: User not authorized to test this expression.");
            return false;
        }
        if (StringUtils.isEmpty((String)expression)) {
            ExpressionTest.recordValidationError(delegate, "Expression evaluation skipped: Empty String");
            return false;
        }
        return true;
    }

    private static void recordValidationError(IValidationDelegate delegate, String message) {
        log.debug((Object)message);
        if (delegate != null) {
            delegate.record(message, ValidationConstraint.REQUIRED);
            delegate.setFormComponent(null);
        }
    }

    private boolean wasTestSuccessful() {
        IValidationDelegate delegate = this.getDelegate();
        this.getState().setTestResults(null);
        if (!this.isExpressionTestable(this.getState().getExpressionToTest(), delegate)) {
            return false;
        }
        ArrayList<CallSite> logSubstitution = new ArrayList<CallSite>();
        try {
            String invalidSubstitution;
            Set<String> deprecatedExtClientMetadata;
            Object parsedExpression = Ognl.parseExpression((String)this.getState().getExpressionToTest());
            OgnlHelper ognlHelper = new OgnlHelper();
            ognlHelper.searchForAllVariableNames(parsedExpression);
            DataMap.Sources sources = this.getSources();
            Map<String, Object> sourceMap = sources.getSourceMap();
            Map<String, String> substitutionValues = sources.getValidSubstituterValues();
            if (sourceMap.containsKey("Extended Properties") && (deprecatedExtClientMetadata = sources.getDeprecatedExtClientMetadataPrefix()) != null && !deprecatedExtClientMetadata.isEmpty()) {
                for (String value : deprecatedExtClientMetadata) {
                    substitutionValues.put(value, value);
                }
            }
            if ((invalidSubstitution = ognlHelper.containsInvalidSubstitutions(substitutionValues)) != null) {
                ExpressionTest.recordValidationError(delegate, ERROR_DURING_EXPRESSION_EVAL + this.getMessage("Invalid_column", invalidSubstitution));
                return false;
            }
            List untestableSubstitutions = ognlHelper.getUntestableSubstitutions();
            if (!untestableSubstitutions.isEmpty()) {
                ExpressionTest.recordValidationError(delegate, ERROR_DURING_EXPRESSION_EVAL + this.getMessage("Untestable_attributes", untestableSubstitutions));
                return false;
            }
            HashMap<String, AttributeValue> testDataMap = new HashMap<String, AttributeValue>();
            for (TestDataItem item : this.getState().getTestDataListWithDeprecatedAttributeModels()) {
                testDataMap.put(item.getFieldName(), new AttributeValue(item.getTestValue()));
                if (!StringUtils.isNotEmpty((String)item.getTestValue())) continue;
                logSubstitution.add((CallSite)((Object)(item.getFieldName() + " -> " + item.getTestValue())));
            }
            Object results = ognlHelper.processOgnlExpression(parsedExpression, testDataMap, testDataMap);
            this.getState().setTestResults(results);
        }
        catch (OgnlException e) {
            ExpressionTest.recordValidationError(delegate, ERROR_DURING_EXPRESSION_EVAL + ExceptionUtil.toStringWithCauses((Throwable)e));
            return false;
        }
        Object logMessage = this.getState().getExpressionToTest();
        if (!logSubstitution.isEmpty()) {
            logMessage = (String)logMessage + " Expression variables: " + logSubstitution.stream().collect(Collectors.joining(","));
        }
        AdminAuditLogger.log((AdminAuditLogger.Component)AdminAuditLogger.Component.COMPONENT, (AdminAuditLogger.Event)AdminAuditLogger.Event.TEST_EXPRESSION, (String)logMessage);
        return true;
    }

    private static class State
    implements Serializable {
        private List<TestDataItem> testDataList = new ArrayList<TestDataItem>();
        private transient Object testResults;
        private boolean pageLoaded = false;
        private String expressionToTest;

        private State() {
        }

        public List<TestDataItem> getTestDataList() {
            return this.testDataList;
        }

        public List<TestDataItem> getTestDataListWithDeprecatedAttributeModels() {
            ArrayList<TestDataItem> copy = new ArrayList<TestDataItem>();
            for (TestDataItem origTDI : this.testDataList) {
                if (origTDI.getFieldName().startsWith("extproperties.")) {
                    copy.add(new TestDataItem(origTDI.getFieldName().replaceFirst("extproperties.", "extclientmetadata."), origTDI.getTestValue()));
                }
                copy.add(new TestDataItem(origTDI.getFieldName(), origTDI.getTestValue()));
            }
            return copy;
        }

        public void setTestDataList(List<TestDataItem> testDataList) {
            this.testDataList = testDataList;
        }

        public Object getTestResults() {
            return this.testResults;
        }

        public void setTestResults(Object testResults) {
            this.testResults = testResults;
        }

        public boolean isPageLoaded() {
            return this.pageLoaded;
        }

        public void setPageLoaded(boolean pageLoaded) {
            this.pageLoaded = pageLoaded;
        }

        public String getExpressionToTest() {
            return this.expressionToTest;
        }

        public void setExpressionToTest(String expressionToTest) {
            this.expressionToTest = expressionToTest;
        }
    }
}

