/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.component.common;

import com.pingidentity.component.common.SimpleFieldDescriptor;
import com.pingidentity.fsm.tasklet.data.CheckboxModel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.tapestry.form.IPropertySelectionModel;

public class FieldItem
implements Serializable {
    private static final long serialVersionUID = 1L;
    private SimpleFieldDescriptor descriptor;
    private String value;
    private boolean enabled = true;
    private String displayName;
    private String typeAndId;
    private CheckboxModel checkboxModel;

    public FieldItem(FieldItem item) {
        this(item.getDescriptor(), item.getValue(), (CheckboxModel)SerializationUtils.clone((Serializable)item.getCheckboxModel()));
    }

    public FieldItem(SimpleFieldDescriptor descriptor, String value) {
        this.descriptor = descriptor;
        this.value = value;
        this.enabled = descriptor.isEnabled();
    }

    public FieldItem(SimpleFieldDescriptor descriptor, String value, CheckboxModel checkboxModel) {
        this(descriptor, value);
        this.checkboxModel = checkboxModel;
    }

    public FieldItem(SimpleFieldDescriptor descriptor, CheckboxModel checkboxModel) {
        this.descriptor = descriptor;
        this.enabled = descriptor.isEnabled();
        this.checkboxModel = checkboxModel;
    }

    public SimpleFieldDescriptor getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(SimpleFieldDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public IPropertySelectionModel getValues() {
        return this.descriptor.getModelValues();
    }

    public boolean isCheckbox() {
        return this.descriptor.getType() == SimpleFieldDescriptor.FieldType.CHECKBOX;
    }

    public boolean isText() {
        return this.descriptor.getType() == SimpleFieldDescriptor.FieldType.TEXT;
    }

    public boolean isDropdown() {
        return this.descriptor.getType() == SimpleFieldDescriptor.FieldType.DROPDOWN;
    }

    public boolean isSelectionFilterList() {
        return this.descriptor.getType() == SimpleFieldDescriptor.FieldType.SELECTION_FILTER_LIST;
    }

    public boolean isTextarea() {
        return this.descriptor.getType() == SimpleFieldDescriptor.FieldType.TEXTAREA;
    }

    public boolean isCheckboxList() {
        return this.descriptor.getType() == SimpleFieldDescriptor.FieldType.CHECKBOX_LIST;
    }

    public boolean isCheckboxSelected() {
        return "true".equals(this.value);
    }

    public void setCheckboxSelected(boolean selected) {
        this.value = Boolean.toString(selected);
    }

    public String getItemWidth() {
        return this.makeWidthStyleValue(this.descriptor.getWidth());
    }

    public boolean isHidden() {
        return this.descriptor.isHidden();
    }

    private String makeWidthStyleValue(int baseWidth) {
        return "width:" + (baseWidth - 10) + "px;";
    }

    public boolean isHasListener() {
        return this.descriptor.isHasListener();
    }

    public String getLabel() {
        if (this.descriptor.getModelValues() != null) {
            for (int i = 0; i < this.descriptor.getModelValues().getOptionCount(); ++i) {
                Object option = this.descriptor.getModelValues().getOption(i);
                if (option == null || !this.value.equals(option.toString())) continue;
                return this.descriptor.getModelValues().getLabel(i);
            }
        }
        return this.descriptor.getMissingLabelText();
    }

    public List<String> getCheckboxLabels() {
        ArrayList<String> label = new ArrayList<String>();
        if (this.checkboxModel != null) {
            label.addAll(this.checkboxModel.getSelectedNames());
        }
        return label;
    }

    public String isEnabled() {
        return this.enabled ? "" : "disabled";
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getTypeAndId() {
        return this.typeAndId;
    }

    public void setTypeAndId(String typeAndId) {
        this.typeAndId = typeAndId;
    }

    public String getPlaceholderText() {
        return this.descriptor.getPlaceholderText();
    }

    public CheckboxModel getCheckboxModel() {
        return this.checkboxModel;
    }

    public void setCheckboxModel(CheckboxModel checkboxModel) {
        this.checkboxModel = checkboxModel;
    }
}

