/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.component.common;

import com.pingidentity.fsm.tasklet.TaskletCard;
import com.pingidentity.util.StringPairPropertySelectionModel;
import com.pingidentity.validator.PFValidationDelegate;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import ognl.Ognl;
import ognl.OgnlException;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.IBinding;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.domain.MessageCustomization;
import org.sourceid.saml20.domain.mgmt.impl.AdministrativeUser;

public abstract class MessageCustomizationCard
extends TaskletCard {
    public abstract IBinding getDelegateBinding();

    public abstract IBinding getMsgHooksBinding();

    public abstract IBinding getIsEditingHookBinding();

    public abstract IBinding getName2ContextMapBinding();

    public abstract IBinding getHookTypesBinding();

    public abstract IBinding getSelectedHookTypeBinding();

    public abstract IBinding getSelectedHookExpressionBinding();

    public abstract IBinding getLinkSubmitContextNameBinding();

    public static Map<String, String> getVarNameToContextMap(boolean wsFed, boolean idpConn) {
        HashMap<String, String> name2ContextMap = new HashMap<String, String>();
        if (wsFed) {
            if (!idpConn) {
                name2ContextMap.put("AssertionType", "assertion");
                name2ContextMap.put("ResponseDocument", "authn-response");
            }
        } else if (idpConn) {
            name2ContextMap.put("AuthnRequestDocument", "authn-request");
        } else {
            name2ContextMap.put("AssertionType", "assertion");
            name2ContextMap.put("ResponseDocument", "authn-response");
        }
        return name2ContextMap;
    }

    public static void populateMsgHooks(ConnectionBase conn, Map<String, String> varName2ContextMap, Map<String, MessageHookEntry> messageHooks) {
        Map domainMsgHooks = conn.getMessageCustomizationHooks();
        MessageCustomizationCard.populateMessageHooks(varName2ContextMap, messageHooks, domainMsgHooks);
    }

    public static void populateMessageHooks(Map<String, String> varName2ContextMap, Map<String, MessageHookEntry> messageHooks, Map<String, MessageCustomization> domainMsgHooks) {
        for (Map.Entry<String, String> name2Context : varName2ContextMap.entrySet()) {
            String varName = name2Context.getKey();
            String contextName = name2Context.getValue();
            MessageCustomization msgHook = domainMsgHooks.get(contextName);
            if (msgHook == null) continue;
            messageHooks.put(varName, new MessageHookEntry(varName, msgHook.getExpression()));
        }
    }

    public static void saveMsgHooks(ConnectionBase conn, Map<String, String> varName2ContextMap, Map<String, MessageHookEntry> messageHooks) {
        Map domainMsgHooks = conn.getMessageCustomizationHooks();
        MessageCustomizationCard.saveMessageHooks(varName2ContextMap, messageHooks, domainMsgHooks);
    }

    public static void saveWsTrustMsgHooks(ConnectionBase conn, Map<String, String> varName2ContextMap, Map<String, MessageHookEntry> messageHooks) {
        Map domainMsgHooks = conn.getWsTrustMessageCustomizationHooks();
        MessageCustomizationCard.saveMessageHooks(varName2ContextMap, messageHooks, domainMsgHooks);
    }

    private static void saveMessageHooks(Map<String, String> varName2ContextMap, Map<String, MessageHookEntry> messageHooks, Map<String, MessageCustomization> domainMsgHooks) {
        for (MessageHookEntry msgHookEntry : messageHooks.values()) {
            if (msgHookEntry.isDeleted()) continue;
            MessageCustomization domainMsgHook = new MessageCustomization();
            domainMsgHook.setExpression(msgHookEntry.getExpression());
            domainMsgHooks.put(varName2ContextMap.get(msgHookEntry.getName()), domainMsgHook);
        }
    }

    public static void updateAvailableHookTypes(StringPairPropertySelectionModel hookTypes, Map<String, String> name2Context, Collection<MessageHookEntry> msgHooks) {
        hookTypes.clear();
        hookTypes.add("- SELECT -", null);
        HashSet<String> varNames = new HashSet<String>();
        varNames.addAll(name2Context.keySet());
        for (MessageHookEntry msgHookEntry : msgHooks) {
            if (msgHookEntry.isDeleted()) continue;
            varNames.remove(msgHookEntry.getName());
        }
        for (String availHookType : varNames) {
            hookTypes.add(availHookType, availHookType);
        }
        hookTypes.sort();
    }

    private Map<String, String> getName2ContextMap() {
        return (Map)this.getName2ContextMapBinding().getObject("name2ContextMap", Map.class);
    }

    private LinkedHashMap<String, MessageHookEntry> getMessageHookMap() {
        LinkedHashMap msgMap = (LinkedHashMap)this.getMsgHooksBinding().getObject("msgHooks", LinkedHashMap.class);
        return msgMap;
    }

    public PFValidationDelegate getDelegate() {
        return (PFValidationDelegate)((Object)this.getDelegateBinding().getObject("delegate", PFValidationDelegate.class));
    }

    public Collection<MessageHookEntry> getMessageHooks() {
        return this.getMessageHookMap().values();
    }

    public StringPairPropertySelectionModel getHookTypeModel() {
        return (StringPairPropertySelectionModel)this.getHookTypesBinding().getObject("hookTypes", StringPairPropertySelectionModel.class);
    }

    public String getSelectedHookType() {
        return this.getSelectedHookTypeBinding().getString();
    }

    public void setSelectedHookType(String selectedHookType) {
        this.getSelectedHookTypeBinding().setString(selectedHookType);
    }

    public String getSelectedHookExpression() {
        return this.getSelectedHookExpressionBinding().getString();
    }

    public void setSelectedHookExpression(String selectedHookExpression) {
        this.getSelectedHookExpressionBinding().setString(selectedHookExpression);
    }

    public String getLinkSubmitContextName() {
        return this.getLinkSubmitContextNameBinding().getString();
    }

    public void setLinkSubmitContextName(String linkSubmitContextName) {
        this.getLinkSubmitContextNameBinding().setString(linkSubmitContextName);
    }

    @Override
    public void appendErrors(IValidationDelegate delegate) {
        if (this.isEditingHook()) {
            delegate.setFormComponent(null);
            delegate.record(this.getMessage("Update_required"), ValidationConstraint.REQUIRED);
        }
    }

    public boolean isEditingHook() {
        return this.getIsEditingHookBinding().getBoolean();
    }

    public void setEditingHook(boolean edit) {
        this.getIsEditingHookBinding().setBoolean(edit);
    }

    public void editMessageHook(IRequestCycle cycle) {
        Object[] params = cycle.getServiceParameters();
        String contextName = (String)params[0];
        MessageHookEntry msgHook = this.getMessageHookMap().get(contextName);
        msgHook.setEditing(true);
        this.setEditingHook(true);
    }

    public void cancelMessageHookEdit(IRequestCycle cycle) {
        Object[] params = cycle.getServiceParameters();
        String contextName = (String)params[0];
        MessageHookEntry msgHook = this.getMessageHookMap().get(contextName);
        msgHook.revertExpression();
        msgHook.setEditing(false);
        this.setEditingHook(false);
    }

    public void deleteMessageHook(IRequestCycle cycle) {
        if (this.isCurrentUserAdmin()) {
            Object[] params = cycle.getServiceParameters();
            String contextName = (String)params[0];
            MessageHookEntry msgHook = this.getMessageHookMap().get(contextName);
            msgHook.setDeleted(true);
            MessageCustomizationCard.updateAvailableHookTypes(this.getHookTypeModel(), this.getName2ContextMap(), this.getMessageHooks());
        } else {
            this.auditLogUnauthorizedUserDeleteAction("message customization");
        }
    }

    public void undeleteMessageHook(IRequestCycle cycle) {
        if (this.isCurrentUserAdmin()) {
            Object[] params = cycle.getServiceParameters();
            String contextName = (String)params[0];
            MessageHookEntry msgHook = this.getMessageHookMap().get(contextName);
            msgHook.setDeleted(false);
            MessageCustomizationCard.updateAvailableHookTypes(this.getHookTypeModel(), this.getName2ContextMap(), this.getMessageHooks());
        } else {
            this.auditLogUnauthorizedUserUndeleteAction("message customization");
        }
    }

    public void updateMessageHook(IRequestCycle cycle) {
        MessageHookEntry msgHook = this.getMessageHookMap().get(this.getLinkSubmitContextName());
        PFValidationDelegate delegate = this.getDelegate();
        this.validateExpression((IValidationDelegate)delegate, msgHook.getExpression());
        if (delegate.getHasErrors()) {
            return;
        }
        msgHook.setEditing(false);
        msgHook.setOriginalExpression(msgHook.getExpression());
        this.setEditingHook(false);
    }

    public void setLinkSubmitParameters(IRequestCycle cycle) {
        Object[] params = cycle.getServiceParameters();
        this.setLinkSubmitContextName((String)params[0]);
    }

    public void addMessageHook(IRequestCycle cycle) {
        PFValidationDelegate delegate = this.getDelegate();
        if (StringUtils.isEmpty((String)this.getSelectedHookType())) {
            delegate.setFormComponent(null);
            delegate.record(this.getMessage("hook_type_required"), ValidationConstraint.REQUIRED);
        }
        this.validateExpression((IValidationDelegate)delegate, this.getSelectedHookExpression());
        if (delegate.getHasErrors()) {
            return;
        }
        MessageHookEntry hookToAdd = new MessageHookEntry(this.getSelectedHookType(), this.getSelectedHookExpression());
        this.getMessageHookMap().put(hookToAdd.getName(), hookToAdd);
        MessageCustomizationCard.updateAvailableHookTypes(this.getHookTypeModel(), this.getName2ContextMap(), this.getMessageHooks());
        this.setSelectedHookType(null);
        this.setSelectedHookExpression(null);
    }

    private void validateExpression(IValidationDelegate delegate, String expr) {
        if (StringUtils.isEmpty((String)expr)) {
            delegate.setFormComponent(null);
            delegate.record(this.getMessage("hook_expr_required"), ValidationConstraint.REQUIRED);
        } else {
            try {
                Ognl.parseExpression((String)expr);
            }
            catch (OgnlException e) {
                delegate.setFormComponent(null);
                delegate.record(this.getMessage("invalid_hook_expr"), ValidationConstraint.REQUIRED);
            }
        }
    }

    public boolean getEaAdmin() {
        AdministrativeUser currentUser = this.getCurrentUser();
        return currentUser == null || currentUser.isExpressionAdmin();
    }

    public static class MessageHookEntry
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private boolean isEditing;
        private boolean isDeleted;
        private String name;
        private String expression;
        private String originalExpression = null;

        public MessageHookEntry(String name, String expression) {
            this.name = name;
            this.expression = expression;
            this.originalExpression = expression;
        }

        public boolean isEditing() {
            return this.isEditing;
        }

        public void setEditing(boolean isEditing) {
            this.isEditing = isEditing;
        }

        public boolean isDeleted() {
            return this.isDeleted;
        }

        public void setDeleted(boolean isDeleted) {
            this.isDeleted = isDeleted;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getExpression() {
            return this.expression;
        }

        public void setExpression(String expression) {
            this.expression = expression;
        }

        public String getOriginalExpression() {
            return this.originalExpression;
        }

        public void setOriginalExpression(String originalExpression) {
            this.originalExpression = originalExpression;
        }

        public void revertExpression() {
            this.expression = this.originalExpression;
        }
    }
}

