/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.component.common;

import com.pingidentity.fsm.tasklet.TaskletCard;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.IBinding;
import org.apache.tapestry.IRequestCycle;

public abstract class PasswordField
extends TaskletCard {
    protected static final String PASSWORD_BINDING = "password";
    protected static final String OBSCURED_PASSWORD = "**********";

    public abstract boolean getPasswordRequired();

    public abstract boolean getFieldDisabled();

    public abstract IBinding getPasswordBinding();

    public abstract IBinding getTextFieldSizeBinding();

    public abstract IBinding getTextFieldIdBinding();

    public abstract boolean getOverrideDisabled();

    public abstract boolean getHasExistingPassword();

    public abstract String getCssClasses();

    public String getSize() {
        return String.valueOf(this.getTextFieldSizeBinding().getInt());
    }

    public String getFieldId() {
        return this.getTextFieldIdBinding().getString();
    }

    public String getPasswordField() {
        String password = (String)this.getPasswordBinding().getObject(PASSWORD_BINDING, String.class);
        if (!StringUtils.isBlank((String)password)) {
            int passwordLength = password.length();
            if (passwordLength >= 64) {
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < passwordLength; ++i) {
                    sb.append("*");
                }
                return sb.toString();
            }
            return OBSCURED_PASSWORD;
        }
        if (this.getHasExistingPassword()) {
            return OBSCURED_PASSWORD;
        }
        return password;
    }

    public void setPasswordField(String passwordField) {
        if (!this.isOnlyStars(passwordField)) {
            this.getPasswordBinding().setObject((Object)passwordField);
        }
    }

    protected void prepareForRender(IRequestCycle cycle) {
        super.prepareForRender(cycle);
        boolean isRewinding = cycle.isRewinding();
        if (!isRewinding && this.getOverrideDisabled()) {
            this.getPasswordBinding().setObject((Object)"");
        }
    }

    public boolean getDisabled() {
        return this.getOverrideDisabled() || this.getFieldDisabled();
    }

    public boolean getShowAsterisk() {
        return this.getPasswordRequired();
    }

    protected boolean isOnlyStars(String password) {
        if (StringUtils.isBlank((String)password)) {
            return false;
        }
        char[] chars = password.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if ("*".equals(String.valueOf(chars[i]))) continue;
            return false;
        }
        return true;
    }
}

