/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.component.common;

import com.pingidentity.fsm.state.impl.CreatePolicyContractState;
import com.pingidentity.fsm.tasklet.TaskletCard;
import com.pingidentity.fsm.tasklet.impl.AssertionCreationTasklet;
import com.pingidentity.fsm.tasklet.impl.UserSessionCreationTasklet;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.IBinding;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.apache.tapestry.valid.ValidationDelegate;
import org.sourceid.openid.connect.OpenIdParamNames;
import org.sourceid.saml20.domain.AttributeContract;

public abstract class PolicyAttributeContractEditor
extends TaskletCard
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String VALUES_IN_EXTENDED_LABEL = "Values";

    public boolean isEditMode() {
        return this.getState().editItem != null;
    }

    public String getContractItem() {
        return this.getState().contractItem;
    }

    public boolean isContractItemEditing() {
        State curState = this.getState();
        return curState.contractItem.equals(curState.editItem);
    }

    public boolean isOpenIdClaim(String item) {
        return OpenIdParamNames.OPENID_IDTOKEN_STANDARD_CLAIMS.contains(item);
    }

    public void setContractItem(String contractItem) {
        State s = this.getState();
        s.contractItem = StringUtils.stripToNull((String)contractItem);
        this.saveState(s);
    }

    public String getAttributeNameFormatFromContract(String attributeName) {
        return this.getContract().getMutableAttributeNameFormat(attributeName);
    }

    public boolean isIncludeInIdToken() {
        String item = this.getState().contractItem;
        return this.getIdTokenList().contains(item) || !this.getUserInfoList().contains(item) && this.isOpenIdClaim(item);
    }

    public boolean isIncludeInUserInfo() {
        String item = this.getState().contractItem;
        return this.getUserInfoList().contains(item) || !this.getIdTokenList().contains(item) && !this.getUserInfoList().contains(item) && !this.isOpenIdClaim(item);
    }

    public boolean isContractItemMultiValued() {
        State curState = this.getState();
        return this.getMultiValuedList().contains(curState.contractItem);
    }

    public boolean getOverride() {
        return this.getState().override;
    }

    public void setOverride(boolean override) {
        State s = this.getState();
        s.override = override;
        if (!s.override) {
            CreatePolicyContractState currentState = (CreatePolicyContractState)this.getCurrentState();
            HashSet<String> newIdTokenList = new HashSet<String>(this.getIdTokenList());
            HashSet<String> newUserInfoList = new HashSet<String>(this.getUserInfoList());
            newIdTokenList.remove(s.updateItem);
            newUserInfoList.remove(s.updateItem);
            currentState.setIdTokenList(newIdTokenList);
            currentState.setUserInfoList(newUserInfoList);
            s.updateIncludeInIdToken = false;
            s.updateIncludeInUserInfo = false;
        }
        this.saveState(s);
    }

    public boolean getIncludeIdTokenOrUserInfo(String item) {
        return this.getIdTokenList().contains(item) || this.getUserInfoList().contains(item);
    }

    public Iterator<String> getMutableItems() {
        return this.getContract().getSortedMutableAttributeNames().iterator();
    }

    public Iterator<String> getImmutableItems() {
        return this.getContract().getSortedImmutableAttributeNames().iterator();
    }

    public abstract IBinding getContractBinding();

    public abstract IBinding getOriginalContractBinding();

    public abstract IBinding getStateBinding();

    public abstract IBinding getDelegateBinding();

    public abstract boolean getAllowEmpty();

    public abstract boolean getShowExtensionLine();

    public abstract boolean getShowIdCustomization();

    public abstract String getColumnHeading();

    public abstract IBinding getIdTokenListBinding();

    public abstract IBinding getUserInfoListBinding();

    public abstract IBinding getMultiValuedListBinding();

    public abstract IBinding getExtendedContractLabelBinding();

    public abstract IBinding getAllowedAttributesBinding();

    public abstract IBinding getIsInheritingContractBinding();

    public abstract boolean getHasParentInstance();

    public String getExtendedContractLabel() {
        String label = null;
        IBinding binding = this.getExtendedContractLabelBinding();
        if (binding != null) {
            label = (String)binding.getObject("extendedContractLabel", String.class);
        }
        return label;
    }

    public List<String> getAllowedAttributesList() {
        List<String> allowedAttributes = new ArrayList<String>();
        IBinding binding = this.getAllowedAttributesBinding();
        if (binding != null) {
            allowedAttributes = (List)binding.getObject("allowedAttributes", List.class);
        }
        return allowedAttributes;
    }

    public AttributeContract getContract() {
        if (this.isInheritingContract()) {
            return this.getOriginalContract();
        }
        return (AttributeContract)this.getContractBinding().getObject("contract", AttributeContract.class);
    }

    public AttributeContract getOriginalContract() {
        return (AttributeContract)this.getOriginalContractBinding().getObject("originalContract", AttributeContract.class);
    }

    public ValidationDelegate getDelegate() {
        return (ValidationDelegate)this.getDelegateBinding().getObject("delegate", ValidationDelegate.class);
    }

    public Set<String> getIdTokenList() {
        return (Set)this.getIdTokenListBinding().getObject("idTokenList", Set.class);
    }

    public Set<String> getUserInfoList() {
        return (Set)this.getUserInfoListBinding().getObject("userInfoList", Set.class);
    }

    public Set<String> getMultiValuedList() {
        return (Set)this.getMultiValuedListBinding().getObject("multiValuedList", Set.class);
    }

    public void setExtendedContractLabel(String label) {
        this.getExtendedContractLabelBinding().setString(label);
    }

    public boolean isInheritingContract() {
        return this.getIsInheritingContractBinding().getBoolean();
    }

    public void setInheritingContract(boolean isInheritingContract) {
        this.getIsInheritingContractBinding().setBoolean(isInheritingContract);
    }

    public boolean isOverridingContract() {
        return !this.isInheritingContract();
    }

    public void setOverridingContract(boolean isOverridingContract) {
        this.setInheritingContract(!isOverridingContract);
        if (!isOverridingContract) {
            this.cancelEdit();
        }
    }

    private void saveState(State curState) {
        this.getStateBinding().setObject((Object)curState);
    }

    private State getState() {
        State state = (State)this.getStateBinding().getObject("state", Object.class);
        if (state == null) {
            state = new State();
        }
        return state;
    }

    public String getNewItem() {
        return this.getState().newItem;
    }

    public void setNewItem(String newItem) {
        State s = this.getState();
        s.newItem = StringUtils.stripToNull((String)newItem);
        this.saveState(s);
    }

    public String getEditItem() {
        return this.getState().editItem;
    }

    public void setEditItem(String item) {
        State s = this.getState();
        s.editItem = StringUtils.stripToNull((String)item);
        this.saveState(s);
    }

    public String getUpdateItem() {
        return this.getState().updateItem;
    }

    public void setUpdateItem(String updateItem) {
        State s = this.getState();
        s.updateItem = StringUtils.stripToNull((String)updateItem);
        this.saveState(s);
    }

    public boolean getUpdateIncludeInIdToken() {
        return this.getState().updateIncludeInIdToken || !this.getState().override && this.isOpenIdClaim(this.getState().updateItem);
    }

    public void setUpdateIncludeInIdToken(boolean includeInIdToken) {
        State s = this.getState();
        s.updateIncludeInIdToken = includeInIdToken;
        this.saveState(s);
    }

    public boolean getUpdateIncludeUserInfo() {
        return this.getState().updateIncludeInUserInfo || !this.getState().override && !this.isOpenIdClaim(this.getState().updateItem);
    }

    public void setUpdateIncludeUserInfo(boolean includeUserInfo) {
        State s = this.getState();
        s.updateIncludeInUserInfo = includeUserInfo;
        this.saveState(s);
    }

    public boolean getUpdateMultiValued() {
        return this.getState().updateMultiValued;
    }

    public void setUpdateMultiValued(boolean multiValued) {
        State s = this.getState();
        s.updateMultiValued = multiValued;
        this.saveState(s);
    }

    public boolean getNewOverride() {
        return this.getState().newOverride;
    }

    public void setNewOverride(boolean override) {
        State s = this.getState();
        s.newOverride = override;
        if (!s.newOverride) {
            s.newIncludeInIdToken = false;
        }
        this.saveState(s);
        this.saveState(s);
    }

    public boolean getNewIncludeInIdToken() {
        return this.getState().newIncludeInIdToken;
    }

    public void setNewIncludeInIdToken(boolean includeInIdToken) {
        State s = this.getState();
        s.newIncludeInIdToken = includeInIdToken;
        this.saveState(s);
    }

    public boolean getNewIncludeInUserInfo() {
        return this.getState().newIncludeInUserInfo;
    }

    public void setNewIncludeInUserInfo(boolean includeInUserInfo) {
        State s = this.getState();
        s.newIncludeInUserInfo = includeInUserInfo;
        this.saveState(s);
    }

    public boolean getNewMultiValued() {
        return this.getState().newMultiValued;
    }

    public void setNewMultiValued(boolean newMultiValued) {
        State s = this.getState();
        s.newMultiValued = newMultiValued;
        this.saveState(s);
    }

    public void onAddItem(IRequestCycle cycle) {
        AttributeContract contract = this.getContract();
        boolean hasErrors = false;
        if (StringUtils.isBlank((String)this.getState().newItem)) {
            this.getDelegate().setFormComponent(null);
            this.getDelegate().record(this.getMessage("Name_required"), ValidationConstraint.REQUIRED);
            hasErrors = true;
        }
        if (contract.attributeExists(this.getState().newItem)) {
            this.getDelegate().setFormComponent(null);
            this.getDelegate().record(this.getMessage("Already_contains") + " " + this.getState().newItem, ValidationConstraint.REQUIRED);
            hasErrors = true;
        }
        if (!this.getAllowedAttributesList().isEmpty() && !this.getAllowedAttributesList().contains(this.getState().newItem)) {
            this.getDelegate().setFormComponent(null);
            this.getDelegate().record(String.format("Unsupported Attribute: %s", this.getState().newItem), ValidationConstraint.REQUIRED);
            hasErrors = true;
        }
        if (this.validateAtleastOneSelected(this.getState().newOverride, this.getState().newIncludeInIdToken, this.getState().newIncludeInUserInfo)) {
            hasErrors = true;
        }
        if (this.validateMustIncludeInIdToken(this.getState().newOverride, this.getState().newItem, this.getState().newIncludeInIdToken)) {
            hasErrors = true;
        }
        if (!hasErrors) {
            State s = this.getState();
            contract.addMutableAttributeInfo(this.getState().newItem, null);
            if (s.newOverride) {
                if (s.newIncludeInIdToken) {
                    this.getIdTokenList().add(s.newItem);
                } else {
                    this.getIdTokenList().remove(s.newItem);
                }
                if (s.newIncludeInUserInfo) {
                    this.getUserInfoList().add(s.newItem);
                } else {
                    this.getUserInfoList().remove(s.newItem);
                }
            }
            if (s.newMultiValued) {
                this.getMultiValuedList().add(s.newItem);
            } else {
                this.getMultiValuedList().remove(s.newItem);
            }
            s.newItem = null;
            s.newIncludeInIdToken = false;
            s.newIncludeInUserInfo = false;
            s.newMultiValued = false;
            s.newOverride = false;
            this.saveState(s);
        }
    }

    private boolean validateMustIncludeInIdToken(boolean isOverride, String item, boolean includeInIdToken) {
        boolean hasErrors = false;
        if (isOverride && this.isOpenIdClaim(item) && !includeInIdToken) {
            this.getDelegate().setFormComponent(null);
            this.getDelegate().record(this.getMessage("must_include_id_token"), ValidationConstraint.REQUIRED);
            hasErrors = true;
        }
        return hasErrors;
    }

    private boolean validateAtleastOneSelected(boolean override, boolean includeInIdToken, boolean includeInUserInfo) {
        boolean hasErrors = false;
        if (override && !includeInIdToken && !includeInUserInfo) {
            this.getDelegate().setFormComponent(null);
            this.getDelegate().record("Attribute must be included in at least one of 'ID token' and 'User Info'.", ValidationConstraint.REQUIRED);
            hasErrors = true;
        }
        return hasErrors;
    }

    public void onEditItem(IRequestCycle cycle) {
        Object[] params = cycle.getServiceParameters();
        State curState = this.getState();
        curState.updateItem = curState.editItem = (String)params[0];
        curState.updateIncludeInIdToken = this.getIdTokenList().contains(curState.updateItem);
        curState.updateIncludeInUserInfo = this.getUserInfoList().contains(curState.updateItem);
        curState.updateMultiValued = this.getMultiValuedList().contains(curState.updateItem);
        curState.override = curState.updateIncludeInIdToken || curState.updateIncludeInUserInfo;
        this.saveState(curState);
    }

    public void onUpdateItem(IRequestCycle cycle) {
        AttributeContract contract = this.getContract();
        boolean hasErrors = false;
        State curState = this.getState();
        if (StringUtils.isBlank((String)curState.updateItem)) {
            this.getDelegate().setFormComponent(null);
            this.getDelegate().record(this.getMessage("Name_required"), ValidationConstraint.REQUIRED);
            hasErrors = true;
        } else if (!curState.updateItem.equals(curState.editItem)) {
            if (contract.attributeExists(curState.updateItem)) {
                this.getDelegate().setFormComponent(null);
                this.getDelegate().record(this.getMessage("Already_contains") + " " + this.getState().updateItem, ValidationConstraint.REQUIRED);
                hasErrors = true;
            }
            if (!this.getAllowedAttributesList().isEmpty() && !this.getAllowedAttributesList().contains(this.getState().updateItem)) {
                this.getDelegate().setFormComponent(null);
                this.getDelegate().record(String.format("Unsupported Attribute: %s", this.getState().updateItem), ValidationConstraint.REQUIRED);
                hasErrors = true;
            }
            if (!hasErrors) {
                contract.removeMutableAttributeName(curState.editItem);
                contract.addMutableAttributeInfo(curState.updateItem, null);
            }
        }
        if (this.validateAtleastOneSelected(curState.override, curState.updateIncludeInIdToken, curState.updateIncludeInUserInfo)) {
            hasErrors = true;
        }
        if (this.validateMustIncludeInIdToken(curState.override, curState.updateItem, curState.updateIncludeInIdToken)) {
            hasErrors = true;
        }
        CreatePolicyContractState currentState = (CreatePolicyContractState)this.getCurrentState();
        HashSet<String> newIdTokenList = new HashSet<String>(this.getIdTokenList());
        HashSet<String> newUserInfoList = new HashSet<String>(this.getUserInfoList());
        HashSet<String> newMultiValuedList = new HashSet<String>(this.getMultiValuedList());
        if (!hasErrors) {
            if (curState.override) {
                if (curState.updateIncludeInIdToken) {
                    newIdTokenList.add(curState.updateItem);
                } else {
                    newIdTokenList.remove(curState.updateItem);
                }
                if (curState.updateIncludeInUserInfo) {
                    newUserInfoList.add(curState.updateItem);
                } else {
                    newUserInfoList.remove(curState.updateItem);
                }
            } else {
                newUserInfoList.remove(curState.updateItem);
                newIdTokenList.remove(curState.updateItem);
            }
            if (curState.updateMultiValued) {
                newMultiValuedList.add(curState.updateItem);
            } else {
                newMultiValuedList.remove(curState.updateItem);
            }
            currentState.setIdTokenList(newIdTokenList);
            currentState.setUserInfoList(newUserInfoList);
            currentState.setMultiValuedList(newMultiValuedList);
        }
        if (!hasErrors) {
            this.cancelEdit();
        }
        this.saveState(curState);
    }

    public void onDeleteItem(IRequestCycle cycle) {
        if (this.isCurrentUserAdmin()) {
            Object[] params = cycle.getServiceParameters();
            String deleteItem = (String)params[0];
            this.getContract().removeMutableAttributeName(deleteItem);
        } else {
            this.auditLogUnauthorizedUserDeleteAction("attribute contract editor");
        }
    }

    public void cancelEdit(IRequestCycle cycle) {
        this.cancelEdit();
    }

    private void cancelEdit() {
        State curState = this.getState();
        curState.updateItem = null;
        curState.editItem = null;
        curState.override = false;
        curState.updateIncludeInIdToken = false;
        curState.updateIncludeInUserInfo = false;
        this.saveState(curState);
    }

    @Override
    public void appendErrors(IValidationDelegate delegate) {
        if (this.isEditMode()) {
            delegate.setFormComponent(null);
            delegate.record(this.getMessage("Update_required"), ValidationConstraint.REQUIRED);
        }
        if (!this.getAllowEmpty() && (this.getContract().isEmpty() || !this.isAllowEmptyMutableAttributes() && this.getContract().getMutableAttributeNames().isEmpty())) {
            delegate.setFormComponent(null);
            String extendedLabel = this.getExtendedContractLabel();
            String messageId = extendedLabel != null && extendedLabel.contains(VALUES_IN_EXTENDED_LABEL) ? "One_value_required" : "One_attribute_required";
            delegate.record(this.getMessage(messageId), ValidationConstraint.REQUIRED);
        }
    }

    private boolean isAllowEmptyMutableAttributes() {
        if (this.getTasklet() instanceof AssertionCreationTasklet) {
            return !((AssertionCreationTasklet)this.getTasklet()).isAdditionalAttributesRequired();
        }
        if (this.getTasklet() instanceof UserSessionCreationTasklet) {
            return !((UserSessionCreationTasklet)this.getTasklet()).isAdditionalAttributesRequired();
        }
        return true;
    }

    private static class State
    implements Serializable {
        private static final long serialVersionUID = 20050515L;
        String updateItem;
        boolean override;
        boolean updateIncludeInIdToken;
        boolean updateIncludeInUserInfo;
        boolean updateMultiValued;
        String editItem;
        String contractItem;
        String newItem;
        boolean newOverride;
        boolean newIncludeInIdToken;
        boolean newIncludeInUserInfo;
        boolean newMultiValued;

        private State() {
        }
    }
}

