/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.component.common;

import com.pingidentity.component.common.NameValuePair;
import com.pingidentity.component.common.StringPairListEditor;
import com.pingidentity.fsm.tasklet.data.CheckboxItem;
import com.pingidentity.fsm.tasklet.data.CheckboxModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.tapestry.IBinding;
import org.apache.tapestry.IRequestCycle;

public abstract class ScopeGroupListEditor
extends StringPairListEditor {
    private static final long serialVersionUID = 1L;
    private int count;
    private String currentSubScope;

    public abstract IBinding getScopeGroupModelBinding();

    public abstract IBinding getScopeModelBinding();

    public Map<String, CheckboxModel> getScopeGroupModel() {
        return (Map)this.getScopeGroupModelBinding().getObject("scopeGroupModel", Map.class);
    }

    public void setScopeGroupModel(Map<String, CheckboxModel> scopeGroupModel) {
        this.getScopeGroupModelBinding().setObject(scopeGroupModel);
    }

    public List<String> getScopeModel() {
        return (List)this.getScopeModelBinding().getObject("scopeModel", List.class);
    }

    public List<String> getScopeModelSorted() {
        List scopeModelSorted = (List)this.getScopeModelBinding().getObject("scopeModel", List.class);
        Collections.sort(scopeModelSorted);
        return scopeModelSorted;
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public String getCurrentSubScope() {
        return this.currentSubScope;
    }

    public void setCurrentSubScope(String currentSubScope) {
        this.currentSubScope = currentSubScope;
    }

    public CheckboxModel getUpdateGroupItems() {
        return this.getGroupState().updateGroupItems;
    }

    public CheckboxModel getNewGroupItems() {
        GroupState state = this.getGroupState();
        CheckboxModel result = this.newCheckboxModel();
        for (String subScope : state.newGroupItems.getSelectedNames()) {
            result.setChecked(subScope);
        }
        state.newGroupItems = result;
        return result;
    }

    @Override
    protected boolean validateAdd(NameValuePair itemToValidate, NameValuePair originalItem) {
        boolean hasErrors = super.validateAdd(itemToValidate, originalItem);
        if (!hasErrors && (hasErrors = this.getGroupState().newGroupItems.getSelectedNames().isEmpty())) {
            this.recErrorMsg("At least one sub scope must be selected.");
        }
        return hasErrors;
    }

    @Override
    protected boolean validateUpdate(NameValuePair itemToValidate, NameValuePair originalItem) {
        boolean hasErrors = super.validateUpdate(itemToValidate, originalItem);
        if (!hasErrors && (hasErrors = this.getScopeGroupModel().get(originalItem.getName()).getSelectedNames().isEmpty())) {
            this.recErrorMsg("At least one sub scope must be selected.");
            GroupState groupState = this.getGroupState();
            this.getScopeGroupModel().put(itemToValidate.getName(), new CheckboxModel(groupState.updateGroupItems));
            this.saveState(groupState);
        }
        return hasErrors;
    }

    @Override
    public void onUndeleteItem(IRequestCycle cycle) {
        if (this.isCurrentUserAdmin()) {
            NameValuePair currentItem = this.getState().currentItem;
            if (!this.validateUndelete(currentItem)) {
                currentItem.setMarkedForDelete(false);
            }
        } else {
            this.auditLogUnauthorizedUserUndeleteAction("string pair list editor");
        }
    }

    protected boolean validateUndelete(NameValuePair itemToValidate) {
        StringPairListEditor.StringPairListEditorListener listener;
        String msg;
        boolean hasError = false;
        Object o = this.getOwnerStateBinding().getObject();
        if (o instanceof StringPairListEditor.StringPairListEditorListener && (msg = (listener = (StringPairListEditor.StringPairListEditorListener)o).validate(itemToValidate.getName(), itemToValidate.getValue(), null, null, Collections.emptyList(), this)) != null) {
            this.recErrorMsg(msg);
            hasError = true;
        }
        return hasError;
    }

    @Override
    protected void doCancel() {
        GroupState state = this.getGroupState();
        this.getScopeGroupModel().put(state.updateItem.getName(), new CheckboxModel(state.updateGroupItems));
        state.updateGroupItems = null;
        super.doCancel();
    }

    @Override
    protected void doEdit(IRequestCycle cycle) {
        ArrayList<String> scopeNames = new ArrayList<String>(this.getScopeModelSorted());
        CheckboxModel cbm = this.getScopeGroupModel().get(this.getRequestCycleItem(cycle).getName());
        ArrayList<String> subScopeNames = new ArrayList<String>();
        for (CheckboxItem cbi : cbm.getCheckboxItems()) {
            subScopeNames.add(cbi.getName());
        }
        for (String scopeName : scopeNames) {
            if (subScopeNames.contains(scopeName)) continue;
            cbm.add(scopeName);
        }
        for (String subScopeName : subScopeNames) {
            if (scopeNames.contains(subScopeName)) continue;
            cbm.add(subScopeName);
        }
        cbm.sortAlphabetically();
        this.getGroupState().updateGroupItems = new CheckboxModel(cbm);
        super.doEdit(cycle);
    }

    @Override
    protected void doUpdate() {
        this.getGroupState().updateGroupItems = null;
        super.doUpdate();
    }

    @Override
    protected void doAdd() {
        GroupState state = this.getGroupState();
        this.getScopeGroupModel().put(state.newItem.getName(), new CheckboxModel(state.newGroupItems));
        state.newGroupItems = this.newCheckboxModel();
        super.doAdd();
    }

    @Override
    protected StringPairListEditor.State getState() {
        StringPairListEditor.State state = (StringPairListEditor.State)this.getStateBinding().getObject("state", Object.class);
        if (state == null) {
            state = new GroupState();
            this.saveState(state);
        }
        return state;
    }

    CheckboxModel newCheckboxModel() {
        CheckboxModel cbm = new CheckboxModel();
        for (String scopeValue : this.getScopeModelSorted()) {
            cbm.add(scopeValue);
        }
        return cbm;
    }

    private GroupState getGroupState() {
        return (GroupState)this.getState();
    }

    public class GroupState
    extends StringPairListEditor.State {
        private static final long serialVersionUID = 1L;
        CheckboxModel updateGroupItems;
        CheckboxModel newGroupItems;

        public GroupState() {
            super(ScopeGroupListEditor.this);
            this.newGroupItems = ScopeGroupListEditor.this.newCheckboxModel();
        }

        @Override
        public void clear() {
            super.clear();
            this.updateGroupItems = null;
        }
    }
}

