/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.component.common;

import com.pingidentity.component.common.TableEditor;
import com.pingidentity.component.common.TableRow;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.tapestry.IRequestCycle;

public abstract class ScopeTableEditor
extends TableEditor {
    @Override
    public void onUndeleteItem(IRequestCycle cycle) {
        if (this.isCurrentUserAdmin()) {
            TableRow currentItem = this.getCurrentItem();
            if (!this.validateDuplicates(currentItem)) {
                currentItem.setMarkedForDelete(false);
                Object o = this.getOwnerStateBinding().getObject();
                if (o instanceof TableEditor.TableEditorListener) {
                    TableEditor.TableEditorListener listener = (TableEditor.TableEditorListener)o;
                    listener.onUndeleteItem(this, currentItem);
                }
            }
        } else {
            this.auditLogUnauthorizedUserUndeleteAction("table editor");
        }
    }

    private boolean validateDuplicates(TableRow itemToValidate) {
        TableEditor.TableEditorListener listener;
        List<String> errorMsgs;
        boolean hasError = false;
        Object o = this.getOwnerStateBinding().getObject();
        if (o instanceof TableEditor.TableEditorListener && !CollectionUtils.isEmpty(errorMsgs = (listener = (TableEditor.TableEditorListener)o).validate(itemToValidate, null, Collections.emptyList(), this))) {
            this.recErrorMsgs(errorMsgs);
            hasError = true;
        }
        return hasError;
    }
}

