/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.component.common;

import com.pingidentity.fsm.tasklet.TaskletCard;
import com.pingidentity.util.StringPairPropertySelectionModel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.IBinding;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.form.IPropertySelectionModel;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.apache.tapestry.valid.ValidationDelegate;

public abstract class StringListEditor
extends TaskletCard
implements Serializable {
    private static final long serialVersionUID = 1L;

    public abstract IBinding getListBinding();

    public abstract IBinding getStateBinding();

    public abstract IBinding getDelegateBinding();

    public abstract IBinding getAllowEmptyBinding();

    public abstract IBinding getColumnTitleBinding();

    public abstract IBinding getOwnerStateBinding();

    public abstract IBinding getEditEnabledBinding();

    public abstract IBinding getRestrictSelectionsBinding();

    public abstract IBinding getAllowedSelectionsBinding();

    public Boolean isRestrictSelections() {
        IBinding binding = this.getRestrictSelectionsBinding();
        return binding.getBoolean();
    }

    public Boolean getAllowEmpty() {
        IBinding binding = this.getAllowEmptyBinding();
        return binding.getBoolean();
    }

    public Boolean isEditEnabled() {
        IBinding binding = this.getEditEnabledBinding();
        return binding.getBoolean();
    }

    public List<String> getAllowedSelections() {
        return (List)this.getAllowedSelectionsBinding().getObject("allowedSelections", List.class);
    }

    public IPropertySelectionModel getAllowedSelectionsModel() {
        StringPairPropertySelectionModel allowedSelectionsModel = new StringPairPropertySelectionModel(true);
        for (String selection : this.getAllowedSelections()) {
            allowedSelectionsModel.add(selection, selection);
        }
        return allowedSelectionsModel;
    }

    public List<String> getList() {
        return (List)this.getListBinding().getObject("List", List.class);
    }

    public ValidationDelegate getDelegate() {
        return (ValidationDelegate)this.getDelegateBinding().getObject("delegate", ValidationDelegate.class);
    }

    protected void saveState(State curState) {
        this.getStateBinding().setObject((Object)curState);
    }

    public State getState() {
        State state = (State)this.getStateBinding().getObject("state", Object.class);
        if (state == null) {
            state = new State(this.getList());
            this.saveState(state);
        }
        return state;
    }

    @Override
    public void appendErrors(IValidationDelegate delegate) {
        if (this.isEditMode()) {
            delegate.setFormComponent(null);
            delegate.record(this.getMessage("Update_required"), ValidationConstraint.REQUIRED);
        }
        if (!this.getAllowEmpty().booleanValue() && this.getList().isEmpty()) {
            delegate.setFormComponent(null);
            delegate.record(this.getMessage("One_attribute_required"), ValidationConstraint.REQUIRED);
        }
    }

    public void addStringListItem(IRequestCycle cycle) {
        State s = this.getState();
        s.addStringListItem();
    }

    public void deleteStringListItem(IRequestCycle cycle) {
        if (this.isCurrentUserAdmin()) {
            State s = this.getState();
            Object[] params = cycle.getServiceParameters();
            Integer index = (Integer)params[0];
            s.deleteStringListItem(index);
        } else {
            this.auditLogUnauthorizedUserDeleteAction("string list editor");
        }
    }

    public void unDeleteStringListItem(IRequestCycle cycle) {
        if (this.isCurrentUserAdmin()) {
            State s = this.getState();
            Object[] params = cycle.getServiceParameters();
            Integer index = (Integer)params[0];
            s.unDeleteStringListItem(index);
        } else {
            this.auditLogUnauthorizedUserUndeleteAction("string list editor");
        }
    }

    public void editStringListItem(IRequestCycle cycle) {
        State s = this.getState();
        Object[] params = cycle.getServiceParameters();
        Integer index = (Integer)params[0];
        String itemValue = (String)params[1];
        s.editStringListItem(index, itemValue);
    }

    public void updateStringListItem(IRequestCycle cycle) {
        State s = this.getState();
        s.updateStringListItem();
    }

    public void cancelStringListItemEdit(IRequestCycle cycle) {
        State s = this.getState();
        Object[] params = cycle.getServiceParameters();
        Integer index = (Integer)params[0];
        s.cancelStringListItemEdit(index);
    }

    public boolean isEditMode() {
        State s = this.getState();
        for (StringListItem requestStringListItem : s.getStringListItems()) {
            if (!requestStringListItem.isEdit()) continue;
            return true;
        }
        return false;
    }

    public String getItemValueToAdd() {
        State s = this.getState();
        return s.getItemValueToAdd();
    }

    public void setItemValueToAdd(String itemValueToAdd) {
        State s = this.getState();
        s.setItemValueToAdd(itemValueToAdd);
    }

    public List<StringListItem> getStringListItems() {
        State s = this.getState();
        return s.getStringListItems();
    }

    public class StringListItem
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private boolean edit = false;
        private boolean markedForDelete;
        private String itemValue;
        private boolean editDisabled = false;
        private boolean deleteDisabled = false;

        public StringListItem(String itemValue) {
            this.itemValue = itemValue;
        }

        public void setItemValue(String itemValue) {
            this.itemValue = itemValue;
        }

        public String getItemValue() {
            return this.itemValue;
        }

        public boolean isEdit() {
            return this.edit;
        }

        public void setEdit(boolean edit) {
            this.edit = edit;
        }

        public boolean isMarkedForDelete() {
            return this.markedForDelete;
        }

        public void setMarkedForDelete(boolean markedForDelete) {
            this.markedForDelete = markedForDelete;
        }

        public boolean isEditDisabled() {
            return this.editDisabled;
        }

        public void setEditDisabled(boolean editDisabled) {
            this.editDisabled = editDisabled;
        }

        public boolean isDeleteDisabled() {
            return this.deleteDisabled;
        }

        public void setDeleteDisabled(boolean deleteDisabled) {
            this.deleteDisabled = deleteDisabled;
        }
    }

    public class State
    implements Serializable {
        private static final long serialVersionUID = 20050515L;
        private String itemValueToAdd;
        private int indexInEdit = -1;
        private String originalItemValue;
        private List<StringListItem> stringListItems;
        private List<String> stringListFromTaskletState;

        public State(List<String> stringList) {
            this.stringListFromTaskletState = stringList;
            this.stringListItems = new ArrayList<StringListItem>();
            for (String stringFromTaskletState : this.stringListFromTaskletState) {
                this.stringListItems.add(new StringListItem(stringFromTaskletState));
            }
        }

        public List<StringListItem> getStringListItems() {
            return this.stringListItems;
        }

        public String getItemValueToAdd() {
            return this.itemValueToAdd;
        }

        public void setItemValueToAdd(String itemValueToAdd) {
            this.itemValueToAdd = itemValueToAdd;
        }

        public void addStringListItem() {
            StringListEditor.this.getDelegate().clearErrors();
            String trimmedItemValueToAdd = StringUtils.defaultString((String)this.itemValueToAdd).trim();
            if (StringUtils.isEmpty((String)trimmedItemValueToAdd)) {
                StringListEditor.this.getDelegate().setFormComponent(null);
                StringListEditor.this.getDelegate().record(StringListEditor.this.getMessage("String_required_add"), ValidationConstraint.REQUIRED);
            } else if (this.isStringListItemDefined(trimmedItemValueToAdd, -1)) {
                StringListEditor.this.getDelegate().setFormComponent(null);
                StringListEditor.this.getDelegate().record(StringListEditor.this.getMessage("Duplicates_not_allowed"), ValidationConstraint.REQUIRED);
            } else if (!this.extraItemValidate(trimmedItemValueToAdd)) {
                StringListItem requestStringListItemToAdd = new StringListItem(trimmedItemValueToAdd);
                this.stringListItems.add(requestStringListItemToAdd);
                this.itemValueToAdd = "";
                this.updateStringListFromTaskletState();
            }
        }

        public void editStringListItem(int index, String itemValue) {
            this.indexInEdit = index;
            this.originalItemValue = itemValue;
            this.stringListItems.get(index).setEdit(true);
        }

        public void deleteStringListItem(int indexToDelete) {
            this.stringListItems.get(indexToDelete).setMarkedForDelete(true);
            this.updateStringListFromTaskletState();
        }

        public void deleteAllStringListItems() {
            for (StringListItem stringListItem : this.stringListItems) {
                stringListItem.setMarkedForDelete(true);
            }
            this.updateStringListFromTaskletState();
        }

        public void unDeleteAllStringListItems() {
            for (StringListItem stringListItem : this.stringListItems) {
                stringListItem.setMarkedForDelete(false);
            }
            this.updateStringListFromTaskletState();
        }

        public void unDeleteStringListItem(int indexToDelete) {
            this.stringListItems.get(indexToDelete).setMarkedForDelete(false);
            this.updateStringListFromTaskletState();
        }

        public void updateStringListItem() {
            StringListEditor.this.getDelegate().clearErrors();
            StringListItem requestStringListItem = this.stringListItems.get(this.indexInEdit);
            String newItemValue = requestStringListItem.getItemValue();
            String trimmedItemValueToAdd = StringUtils.defaultString((String)newItemValue).trim();
            if (StringUtils.isEmpty((String)newItemValue)) {
                StringListEditor.this.getDelegate().record(StringListEditor.this.getMessage("String_required_update"), ValidationConstraint.REQUIRED);
            } else if (this.isStringListItemDefined(trimmedItemValueToAdd, this.indexInEdit)) {
                StringListEditor.this.getDelegate().record(StringListEditor.this.getMessage("Duplicates_not_allowed", trimmedItemValueToAdd), ValidationConstraint.REQUIRED);
            } else if (!this.extraItemValidate(newItemValue)) {
                requestStringListItem.setEdit(false);
                this.indexInEdit = -1;
                this.updateStringListFromTaskletState();
            }
        }

        public void cancelStringListItemEdit(int index) {
            StringListItem requestStringListItem = this.stringListItems.get(index);
            requestStringListItem.setItemValue(this.originalItemValue);
            requestStringListItem.setEdit(false);
        }

        private void updateStringListFromTaskletState() {
            this.stringListFromTaskletState.clear();
            for (StringListItem sli : this.stringListItems) {
                if (sli.isMarkedForDelete()) continue;
                this.stringListFromTaskletState.add(sli.getItemValue());
            }
        }

        private boolean isStringListItemDefined(String itemValue, int index) {
            for (int i = 0; i < this.stringListItems.size(); ++i) {
                StringListItem requestStringListItem;
                if (i == index || !(requestStringListItem = this.stringListItems.get(i)).getItemValue().equals(itemValue)) continue;
                return true;
            }
            return false;
        }

        private boolean extraItemValidate(String value) {
            ListItemValidator listItemValidator;
            String msg;
            boolean hasError = false;
            Object o = StringListEditor.this.getOwnerStateBinding().getObject();
            if (o instanceof ListItemValidator && (msg = (listItemValidator = (ListItemValidator)o).validate(value)) != null) {
                StringListEditor.this.getDelegate().setFormComponent(null);
                StringListEditor.this.getDelegate().record(msg, ValidationConstraint.REQUIRED);
                hasError = true;
            }
            return hasError;
        }

        public void clear() {
            this.indexInEdit = -1;
            this.itemValueToAdd = "";
            this.originalItemValue = "";
            this.stringListFromTaskletState = StringListEditor.this.getList();
            this.stringListItems = new ArrayList<StringListItem>();
            for (String stringFromTaskletState : this.stringListFromTaskletState) {
                this.stringListItems.add(new StringListItem(stringFromTaskletState));
            }
            StringListEditor.this.saveState(this);
        }
    }

    public static interface ListItemValidator {
        public String validate(String var1);
    }
}

