/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.component.common;

import com.pingidentity.crypto.Cert;
import com.pingidentity.crypto.CertificateHelper;
import com.pingidentity.fsm.state.impl.CertificateState;
import com.pingidentity.fsm.tasklet.TaskletCard;
import com.pingidentity.fsm.tasklet.data.WsTrustListUIEntry;
import com.pingidentity.util.StringPairPropertySelectionModel;
import java.io.Serializable;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.tapestry.IBinding;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.form.IPropertySelectionModel;
import org.apache.tapestry.valid.ValidationDelegate;
import org.sourceid.saml20.domain.ConnectionCerts;

public abstract class WsTrustCertListEditor
extends TaskletCard
implements Serializable {
    private static final long serialVersionUID = 2L;
    private Cert selectedCert;

    public abstract IBinding getListBinding();

    public abstract IBinding getStateBinding();

    public abstract IBinding getDelegateBinding();

    public abstract Object getCertManager();

    public abstract IBinding getConnectionCertsBinding();

    public List<WsTrustListUIEntry> getList() {
        return (List)this.getListBinding().getObject("List", List.class);
    }

    public List<WsTrustListUIEntry> getListCopy() {
        List list = (List)this.getListBinding().getObject("List", List.class);
        List<WsTrustListUIEntry> listCopy = list.stream().collect(Collectors.toList());
        return listCopy;
    }

    public ValidationDelegate getDelegate() {
        return (ValidationDelegate)this.getDelegateBinding().getObject("delegate", ValidationDelegate.class);
    }

    public ConnectionCerts getConnectionCerts() {
        return (ConnectionCerts)this.getConnectionCertsBinding().getObject("connectionCerts", ConnectionCerts.class);
    }

    public void setConnectionCerts(ConnectionCerts selectedCert) {
        this.getConnectionCertsBinding().setObject((Object)selectedCert);
    }

    protected void saveState(ListInternalState curState) {
        this.getStateBinding().setObject((Object)curState);
    }

    protected ListInternalState getState() {
        ListInternalState state = (ListInternalState)this.getStateBinding().getObject("state", Object.class);
        if (state == null) {
            state = new ListInternalState();
            this.saveState(state);
        }
        return state;
    }

    public void setCurrentItem(WsTrustListUIEntry currentItem) {
        ListInternalState s = this.getState();
        s.currentItem = currentItem;
        this.saveState(s);
    }

    public WsTrustListUIEntry getCurrentItem() {
        return this.getState().currentItem;
    }

    public WsTrustListUIEntry getNewItem() {
        return this.getState().newItem;
    }

    public void setNewItem(WsTrustListUIEntry newItem) {
        ListInternalState s = this.getState();
        s.newItem = newItem;
        this.saveState(s);
    }

    public void onAddItem(IRequestCycle cycle) {
        if (this.selectedCert != null) {
            WsTrustListUIEntry newEntry = new WsTrustListUIEntry();
            newEntry.setEntry(this.selectedCert.getDescriptionForDisplay(35));
            newEntry.setCert(this.selectedCert);
            this.getList().add(newEntry);
            this.saveState(this.getState());
            CertificateState certificateState = this.getCurrentState(CertificateState.class);
            certificateState.getActiveCerts().add(this.selectedCert);
            certificateState.getInactiveCerts().remove(this.selectedCert);
        }
    }

    public void onRemoveItem(IRequestCycle cycle) {
        if (this.isCurrentUserAdmin()) {
            Object[] params = cycle.getServiceParameters();
            ListInternalState curState = this.getState();
            String itemToDeactivate = (String)params[0];
            WsTrustListUIEntry removeItem = this.findByEntry(itemToDeactivate);
            List<WsTrustListUIEntry> list = this.getList();
            list.remove(removeItem);
            this.saveState(curState);
            if (removeItem != null) {
                CertificateState certificateState = this.getCurrentState(CertificateState.class);
                certificateState.getActiveCerts().remove(removeItem.getCert());
                certificateState.getInactiveCerts().add(removeItem.getCert());
            }
        } else {
            this.auditLogUnauthorizedUserDeleteAction("ws trust cert list editor");
        }
    }

    private WsTrustListUIEntry findByEntry(String strToFind) {
        for (WsTrustListUIEntry e : this.getList()) {
            if (!e.getEntry().equals(strToFind)) continue;
            return e;
        }
        return null;
    }

    public IPropertySelectionModel getCertificateModel() {
        StringPairPropertySelectionModel certificateModel = new StringPairPropertySelectionModel(true);
        Set<Cert> certs = this.getNewConnectionCertsForList();
        this.filterExpiredCerts(certs);
        if (!certs.isEmpty()) {
            for (Cert cert : certs) {
                certificateModel.add(cert.getDescriptionForDisplay(35), cert);
            }
        }
        return certificateModel;
    }

    private void filterExpiredCerts(Collection<? extends Cert> certs) {
        Iterator<? extends Cert> iter = certs.iterator();
        while (iter.hasNext()) {
            Cert cert = iter.next();
            X509Certificate x509 = cert.getX509Certificate();
            try {
                x509.checkValidity(new Date());
                if (!CertificateHelper.isKnownToBeRevoked((Cert)cert)) continue;
                iter.remove();
            }
            catch (CertificateExpiredException cee) {
                iter.remove();
            }
            catch (CertificateNotYetValidException cnyve) {
                iter.remove();
            }
        }
    }

    private void filterAlreadyAddedCerts(Set<? extends Cert> certs) {
        HashSet<Cert> alreadyExistingEntries = new HashSet<Cert>();
        for (WsTrustListUIEntry entry : this.getList()) {
            alreadyExistingEntries.add(entry.getCert());
        }
        certs.removeAll(alreadyExistingEntries);
    }

    private Set<Cert> getNewConnectionCertsForList() {
        ConnectionCerts connectionCerts = this.getConnectionCerts();
        Set certs = connectionCerts.getAllVerificationCerts();
        if (!certs.isEmpty()) {
            this.filterAlreadyAddedCerts(certs);
        }
        return certs;
    }

    public Cert getSelectedCert() {
        return this.selectedCert;
    }

    public void setSelectedCert(Cert selectedCert) {
        this.selectedCert = selectedCert;
    }

    private class ListInternalState
    implements Serializable {
        private static final long serialVersionUID = 20071029L;
        WsTrustListUIEntry currentItem;
        WsTrustListUIEntry newItem = new WsTrustListUIEntry();

        private ListInternalState() {
        }
    }
}

