/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.component.common;

import com.pingidentity.fsm.tasklet.TaskletCard;
import com.pingidentity.fsm.tasklet.data.WsTrustListUIEntry;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.IBinding;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.apache.tapestry.valid.ValidationDelegate;
import org.sourceid.common.ValidationUtil;

public abstract class WsTrustListEditor
extends TaskletCard
implements Serializable {
    private static final long serialVersionUID = 2L;

    public abstract IBinding getListBinding();

    public abstract IBinding getStateBinding();

    public abstract IBinding getDelegateBinding();

    public List<WsTrustListUIEntry> getList() {
        return (List)this.getListBinding().getObject("List", List.class);
    }

    public ValidationDelegate getDelegate() {
        return (ValidationDelegate)this.getDelegateBinding().getObject("delegate", ValidationDelegate.class);
    }

    protected void saveState(ListInternalState curState) {
        this.getStateBinding().setObject((Object)curState);
    }

    protected ListInternalState getState() {
        ListInternalState state = (ListInternalState)this.getStateBinding().getObject("state", Object.class);
        if (state == null) {
            state = new ListInternalState();
            this.saveState(state);
        }
        return state;
    }

    public boolean isEditMode() {
        return this.getState().editItem != null;
    }

    @Override
    public void appendErrors(IValidationDelegate delegate) {
        if (this.isEditMode()) {
            delegate.setFormComponent(null);
            delegate.record(this.getMessage("Update_required"), ValidationConstraint.REQUIRED);
        }
    }

    public boolean isCurrentItemEditing() {
        ListInternalState curState = this.getState();
        return curState.currentItem.equals(curState.editItem);
    }

    public void setCurrentItem(WsTrustListUIEntry currentItem) {
        ListInternalState s = this.getState();
        s.currentItem = currentItem;
        this.saveState(s);
    }

    public WsTrustListUIEntry getCurrentItem() {
        return this.getState().currentItem;
    }

    public WsTrustListUIEntry getNewItem() {
        return this.getState().newItem;
    }

    public void setNewItem(WsTrustListUIEntry newItem) {
        ListInternalState s = this.getState();
        s.newItem = newItem;
        this.saveState(s);
    }

    public WsTrustListUIEntry getEditItem() {
        return this.getState().editItem;
    }

    public void setEditItem(WsTrustListUIEntry item) {
        ListInternalState s = this.getState();
        s.editItem = item;
        this.saveState(s);
    }

    public WsTrustListUIEntry getUpdateItem() {
        return this.getState().updateItem;
    }

    public void setUpdateItem(WsTrustListUIEntry updateItem) {
        ListInternalState s = this.getState();
        s.updateItem = updateItem;
        this.saveState(s);
    }

    public void onAddItem(IRequestCycle cycle) {
        boolean hasErrors = false;
        if (this.findByEntry(this.getState().newItem.getEntry().trim()) != null) {
            this.getDelegate().setFormComponent(null);
            this.getDelegate().record(this.getMessage("Duplicate_subject_dn") + " " + this.getState().newItem.getEntry(), ValidationConstraint.REQUIRED);
            hasErrors = true;
        }
        if (StringUtils.isBlank((String)this.getState().newItem.getEntry().trim())) {
            this.getDelegate().setFormComponent(null);
            this.getDelegate().record(this.getMessage("Subject_dn_required"), ValidationConstraint.REQUIRED);
            hasErrors = true;
        } else if (!ValidationUtil.isValidSubjectDN((String)this.getState().newItem.getEntry().trim())) {
            this.getDelegate().setFormComponent(null);
            this.getDelegate().record(this.getMessage("Invalid_subject_dn"), ValidationConstraint.REQUIRED);
            hasErrors = true;
        }
        if (!hasErrors) {
            ListInternalState s = this.getState();
            WsTrustListUIEntry newEntry = new WsTrustListUIEntry();
            newEntry.setEntry(s.newItem.getEntry().trim());
            s.newItem = new WsTrustListUIEntry();
            this.getList().add(newEntry);
            this.saveState(s);
        }
    }

    public void onUpdateItem(IRequestCycle cycle) {
        if (this.getState().updateItem.equals(this.getState().editItem)) {
            this.getState().editItem = null;
            this.getState().updateItem = null;
        } else {
            boolean hasErrors = false;
            if (!this.getState().updateItem.getEntry().trim().equals(this.getState().editItem.getEntry().trim()) && this.findByEntry(this.getState().updateItem.getEntry().trim()) != null) {
                this.getDelegate().setFormComponent(null);
                this.getDelegate().record(this.getMessage("Duplicate_subject_dn") + " " + this.getState().updateItem.getEntry().trim(), ValidationConstraint.REQUIRED);
                hasErrors = true;
            }
            if (StringUtils.isBlank((String)this.getState().updateItem.getEntry().trim())) {
                this.getDelegate().setFormComponent(null);
                this.getDelegate().record(this.getMessage("Subject_dn_required"), ValidationConstraint.REQUIRED);
                hasErrors = true;
            } else if (!ValidationUtil.isValidSubjectDN((String)this.getState().updateItem.getEntry().trim())) {
                this.getDelegate().setFormComponent(null);
                this.getDelegate().record(this.getMessage("Invalid_subject_dn"), ValidationConstraint.REQUIRED);
                hasErrors = true;
            }
            if (!hasErrors) {
                ListInternalState s = this.getState();
                WsTrustListUIEntry mapping = this.findByEntry(s.editItem.getEntry().trim());
                mapping.setEntry(s.updateItem.getEntry().trim());
                this.getState().editItem = null;
                s.updateItem = null;
                this.saveState(s);
            }
        }
    }

    public void onEditItem(IRequestCycle cycle) {
        Object[] params = cycle.getServiceParameters();
        ListInternalState curState = this.getState();
        String itemToEdit = (String)params[0];
        WsTrustListUIEntry editItem = this.findByEntry(itemToEdit);
        curState.editItem = new WsTrustListUIEntry(editItem);
        curState.updateItem = new WsTrustListUIEntry(editItem);
        this.saveState(curState);
    }

    public void onDeleteItem(IRequestCycle cycle) {
        if (this.isCurrentUserAdmin()) {
            Object[] params = cycle.getServiceParameters();
            ListInternalState curState = this.getState();
            String itemToDeactivate = (String)params[0];
            WsTrustListUIEntry deactivateItem = this.findByEntry(itemToDeactivate);
            deactivateItem.setActive(false);
            curState.updateItem = null;
            curState.editItem = null;
            this.saveState(curState);
        } else {
            this.auditLogUnauthorizedUserDeleteAction("ws trust list editor");
        }
    }

    public void onUndeleteItem(IRequestCycle cycle) {
        if (this.isCurrentUserAdmin()) {
            Object[] params = cycle.getServiceParameters();
            ListInternalState curState = this.getState();
            String itemToActivate = (String)params[0];
            WsTrustListUIEntry activateItem = this.findByEntry(itemToActivate);
            activateItem.setActive(true);
            curState.updateItem = null;
            curState.editItem = null;
            this.saveState(curState);
        } else {
            this.auditLogUnauthorizedUserUndeleteAction("ws trust list editor");
        }
    }

    public void cancelEdit(IRequestCycle cycle) {
        ListInternalState curState = this.getState();
        curState.updateItem = null;
        curState.editItem = null;
        this.saveState(curState);
    }

    private WsTrustListUIEntry findByEntry(String strToFind) {
        for (WsTrustListUIEntry e : this.getList()) {
            if (!e.getEntry().equals(strToFind)) continue;
            return e;
        }
        return null;
    }

    private class ListInternalState
    implements Serializable {
        private static final long serialVersionUID = 20071029L;
        WsTrustListUIEntry updateItem;
        WsTrustListUIEntry editItem;
        WsTrustListUIEntry currentItem;
        WsTrustListUIEntry newItem = new WsTrustListUIEntry();

        private ListInternalState() {
        }
    }
}

