/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.component.thirdparty;

import java.io.IOException;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.ApplicationRuntimeException;
import org.apache.tapestry.IActionListener;
import org.apache.tapestry.IBinding;
import org.apache.tapestry.IComponent;
import org.apache.tapestry.IForm;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.IResourceLocation;
import org.apache.tapestry.IScript;
import org.apache.tapestry.IScriptProcessor;
import org.apache.tapestry.Tapestry;
import org.apache.tapestry.engine.IPageLoader;
import org.apache.tapestry.engine.IScriptSource;
import org.apache.tapestry.form.AbstractFormComponent;
import org.apache.tapestry.form.IFormComponent;
import org.apache.tapestry.html.Body;
import org.apache.tapestry.link.DirectLink;
import org.apache.tapestry.spec.IComponentSpecification;
import org.apache.tapestry.util.io.DataSqueezer;

public abstract class LinkSubmit
extends AbstractFormComponent {
    private static final String PARAMETERS_SUFFIX = "$parm";
    private IScript _script;

    public abstract IActionListener getListener();

    public void finishLoad(IRequestCycle cycle, IPageLoader loader, IComponentSpecification specification) {
        super.finishLoad(cycle, loader, specification);
        IScriptSource source = cycle.getEngine().getScriptSource();
        IResourceLocation scriptLocation = this.getSpecification().getSpecificationLocation().getRelativeLocation("LinkSubmit.script");
        this._script = source.getScript(scriptLocation);
    }

    public abstract Object getParameters();

    protected void renderComponent(IMarkupWriter writer, IRequestCycle cycle) {
        IForm form = this.getForm(cycle);
        String name = form.getElementId((IFormComponent)this);
        boolean rewinding = cycle.isRewinding();
        boolean disabled = this.isDisabled();
        if (!disabled) {
            if (rewinding) {
                this.rewind(writer, cycle);
            } else {
                this.addHiddenFieldsForParameters(cycle);
                form.addHiddenValue(name, "");
                Body body = Body.get((IRequestCycle)cycle);
                HashMap<String, String> symbols = new HashMap<String, String>();
                symbols.put("name", name);
                symbols.put("formName", form.getName());
                this._script.execute(cycle, (IScriptProcessor)body, symbols);
                String href = (String)symbols.get("href");
                writer.begin("a");
                writer.attribute("href", href);
                if (StringUtils.isNotBlank((String)this.getOnclick())) {
                    writer.attribute("onclick", this.getOnclick());
                }
                if (StringUtils.isNotBlank((String)this.getId())) {
                    writer.attribute("id", this.getElementId());
                }
                this.renderInformalParameters(writer, cycle);
            }
        }
        this.renderBody(writer, cycle);
        if (!rewinding && !disabled) {
            writer.end();
        }
    }

    void addHiddenFieldsForParameters(IRequestCycle cycle) {
        Object[] parameters = DirectLink.constructServiceParameters((Object)this.getParameters());
        int count = Tapestry.size((Object[])parameters);
        if (count == 0) {
            return;
        }
        DataSqueezer ds = cycle.getEngine().getDataSqueezer();
        try {
            String[] squeezed = ds.squeeze(parameters);
            IForm form = this.getForm();
            String parameterName = this.getName() + PARAMETERS_SUFFIX;
            for (int i = 0; i < squeezed.length; ++i) {
                form.addHiddenValue(parameterName, squeezed[i]);
            }
        }
        catch (IOException ex) {
            throw new ApplicationRuntimeException("Unable to squeeze parameter: " + ex, (Object)this, this.getLocation(), (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rewind(IMarkupWriter writer, IRequestCycle cycle) {
        String name = this.getName();
        String value = cycle.getRequestContext().getParameter(name);
        if (Tapestry.isBlank((String)value)) {
            return;
        }
        Object[] parameters = this.extractParameters(cycle, name);
        try {
            cycle.setServiceParameters(parameters);
            IBinding selectedBinding = this.getSelectedBinding();
            if (selectedBinding != null) {
                selectedBinding.setObject(this.getTag());
            }
            this.getListener().actionTriggered((IComponent)this, cycle);
        }
        finally {
            cycle.setServiceParameters(null);
        }
    }

    Object[] extractParameters(IRequestCycle cycle, String name) {
        String parametersName = name + PARAMETERS_SUFFIX;
        Object[] squeezed = cycle.getRequestContext().getParameters(parametersName);
        if (Tapestry.size((Object[])squeezed) == 0) {
            return null;
        }
        DataSqueezer ds = cycle.getEngine().getDataSqueezer();
        try {
            return ds.unsqueeze((String[])squeezed);
        }
        catch (IOException ex) {
            throw new ApplicationRuntimeException("Unable to unsqueeze parameter: " + ex, (Object)this, this.getLocation(), (Throwable)ex);
        }
    }

    public abstract boolean isDisabled();

    public abstract void setDisabled(boolean var1);

    public abstract Object getTag();

    public abstract void setTag(Object var1);

    public abstract void setOnclick(String var1);

    public abstract String getOnclick();

    public abstract String getElementId();

    public abstract void setElementId(String var1);

    public abstract void setSelectedBinding(IBinding var1);

    public abstract IBinding getSelectedBinding();
}

