/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.dependency.error;

import com.pingidentity.dependency.error.AffectedItemType;
import com.pingidentity.dependency.error.DependencyErrorManager;
import com.pingidentity.dependency.error.DependencyErrorUIValidator;
import com.pingidentity.dependency.error.mgmt.DependencyError;
import com.pingidentity.fsm.tasklet.data.DependencyType;
import java.util.Set;
import org.sourceid.a2a.domain.Direct2SpAdapterMapping;
import org.sourceid.a2a.domain.Source2TargetMapping;
import org.sourceid.a2a.domain.mgmt.Apc2SpAdapterManager;
import org.sourceid.saml20.domain.AttributeContract;
import org.sourceid.saml20.domain.AttributeMapping;
import org.sourceid.saml20.domain.ConfigurablePluginInstance;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.impl.PluginManagementSupport;
import org.sourceid.saml20.metadata.MetaDataFactory;
import org.sourceid.saml20.metadata.local.MetadataLocal;

public class DependencyErrorHandler {
    private final transient DependencyErrorManager dependencyErrorManager = MgmtFactory.getDependencyErrorManager();
    private final MetadataLocal localMetaData = MetaDataFactory.getLocalMetaData();

    public void removeDependencyError(String affectedItemId, AffectedItemType affectedItemType) {
        this.dependencyErrorManager.remove(affectedItemId, affectedItemType);
    }

    public void performDependencyValidation(DependencyErrorUIValidator validator, Object causedByItem, DependencyType ... dependencyTypes) {
        for (DependencyType dependencyType : dependencyTypes) {
            this.performDependencyValidation(validator, causedByItem, dependencyType);
        }
    }

    public void performDependencyValidation(DependencyErrorUIValidator validator, Object causedByItem, DependencyType dependencyType) {
        validator.obtainNewDependencyErrors(causedByItem, dependencyType);
    }

    private boolean isDisableAutomaticConnectionValidation() {
        return this.localMetaData.getDisableAutomaticConnectionValidation();
    }

    public void updateDependenciesForSpAdapter(ConfigurablePluginInstance spAdapterInstance) {
        DependencyType type = DependencyType.SP_ADAPTER;
        if (this.isDisableAutomaticConnectionValidation()) {
            return;
        }
        Apc2SpAdapterManager apc2SpaMgr = MgmtFactory.getApc2SpAdapterManager();
        for (Direct2SpAdapterMapping mapping : apc2SpaMgr.getMappingsUsingTarget(spAdapterInstance.getId())) {
            String mappingId = DependencyErrorHandler.buildMappingId((Source2TargetMapping)mapping);
            this.updateDepsForAttributeMappingUsingContract((AttributeMapping)mapping, spAdapterInstance.getAttributeContract(), mappingId, AffectedItemType.APC2SPA, spAdapterInstance.getId(), type);
        }
    }

    private void updateDepsForAttributeMappingUsingContract(AttributeMapping mapping, AttributeContract updatedContract, String affectedItemId, AffectedItemType affectedItemType, String causedById, DependencyType causedByType) {
        if (this.isDisableAutomaticConnectionValidation()) {
            return;
        }
        Set newAttrs = updatedContract.getAllAttributeNames();
        newAttrs.removeAll(mapping.getAttributeMapping().keySet());
        if (!newAttrs.isEmpty()) {
            DependencyError depError = new DependencyError(affectedItemId, causedByType, causedById, affectedItemType);
            this.dependencyErrorManager.saveError(depError);
        } else {
            this.dependencyErrorManager.remove(affectedItemId, affectedItemType);
        }
    }

    public static String buildMappingId(Source2TargetMapping mapping) {
        return mapping.getSourceId() + "|" + mapping.getTargetId();
    }

    public void updateProtocolSettingsDepsForConnections(String connectionId, String role) {
        DependencyType type = "SP".equals(role) ? DependencyType.SP_CONNECTION : DependencyType.IDP_CONNECTION;
        this.dependencyErrorManager.deleteError(type, connectionId, "Protocol Settings");
    }

    public void updateProtocolSettingsDepsForWsTrustConfig(String pluginId, PluginManagementSupport.PluginManagementType pluginType) {
        DependencyType depType;
        if (PluginManagementSupport.PluginManagementType.TOKEN_PROCESSOR.equals((Object)pluginType)) {
            depType = DependencyType.TOKEN_PROCESSOR;
        } else if (PluginManagementSupport.PluginManagementType.TOKEN_GENERATOR.equals((Object)pluginType)) {
            depType = DependencyType.TOKEN_GENERATOR;
        } else {
            return;
        }
        this.dependencyErrorManager.deleteError(depType, pluginId, "Protocol Settings");
    }
}

