/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.dependency.error.validator.impl;

import com.pingidentity.admin.api.validator.ExtendedMetadataSourceTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.TextSourceTypeValidatorBuilder;
import com.pingidentity.common.util.OgnlHelper;
import com.pingidentity.dependency.error.AffectedItemType;
import com.pingidentity.dependency.error.mgmt.DependencyError;
import com.pingidentity.fsm.tasklet.data.DependencyType;
import com.pingidentity.pf.common.api.validator.Validator;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import ognl.Ognl;
import ognl.OgnlException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.saml20.domain.AttrMappingValue;
import org.sourceid.saml20.domain.SourceType;
import org.sourceid.saml20.domain.TokenAuthorizationIssuanceCriterion;

class AttrMappingDependencyUtil {
    private static Log log = LogFactory.getLog(AttrMappingDependencyUtil.class);

    AttrMappingDependencyUtil() {
    }

    static boolean hasReferenceToInvalidExtendedClientMetadataParam(Set<String> validMetadataSet, SourceType sourceType, String attrVal) {
        if (attrVal == null || sourceType == null) {
            return false;
        }
        switch (sourceType) {
            case EXTENDED_PROPERTIES: 
            case EXTENDED_CLIENT_METADATA: {
                if (!AttrMappingDependencyUtil.isEmptyMetadataSet(validMetadataSet)) {
                    ExtendedMetadataSourceTypeValidatorBuilder validatorBuilder = new ExtendedMetadataSourceTypeValidatorBuilder();
                    validatorBuilder.setSubstitutionVariables(validMetadataSet);
                    Validator validator = validatorBuilder.buildMappingValidator(attrVal);
                    return !validator.validate();
                }
                return true;
            }
            case EXPRESSION: {
                if (attrVal.contains("extproperties.") || attrVal.contains("extclientmetadata.")) {
                    try {
                        Object parsedExpression = Ognl.parseExpression((String)attrVal);
                        OgnlHelper ognlHelper = new OgnlHelper();
                        ognlHelper.searchForAllVariableNames(parsedExpression);
                        List invalidVars = ognlHelper.getList().stream().filter(attr -> attr.contains("extproperties.") || attr.contains("extclientmetadata.")).filter(attr -> !validMetadataSet.contains(attr)).collect(Collectors.toList());
                        if (invalidVars.size() > 0) {
                            return true;
                        }
                    }
                    catch (OgnlException e) {
                        log.warn((Object)"Unable to parse OGNL Expression while validating extended client metadata dependencies");
                    }
                }
                return false;
            }
            case TEXT: {
                if (attrVal.contains("extproperties.") || attrVal.contains("extclientmetadata.")) {
                    TextSourceTypeValidatorBuilder validatorBuilder = new TextSourceTypeValidatorBuilder();
                    validatorBuilder.setSubstitutionVariables(validMetadataSet);
                    Validator validator = validatorBuilder.buildMappingValidator(attrVal);
                    return !validator.validate();
                }
                return false;
            }
        }
        return false;
    }

    private static boolean isEmptyMetadataSet(Set<String> validMetadataSet) {
        return validMetadataSet == null || validMetadataSet.size() == 0;
    }

    static void clearDependencyErrorForAffectedType(Collection<DependencyError> existingErrors, AffectedItemType affectedItemType, DependencyType dependencyType) {
        existingErrors.removeIf(dependencyError -> dependencyType.equals((Object)dependencyError.getCausedByType()) && dependencyError.getAffectedInstanceType().equals((Object)affectedItemType));
    }

    static void clearDependencyErrorForAffectedType(Collection<DependencyError> existingErrors, AffectedItemType affectedItemType, String affectedItemId, DependencyType dependencyType) {
        existingErrors.removeIf(dependencyError -> dependencyType.equals((Object)dependencyError.getCausedByType()) && dependencyError.getAffectedInstanceType().equals((Object)affectedItemType) && dependencyError.getAffectedInstanceId().equals(affectedItemId));
    }

    static boolean checkDependencyErrorForContractFulfillment(Collection<DependencyError> existingErrors, Set<String> extendedClientMetadataSet, Map<String, List<AttrMappingValue>> mapping, AffectedItemType affectedItemType, String affectedItemId) {
        for (List<AttrMappingValue> attrMappingValueList : mapping.values()) {
            for (AttrMappingValue mappingValue : attrMappingValueList) {
                DependencyError error = new DependencyError(affectedItemId, DependencyType.OAUTH_CLIENT_SETTINGS, "", affectedItemType);
                if (existingErrors.contains(error) || !AttrMappingDependencyUtil.hasReferenceToInvalidExtendedClientMetadataParam(extendedClientMetadataSet, mappingValue.getType(), mappingValue.getValue())) continue;
                existingErrors.add(error);
                return true;
            }
        }
        return false;
    }

    static boolean checkDependencyErrorForIssuanceCriteria(Collection<DependencyError> existingErrors, Set<String> extendedClientMetadataSet, List<TokenAuthorizationIssuanceCriterion> issuanceCriterionList, AffectedItemType affectedItemType, String affectedItemId) {
        for (TokenAuthorizationIssuanceCriterion issuanceCriterion : issuanceCriterionList) {
            DependencyError error = new DependencyError(affectedItemId, DependencyType.OAUTH_CLIENT_SETTINGS, "", affectedItemType);
            if (existingErrors.contains(error) || !AttrMappingDependencyUtil.hasReferenceToInvalidExtendedClientMetadataParam(extendedClientMetadataSet, issuanceCriterion.getAttrSourceType(), issuanceCriterion.getAttrName() == null || issuanceCriterion.getAttrName().isEmpty() ? issuanceCriterion.getExpr() : issuanceCriterion.getAttrName())) continue;
            existingErrors.add(error);
            return true;
        }
        return false;
    }
}

