/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.dependency.error.validator.impl;

import com.pingidentity.dependency.error.AffectedItemType;
import com.pingidentity.dependency.error.DependencyErrorValidatorImpl;
import com.pingidentity.dependency.error.mgmt.DependencyError;
import com.pingidentity.dependency.error.validator.impl.AttrMappingDependencyUtil;
import com.pingidentity.fsm.state.impl.OAuthMetadataUtil;
import com.pingidentity.fsm.tasklet.data.DependencyType;
import java.util.Collection;
import java.util.Set;
import org.sourceid.oauth20.domain.AccessTokenMapping;
import org.sourceid.oauth20.domain.AuthzServerManager;
import org.sourceid.oauth20.domain.ClientSetting;
import org.sourceid.oauth20.domain.ClientSettingManager;
import org.sourceid.saml20.domain.AttributeMapping;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class ExtendedPropertiesAccessTokenMapDepErrorValidatorImpl
extends DependencyErrorValidatorImpl {
    private static final AuthzServerManager authzServerMgr = MgmtFactory.getAuthzServerManager();
    private static final ClientSettingManager clientSettingMgr = MgmtFactory.getClientSettingManager();

    @Override
    public void getDependencyErrors(Object causedByItem, Collection<DependencyError> existingErrors) {
        if (causedByItem instanceof AccessTokenMapping) {
            ClientSetting clientSetting = clientSettingMgr.getClientSetting();
            Set<String> extendedClientMetadataSet = OAuthMetadataUtil.getExtendedClientMetadataParamsWithPrefix(clientSetting);
            AccessTokenMapping accessTokenMapping = (AccessTokenMapping)causedByItem;
            AttrMappingDependencyUtil.clearDependencyErrorForAffectedType(existingErrors, AffectedItemType.OAUTH_ACCESS_TOKEN_MAPPING, accessTokenMapping.getId(), DependencyType.OAUTH_CLIENT_SETTINGS);
            this.checkMappingDependencyOnExtendedMetadata(existingErrors, extendedClientMetadataSet, (AttributeMapping)accessTokenMapping);
        } else if (causedByItem instanceof ClientSetting) {
            ClientSetting clientSetting = (ClientSetting)causedByItem;
            Set<String> extendedClientMetadataSet = OAuthMetadataUtil.getExtendedClientMetadataParamsWithPrefix(clientSetting);
            this.checkAccessTokenMappingsExtendedMetadataDependency(existingErrors, extendedClientMetadataSet);
        }
    }

    @Override
    public boolean requiresConnectionValidation() {
        return false;
    }

    private void checkMappingDependencyOnExtendedMetadata(Collection<DependencyError> existingErrors, Set<String> extendedClientMetadataSet, AttributeMapping mapping) {
        if (mapping != null) {
            AccessTokenMapping accessTokenMapping = (AccessTokenMapping)mapping;
            if (AttrMappingDependencyUtil.checkDependencyErrorForContractFulfillment(existingErrors, extendedClientMetadataSet, mapping.getAttributeMapping(), AffectedItemType.OAUTH_ACCESS_TOKEN_MAPPING, accessTokenMapping.getId())) {
                return;
            }
            AttrMappingDependencyUtil.checkDependencyErrorForIssuanceCriteria(existingErrors, extendedClientMetadataSet, mapping.getTokenAuthorizationIssuanceCriteria(), AffectedItemType.OAUTH_ACCESS_TOKEN_MAPPING, accessTokenMapping.getId());
        }
    }

    private void checkAccessTokenMappingsExtendedMetadataDependency(Collection<DependencyError> existingErrors, Set<String> extendedClientMetadataSet) {
        Collection collectionOfMappings = authzServerMgr.getAccessTokenMappings();
        AttrMappingDependencyUtil.clearDependencyErrorForAffectedType(existingErrors, AffectedItemType.OAUTH_ACCESS_TOKEN_MAPPING, DependencyType.OAUTH_CLIENT_SETTINGS);
        if (collectionOfMappings != null) {
            for (AccessTokenMapping mapping : collectionOfMappings) {
                this.checkMappingDependencyOnExtendedMetadata(existingErrors, extendedClientMetadataSet, (AttributeMapping)mapping);
            }
        }
    }
}

