/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.dependency.error.validator.impl;

import com.pingidentity.dependency.error.AffectedItemType;
import com.pingidentity.dependency.error.DependencyErrorValidatorImpl;
import com.pingidentity.dependency.error.mgmt.DependencyError;
import com.pingidentity.dependency.error.validator.impl.AttrMappingDependencyUtil;
import com.pingidentity.fsm.state.impl.OAuthMetadataUtil;
import com.pingidentity.fsm.tasklet.data.DependencyType;
import java.util.Collection;
import java.util.Set;
import org.sourceid.oauth20.domain.ApcToUserKeyAttrMapping;
import org.sourceid.oauth20.domain.AuthzServerManager;
import org.sourceid.oauth20.domain.ClientSetting;
import org.sourceid.oauth20.domain.ClientSettingManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class ExtendedPropertiesSettingsApcToPersistentGrantMapDepErrorValidatorImpl
extends DependencyErrorValidatorImpl {
    private static final AuthzServerManager authzServerMgr = MgmtFactory.getAuthzServerManager();
    private static final ClientSettingManager clientSettingMgr = MgmtFactory.getClientSettingManager();

    @Override
    public void getDependencyErrors(Object causedByItem, Collection<DependencyError> existingErrors) {
        if (causedByItem instanceof ApcToUserKeyAttrMapping) {
            ClientSetting clientSetting = clientSettingMgr.getClientSetting();
            Set<String> extendedClientMetadataSet = OAuthMetadataUtil.getExtendedClientMetadataParamsWithPrefix(clientSetting);
            ApcToUserKeyAttrMapping apcToUserKeyAttrMapping = (ApcToUserKeyAttrMapping)causedByItem;
            AttrMappingDependencyUtil.clearDependencyErrorForAffectedType(existingErrors, AffectedItemType.APC_TO_PERSISTENT_GRANT_MAPPING, apcToUserKeyAttrMapping.getSourceId(), DependencyType.OAUTH_CLIENT_SETTINGS);
            this.checkMappingDependencyOnExtendedMetadata(existingErrors, extendedClientMetadataSet, apcToUserKeyAttrMapping);
        } else if (causedByItem instanceof ClientSetting) {
            ClientSetting clientSetting = (ClientSetting)causedByItem;
            Set<String> extendedClientMetadataSet = OAuthMetadataUtil.getExtendedClientMetadataParamsWithPrefix(clientSetting);
            this.checkOAuthApcExtendedMetadataDependency(existingErrors, extendedClientMetadataSet);
        } else if (causedByItem instanceof Collection && ((Collection)causedByItem).iterator().hasNext() && ((Collection)causedByItem).iterator().next() instanceof ApcToUserKeyAttrMapping) {
            ClientSetting clientSetting = clientSettingMgr.getClientSetting();
            Set<String> extendedClientMetadataSet = OAuthMetadataUtil.getExtendedClientMetadataParamsWithPrefix(clientSetting);
            this.checkOAuthApcExtendedMetadataDependency(existingErrors, extendedClientMetadataSet);
        }
    }

    @Override
    public boolean requiresConnectionValidation() {
        return false;
    }

    void checkOAuthApcExtendedMetadataDependency(Collection<DependencyError> existingErrors, Set<String> extendedClientMetadataSet) {
        Collection collectionOfMappings = authzServerMgr.getApcToUserKeyMappings();
        AttrMappingDependencyUtil.clearDependencyErrorForAffectedType(existingErrors, AffectedItemType.APC_TO_PERSISTENT_GRANT_MAPPING, DependencyType.OAUTH_CLIENT_SETTINGS);
        if (collectionOfMappings != null) {
            for (ApcToUserKeyAttrMapping mapping : collectionOfMappings) {
                this.checkMappingDependencyOnExtendedMetadata(existingErrors, extendedClientMetadataSet, mapping);
            }
        }
    }

    private void checkMappingDependencyOnExtendedMetadata(Collection<DependencyError> existingErrors, Set<String> extendedClientMetadataSet, ApcToUserKeyAttrMapping mapping) {
        if (AttrMappingDependencyUtil.checkDependencyErrorForContractFulfillment(existingErrors, extendedClientMetadataSet, mapping.getAttributeMapping(), AffectedItemType.APC_TO_PERSISTENT_GRANT_MAPPING, mapping.getSourceId())) {
            return;
        }
        if (AttrMappingDependencyUtil.checkDependencyErrorForIssuanceCriteria(existingErrors, extendedClientMetadataSet, mapping.getTokenAuthorizationIssuanceCriteria(), AffectedItemType.APC_TO_PERSISTENT_GRANT_MAPPING, mapping.getSourceId())) {
            return;
        }
    }
}

