/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.dependency.error.validator.impl;

import com.pingidentity.c2ccontract.C2cContractToAssertionMapping;
import com.pingidentity.dependency.error.AffectedItemType;
import com.pingidentity.dependency.error.DependencyErrorValidatorImpl;
import com.pingidentity.dependency.error.mgmt.DependencyError;
import com.pingidentity.dependency.error.validator.impl.AttrMappingDependencyUtil;
import com.pingidentity.fsm.state.impl.OAuthMetadataUtil;
import com.pingidentity.fsm.tasklet.data.DependencyType;
import java.util.Collection;
import java.util.Set;
import org.sourceid.oauth20.domain.ClientSetting;
import org.sourceid.saml20.domain.AttributeMapping;
import org.sourceid.saml20.domain.SpConnection;
import org.sourceid.saml20.domain.WsTrustFederatedWscSettings;
import org.sourceid.saml20.domain.mgmt.ConnectionManager;

public class ExtendedPropertiesSpConnDepErrorValidatorImpl
extends DependencyErrorValidatorImpl {
    private final ConnectionManager connectionManager;

    public ExtendedPropertiesSpConnDepErrorValidatorImpl(ConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
    }

    @Override
    public void getDependencyErrors(Object causedByItem, Collection<DependencyError> existingErrors) {
        if (!(causedByItem instanceof ClientSetting)) {
            return;
        }
        ClientSetting clientSetting = (ClientSetting)causedByItem;
        Set<String> extendedProps = OAuthMetadataUtil.getExtendedClientMetadataParamsWithPrefix(clientSetting);
        AttrMappingDependencyUtil.clearDependencyErrorForAffectedType(existingErrors, AffectedItemType.SP_CONN, DependencyType.OAUTH_CLIENT_SETTINGS);
        Collection spConnections = this.connectionManager.getAllSpConnections();
        for (SpConnection spConnection : spConnections) {
            this.checkSpConnectionDependencyErrors(existingErrors, spConnection, extendedProps);
        }
    }

    @Override
    public boolean requiresConnectionValidation() {
        return true;
    }

    private void checkSpConnectionDependencyErrors(Collection<DependencyError> existingErrors, SpConnection spConnection, Set<String> extendedProps) {
        Collection adapterMappings = spConnection.getAdapterMappings();
        String connID = spConnection.getId();
        for (Object adapterMapping : adapterMappings) {
            AttributeMapping attributeMapping = adapterMapping.getDefaultAttributeMapping();
            if (AttrMappingDependencyUtil.checkDependencyErrorForContractFulfillment(existingErrors, extendedProps, attributeMapping.getAttributeMapping(), AffectedItemType.SP_CONN, connID)) {
                return;
            }
            if (!AttrMappingDependencyUtil.checkDependencyErrorForIssuanceCriteria(existingErrors, extendedProps, attributeMapping.getTokenAuthorizationIssuanceCriteria(), AffectedItemType.SP_CONN, connID)) continue;
            return;
        }
        Collection c2cMappings = spConnection.getC2cMappings();
        for (C2cContractToAssertionMapping c2cMapping : c2cMappings) {
            AttributeMapping attributeMapping = c2cMapping.getDefaultAttributeMapping();
            if (AttrMappingDependencyUtil.checkDependencyErrorForContractFulfillment(existingErrors, extendedProps, attributeMapping.getAttributeMapping(), AffectedItemType.SP_CONN, connID)) {
                return;
            }
            if (!AttrMappingDependencyUtil.checkDependencyErrorForIssuanceCriteria(existingErrors, extendedProps, attributeMapping.getTokenAuthorizationIssuanceCriteria(), AffectedItemType.SP_CONN, connID)) continue;
            return;
        }
        WsTrustFederatedWscSettings wsTrustSettings = spConnection.getWsTrustSettings();
        if (wsTrustSettings != null) {
            wsTrustSettings.getTokenToAssertionMappings().forEach(tokenMapping -> {
                if (AttrMappingDependencyUtil.checkDependencyErrorForContractFulfillment(existingErrors, extendedProps, tokenMapping.getAttributeMapping().getAttributeMapping(), AffectedItemType.SP_CONN, spConnection.getId())) {
                    return;
                }
                if (AttrMappingDependencyUtil.checkDependencyErrorForIssuanceCriteria(existingErrors, extendedProps, tokenMapping.getAttributeMapping().getTokenAuthorizationIssuanceCriteria(), AffectedItemType.SP_CONN, spConnection.getId())) {
                    return;
                }
            });
        }
    }
}

