/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.dependency.error.validator.impl;

import com.pingidentity.authnselection.fragment.PolicyFragment;
import com.pingidentity.authnselection.fragment.PolicyFragmentManager;
import com.pingidentity.dependency.error.AffectedItemType;
import com.pingidentity.dependency.error.DependencyErrorUIValidatorImpl;
import com.pingidentity.dependency.error.DependencyErrorValidatorImpl;
import com.pingidentity.dependency.error.mgmt.DependencyError;
import com.pingidentity.fsm.state.impl.fragments.PolicyFragmentsState;
import com.pingidentity.fsm.tasklet.data.DependencyType;
import com.pingidentity.fsm.tasklet.data.Mode;
import com.pingidentity.fsm.tasklet.impl.fragments.PolicyFragmentTasklet;
import java.util.Collection;
import java.util.List;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationDelegate;
import org.sourceid.oauth20.domain.ClientSetting;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class FragmentDepErrorValidatorImpl
extends DependencyErrorValidatorImpl {
    private final PolicyFragmentManager fragmentManager = MgmtFactory.getPolicyFragmentManager();
    private final DependencyErrorUIValidatorImpl depErrorValidator;

    public FragmentDepErrorValidatorImpl(DependencyErrorUIValidatorImpl depErrorValidator) {
        this.depErrorValidator = depErrorValidator;
    }

    @Override
    public void getDependencyErrors(Object causedByItem, Collection<DependencyError> existingErrors) {
        List fragments = this.fragmentManager.getFragments();
        for (PolicyFragment fragment : fragments) {
            PolicyFragmentTasklet fragmentTasklet = this.depErrorValidator.getTasklet().createTaskletToLoad(PolicyFragmentTasklet.class);
            fragmentTasklet.setParentPoliciesState(new PolicyFragmentsState(fragmentTasklet));
            fragmentTasklet.setMode(Mode.edit);
            fragmentTasklet.populate(fragment);
            ValidationDelegate delegate = new ValidationDelegate();
            fragmentTasklet.appendErrors((IValidationDelegate)delegate, null, false);
            if (causedByItem instanceof ClientSetting) {
                this.depErrorValidator.updateDependencyError(DependencyType.EXTENDED_PROPERTIES.name(), fragment.getId(), delegate.getHasErrors(), AffectedItemType.FRAGMENTS, DependencyType.EXTENDED_PROPERTIES);
                continue;
            }
            this.depErrorValidator.updateDependencyError("", fragment.getId(), delegate.getHasErrors(), AffectedItemType.FRAGMENTS, DependencyType.FRAGMENT_ATTRS);
        }
    }

    @Override
    public boolean requiresConnectionValidation() {
        return false;
    }
}

