/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.dependency.error.validator.impl;

import com.pingidentity.admin.api.ApiUtil;
import com.pingidentity.admin.api.model.IdpToSpAdapterMapping;
import com.pingidentity.admin.api.validator.IdpToSpAdapterMappingValidator;
import com.pingidentity.dependency.error.AffectedItemType;
import com.pingidentity.dependency.error.DependencyErrorValidatorImpl;
import com.pingidentity.dependency.error.mgmt.DependencyError;
import com.pingidentity.fsm.tasklet.data.DependencyType;
import com.pingidentity.pf.admin.rest.translator.IdpToSpAdapterMappingTranslator;
import com.pingidentity.pf.common.api.validator.ValidatorContext;
import java.util.Collection;
import java.util.List;
import org.sourceid.a2a.domain.Direct2SpAdapterMapping;
import org.sourceid.saml20.domain.AuthnAdapterInstance;
import org.sourceid.saml20.domain.IdpAuthnAdapterInstance;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class IdpToSpAdapterMappingDepErrorValidatorImpl
extends DependencyErrorValidatorImpl {
    @Override
    public void getDependencyErrors(Object causedByItem, Collection<DependencyError> existingErrors) {
        if (causedByItem instanceof IdpAuthnAdapterInstance) {
            this.validateIdpAdapterChanges((IdpAuthnAdapterInstance)causedByItem, existingErrors);
        } else if (causedByItem instanceof AuthnAdapterInstance) {
            this.validateSPAdapterChanges((AuthnAdapterInstance)causedByItem, existingErrors);
        }
    }

    private void validateSPAdapterChanges(AuthnAdapterInstance causedByItem, Collection<DependencyError> existingErrors) {
        AuthnAdapterInstance adapter = causedByItem;
        List mappings = MgmtFactory.getAdapter2AdapterManager().getMappingsUsingTarget(adapter.getId());
        for (Direct2SpAdapterMapping mapping : mappings) {
            IdpToSpAdapterMappingTranslator translator = new IdpToSpAdapterMappingTranslator();
            IdpToSpAdapterMapping apiMapping = translator.domainToApi(mapping);
            IdpToSpAdapterMappingTranslator.cleanupContractFulfillmentMapping((IdpToSpAdapterMapping)apiMapping);
            IdpToSpAdapterMappingValidator validator = new IdpToSpAdapterMappingValidator(apiMapping, true, new ValidatorContext(true, this.isEaAdmin(), true));
            DependencyError error = new DependencyError(ApiUtil.combineId((String)mapping.getSourceId(), (String)mapping.getTargetId()), DependencyType.SP_ADAPTER, adapter.getId(), AffectedItemType.IDP_TO_SP_ADAPTER_MAPPING);
            if (validator.validate()) {
                existingErrors.removeIf(dependencyError -> dependencyError.equals((Object)error));
                continue;
            }
            if (existingErrors.contains(error)) continue;
            existingErrors.add(error);
        }
    }

    private void validateIdpAdapterChanges(IdpAuthnAdapterInstance causedByItem, Collection<DependencyError> existingErrors) {
        IdpAuthnAdapterInstance adapter = causedByItem;
        List mappings = MgmtFactory.getAdapter2AdapterManager().getMappingsMappedToSource(adapter.getId());
        for (Direct2SpAdapterMapping mapping : mappings) {
            IdpToSpAdapterMappingTranslator translator = new IdpToSpAdapterMappingTranslator();
            IdpToSpAdapterMapping apiMapping = translator.domainToApi(mapping);
            IdpToSpAdapterMappingValidator validator = new IdpToSpAdapterMappingValidator(apiMapping, true, new ValidatorContext(true, this.isEaAdmin(), true));
            DependencyError error = new DependencyError(ApiUtil.combineId((String)mapping.getSourceId(), (String)mapping.getTargetId()), DependencyType.IDP_ADAPTER, adapter.getId(), AffectedItemType.IDP_TO_SP_ADAPTER_MAPPING);
            if (validator.validate()) {
                existingErrors.removeIf(dependencyError -> dependencyError.equals((Object)error));
                continue;
            }
            if (existingErrors.contains(error)) continue;
            existingErrors.add(error);
        }
    }

    @Override
    public boolean requiresConnectionValidation() {
        return false;
    }
}

