/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.dependency.error.validator.impl;

import com.pingidentity.dependency.error.AffectedItemType;
import com.pingidentity.dependency.error.DependencyErrorValidatorImpl;
import com.pingidentity.dependency.error.mgmt.DependencyError;
import com.pingidentity.fsm.tasklet.data.DependencyType;
import com.pingidentity.provisioner.domain.ProvisionerGlobalSettings;
import com.pingidentity.provisioner.domain.mgmt.ProvisionerConfig;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.domain.LocalSettings;
import org.sourceid.saml20.domain.SpConnection;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.websso.Protocol;
import org.sourceid.wstrust.mgmt.TokenGeneratorInstance;
import org.sourceid.wstrust.mgmt.TokenGeneratorManager;
import org.sourceid.wstrust.mgmt.TokenPluginManager;
import org.sourceid.wstrust.mgmt.TokenProcessorInstance;
import org.sourceid.wstrust.mgmt.TokenProcessorManager;
import org.sourceid.wstrust.model.WsTrustTokenType;

public class ProtocolSettingsDepErrorValidatorImpl
extends DependencyErrorValidatorImpl {
    @Override
    public void getDependencyErrors(Object causedByItem, Collection<DependencyError> existingErrors) {
        DependencyError depError;
        TokenGeneratorManager tokenGeneratorManager;
        if (causedByItem instanceof ConnectionBase) {
            DependencyError depError2;
            ProvisionerGlobalSettings pvSettings;
            ProvisionerConfig provisionerConfig;
            String wsFedRealm;
            String saml1xIssuer;
            DependencyError depError3;
            String entityId;
            DependencyType dependencyType = causedByItem instanceof SpConnection ? DependencyType.SP_CONNECTION : DependencyType.IDP_CONNECTION;
            ConnectionBase connection = (ConnectionBase)causedByItem;
            LocalSettings localSettings = MgmtFactory.getLocalSettingsManager().getLocalSettings();
            if (Protocol.SAML20.equals((Object)connection.getProtocol()) && StringUtils.isBlank((String)(entityId = localSettings.getEntityId())) && !existingErrors.contains(depError3 = new DependencyError("Protocol Settings", dependencyType, connection.getId(), AffectedItemType.PROTOCOL_SETTINGS))) {
                existingErrors.add(depError3);
            }
            if ((Protocol.SAML10.equals((Object)connection.getProtocol()) || Protocol.SAML11.equals((Object)connection.getProtocol()) || connection.doesWsTrustSettingsExist()) && StringUtils.isBlank((String)(saml1xIssuer = localSettings.getSaml1xId())) && !existingErrors.contains(depError3 = new DependencyError("Protocol Settings", dependencyType, connection.getId(), AffectedItemType.PROTOCOL_SETTINGS))) {
                existingErrors.add(depError3);
            }
            if (Protocol.WSFED.equals((Object)connection.getProtocol()) && StringUtils.isBlank((String)(wsFedRealm = localSettings.getWsfedRealm())) && !existingErrors.contains(depError3 = new DependencyError("Protocol Settings", dependencyType, connection.getId(), AffectedItemType.PROTOCOL_SETTINGS))) {
                existingErrors.add(depError3);
            }
            if (causedByItem instanceof SpConnection && (provisionerConfig = (ProvisionerConfig)connection.getModuleConfiguration(ProvisionerConfig.class)) != null && StringUtils.isBlank((String)(pvSettings = (ProvisionerGlobalSettings)localSettings.getConnectionModuleGlobalConfiguration(ProvisionerGlobalSettings.class)).getInternalDataSourceId()) && !existingErrors.contains(depError2 = new DependencyError("Protocol Settings", DependencyType.SP_CONNECTION, connection.getId(), AffectedItemType.PROTOCOL_SETTINGS))) {
                existingErrors.add(depError2);
            }
        } else if (causedByItem instanceof TokenProcessorInstance) {
            DependencyError depError4;
            TokenProcessorManager tokenProcessorManager = MgmtFactory.getTokenProcessorManager();
            if (tokenProcessorManager.getInstances().size() > 0 && this.isFederationInfoDependencyErrorForTokenPlugin((TokenPluginManager)tokenProcessorManager) && !existingErrors.contains(depError4 = new DependencyError("Protocol Settings", DependencyType.TOKEN_PROCESSOR, ((TokenProcessorInstance)causedByItem).getId(), AffectedItemType.PROTOCOL_SETTINGS))) {
                existingErrors.add(depError4);
            }
        } else if (causedByItem instanceof TokenGeneratorInstance && this.isFederationInfoDependencyErrorForTokenPlugin((TokenPluginManager)(tokenGeneratorManager = MgmtFactory.getTokenGeneratorManager())) && !existingErrors.contains(depError = new DependencyError("Protocol Settings", DependencyType.TOKEN_GENERATOR, ((TokenGeneratorInstance)causedByItem).getId(), AffectedItemType.PROTOCOL_SETTINGS))) {
            existingErrors.add(depError);
        }
    }

    private boolean isFederationInfoDependencyErrorForTokenPlugin(TokenPluginManager tokenPluginManager) {
        LocalSettings localSettings = MgmtFactory.getLocalSettingsManager().getLocalSettings();
        String saml1xIssuer = localSettings.getSaml1xId();
        String saml20EntityId = localSettings.getEntityId();
        return StringUtils.isBlank((String)saml1xIssuer) && tokenPluginManager.getInstancesForTokenType(WsTrustTokenType.SAML11.getUri()).size() > 0 || StringUtils.isBlank((String)saml20EntityId) && tokenPluginManager.getInstancesForTokenType(WsTrustTokenType.SAML20.getUri()).size() > 0;
    }

    @Override
    public boolean requiresConnectionValidation() {
        return false;
    }
}

